/*
 * Decompiled with CFR 0.152.
 */
package org.interldap.lsc;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;
import org.apache.log4j.Logger;
import org.interldap.lsc.jndi.JndiServices;

public abstract class AbstractGenerator {
    public static final Logger LOGGER = Logger.getLogger(AbstractGenerator.class);
    protected String destination;
    protected String className;
    protected String packageName;
    protected String separator = "/";
    protected List<String> ocs;
    protected List<String> attrs;

    public abstract boolean generate(String var1) throws NamingException;

    public String getClassName() {
        return this.className;
    }

    public String getFileName() {
        return this.getPackagePath() + this.separator + this.getClassName() + ".java";
    }

    public abstract String getGenericPackageName();

    public String getPackageName() {
        return this.packageName;
    }

    public String getPackagePath() {
        String packageName = this.getPackageName();
        String mainLocation = null;
        mainLocation = this.destination != null ? this.destination : System.getProperty("user.dir") + this.separator + "src" + this.separator + "impl" + this.separator + "java";
        return mainLocation + this.separator + packageName.replaceAll("\\.", this.separator);
    }

    public boolean init() throws NamingException {
        JndiServices js = JndiServices.getInstance();
        Map<String, List<String>> ocsTemp = js.getSchema(new String[]{"objectclasses"});
        Map<String, List<String>> atsTemp = js.getSchema(new String[]{"attributetypes"});
        if (ocsTemp == null || ocsTemp.keySet().size() == 0 || atsTemp == null || atsTemp.keySet().size() == 0) {
            LOGGER.error((Object)"Unable to read objectclasses or attributetypes in ldap schema ! Exiting ...");
            return false;
        }
        this.ocs = ocsTemp.values().iterator().next();
        this.attrs = atsTemp.values().iterator().next();
        return true;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    protected abstract String generateContent();

    protected boolean writeContent(String content) {
        String fileName = this.getFileName();
        File file = new File(fileName);
        LOGGER.info((Object)("Creating file (" + fileName + ") ..."));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("\n---------------\n" + content + "---------------\n"));
        }
        try {
            if (file.exists()) {
                LOGGER.warn((Object)("File generation failed: file (" + fileName + ") already exists."));
            } else {
                if (file.createNewFile()) {
                    FileOutputStream os = new FileOutputStream(file);
                    os.write(content.getBytes());
                    return true;
                }
                LOGGER.error((Object)("File generation failed: file (" + fileName + ") could not be created (probably a rights issue)."));
            }
        }
        catch (FileNotFoundException fnfe) {
            LOGGER.error((Object)fnfe, (Throwable)fnfe);
        }
        catch (IOException e) {
            LOGGER.error((Object)e, (Throwable)e);
        }
        return false;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }
}

