/*
 * Decompiled with CFR 0.152.
 */
package org.interldap.lsc;

import java.util.Iterator;
import javax.naming.NamingException;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.interldap.lsc.beans.AbstractBean;
import org.interldap.lsc.beans.BeanComparator;
import org.interldap.lsc.beans.syncoptions.ForceSyncOptions;
import org.interldap.lsc.beans.syncoptions.ISyncOptions;
import org.interldap.lsc.beans.syncoptions.SyncOptionsFactory;
import org.interldap.lsc.jndi.IJndiDstService;
import org.interldap.lsc.jndi.IJndiSrcService;
import org.interldap.lsc.jndi.JndiModifications;
import org.interldap.lsc.jndi.JndiServices;
import org.interldap.lsc.objects.flat.fTop;
import org.interldap.lsc.objects.top;
import org.interldap.lsc.service.IJdbcSrcService;
import org.linagora.interldap.common.I18n;
import org.linagora.interldap.common.InterLDAPStructuralLogger;

public abstract class AbstractSynchronize {
    public static final String LOG4J_CONFIGURATION_FILE = "log4j.properties";
    private static Logger LOGGER = Logger.getLogger(AbstractSynchronize.class);

    protected void cleanDb2Ldap(IJdbcSrcService jdbcService, IJndiDstService dstJndiService) {
        try {
            Iterator<String> ids = dstJndiService.getIdsList();
            while (ids.hasNext()) {
                String id = ids.next();
                fTop object = jdbcService.getFlatObject(id);
                if (object != null) continue;
                AbstractBean bean = dstJndiService.getBean(id);
                JndiModifications jm = new JndiModifications(1);
                jm.setDistinguishName(bean.getDistinguishName());
                JndiServices.getInstance().apply(jm);
                InterLDAPStructuralLogger.LSC.info((Object)I18n.getMessage(null, (String)"org.interldap.lsc.messages.REMOVE_ENTRY", (Object[])new Object[]{id, dstJndiService.getClass().getName()}));
            }
        }
        catch (NamingException e) {
            LOGGER.error((Object)("Unable to clean objects (" + e.toString() + ")"), (Throwable)e);
        }
    }

    protected void cleanLdap2Ldap(IJndiSrcService srcJndiService, IJndiDstService dstJndiService) {
        try {
            Iterator<String> ids = dstJndiService.getIdsList();
            while (ids.hasNext()) {
                String id = ids.next();
                top object = srcJndiService.getObject(id);
                if (object != null) continue;
                JndiModifications jm = new JndiModifications(1);
                jm.setDistinguishName(dstJndiService.getBean(id).getDistinguishName());
                JndiServices.getInstance().apply(jm);
                InterLDAPStructuralLogger.LSC.info((Object)("Removing entry for id=" + id + " from " + dstJndiService.getClass().getName()));
            }
        }
        catch (NamingException e) {
            LOGGER.error((Object)("Unable to clean objects (" + e.toString() + ")"), (Throwable)e);
        }
    }

    protected void synchronizeDb2Ldap(IJdbcSrcService jdbcService, IJndiDstService dstJndiService, top object, Class objectBean) {
        this.synchronizeDb2Ldap("", jdbcService, dstJndiService, object, objectBean);
    }

    protected void synchronizeDb2Ldap(String syncName, IJdbcSrcService jdbcService, IJndiDstService dstJndiService, top object, Class objectBean) {
        ISyncOptions syncOptions = SyncOptionsFactory.getInstance(syncName);
        if (syncOptions == null) {
            if (syncName == null || syncName.length() == 0) {
                LOGGER.info((Object)"No SyncOptions configuration. Defaulting to Force policy ...");
            } else {
                LOGGER.warn((Object)("Unknown '" + syncName + "' synchronization task name. Defaulting to Force policy ..."));
            }
            syncOptions = new ForceSyncOptions();
        }
        int countAll = 0;
        int countError = 0;
        int countInitiated = 0;
        int countCompleted = 0;
        Iterator<String> ids = jdbcService.getIdsList();
        JndiModifications jm = null;
        while (ids.hasNext()) {
            jm = null;
            ++countAll;
            String id = ids.next();
            LOGGER.info((Object)("Synchronizing " + syncName + " for id=" + id));
            try {
                AbstractBean jndiSt;
                fTop fObj = jdbcService.getFlatObject(id);
                if (fObj == null) {
                    ++countError;
                    LOGGER.error((Object)("Unable to get object from database for id=" + id + " in " + syncName + " synchronize process"));
                    continue;
                }
                object = (top)object.getClass().newInstance();
                object.setUpFromObject(fObj);
                AbstractBean jdbcSt = (AbstractBean)objectBean.getMethod("getInstance", object.getClass()).invoke(null, object);
                jm = BeanComparator.calculateModifications(syncOptions, jdbcSt, jndiSt = dstJndiService.getBean(id));
                if (jm == null) continue;
                ++countInitiated;
                if (JndiServices.getInstance().apply(jm)) {
                    ++countCompleted;
                    this.logAction(jm, id, syncName);
                    continue;
                }
                this.logActionError(jm, id, null);
            }
            catch (RuntimeException e) {
                ++countError;
                this.logActionError(jm, id, e);
            }
            catch (Exception e) {
                ++countError;
                this.logActionError(jm, id, e);
            }
            catch (Throwable e) {
                ++countError;
                this.logActionError(jm, id, e);
            }
        }
        InterLDAPStructuralLogger.LSC.info((Object)I18n.getMessage(null, (String)"org.interldap.lsc.messages.NB_CHANGES", (Object[])new Object[]{countAll, countInitiated, countCompleted, countError}));
    }

    protected void synchronizeLdap2Ldap(IJndiSrcService srcJndiService, IJndiDstService dstJndiService, top object, Class objectBean) {
        this.synchronizeLdap2Ldap("", srcJndiService, dstJndiService, object, objectBean);
    }

    protected void synchronizeLdap2Ldap(String syncName, IJndiSrcService srcJndiService, IJndiDstService dstJndiService, top object, Class objectBean) {
        ISyncOptions syncOptions = SyncOptionsFactory.getInstance(syncName);
        if (syncOptions == null) {
            LOGGER.warn((Object)("Unknown '" + syncName + "' synchronization task name. Defaulting to ForcedOptions ..."));
            syncOptions = new ForceSyncOptions();
        }
        Iterator<String> ids = null;
        try {
            ids = srcJndiService.getIdsList();
        }
        catch (NamingException e1) {
            LOGGER.fatal((Object)("Unable to find any object for service " + srcJndiService.getClass().getName()));
            return;
        }
        if (!ids.hasNext()) {
            LOGGER.error((Object)("Empty or non existant data source : " + srcJndiService));
            return;
        }
        int countAll = 0;
        int countError = 0;
        int countInitiated = 0;
        int countCompleted = 0;
        JndiModifications jm = null;
        while (ids.hasNext()) {
            ++countAll;
            String id = ids.next();
            try {
                AbstractBean dstJndiSt;
                object = srcJndiService.getObject(id);
                if (object == null) {
                    ++countError;
                    LOGGER.error((Object)("Unable to get object from directory for id=" + id));
                    continue;
                }
                AbstractBean srcJndiSt = (AbstractBean)objectBean.getMethod("getInstance", object.getClass()).invoke(null, object);
                jm = BeanComparator.calculateModifications(syncOptions, srcJndiSt, dstJndiSt = dstJndiService.getBean(id));
                if (jm == null) continue;
                ++countInitiated;
                if (JndiServices.getInstance().apply(jm)) {
                    ++countCompleted;
                    this.logAction(jm, id, syncName);
                    continue;
                }
                this.logActionError(jm, id, null);
            }
            catch (RuntimeException e) {
                ++countError;
                this.logActionError(jm, id, e);
            }
            catch (Exception e) {
                ++countError;
                this.logActionError(jm, id, e);
            }
            catch (Throwable e) {
                ++countError;
                this.logActionError(jm, id, e);
            }
        }
        InterLDAPStructuralLogger.LSC.info((Object)I18n.getMessage(null, (String)"org.interldap.lsc.messages.NB_CHANGES", (Object[])new Object[]{countAll, countInitiated, countCompleted, countError}));
    }

    protected void logActionError(JndiModifications jm, String id, Throwable e) {
        InterLDAPStructuralLogger.LSC.info((Object)I18n.getMessage(null, (String)"org.interldap.lsc.messages.SYNC_ERROR", (Object[])new Object[]{id, e != null ? e.toString() : "", ""}));
        InterLDAPStructuralLogger.LSC.info((Object)jm);
    }

    protected void logAction(JndiModifications jm, String id, String syncName) {
        switch (jm.getOperation()) {
            case 0: {
                InterLDAPStructuralLogger.LSC.info((Object)I18n.getMessage(null, (String)"org.interldap.lsc.messages.ADD_ENTRY", (Object[])new Object[]{id, syncName}));
                break;
            }
            case 2: {
                InterLDAPStructuralLogger.LSC.info((Object)I18n.getMessage(null, (String)"org.interldap.lsc.messages.UPDATE_ENTRY", (Object[])new Object[]{id, syncName}));
                break;
            }
            case 3: {
                InterLDAPStructuralLogger.LSC.info((Object)I18n.getMessage(null, (String)"org.interldap.lsc.messages.RENAME_ENTRY", (Object[])new Object[]{id, syncName}));
                break;
            }
            default: {
                InterLDAPStructuralLogger.LSC.info((Object)I18n.getMessage(null, (String)"org.interldap.lsc.messages.UNKNOWN_CHANGE", (Object[])new Object[]{id, syncName}));
            }
        }
        InterLDAPStructuralLogger.LSC.info((Object)jm);
    }

    static {
        PropertyConfigurator.configure((String)LOG4J_CONFIGURATION_FILE);
    }
}

