/*
 * Decompiled with CFR 0.152.
 */
package org.interldap.lsc;

import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class Configuration {
    protected static Logger LOGGER = Logger.getLogger(Configuration.class);
    public static final String LSC_PROPERTIES = "lsc.properties";
    public static final String DN_PEOPLE = Configuration.getString("dn.people", "ou=People");
    public static final String DN_LDAP_SCHEMA = Configuration.getString("dn.ldap_schema", "cn=Subschema");
    public static final String DN_ENHANCED_SCHEMA = Configuration.getString("dn.ldap_schema", "ou=Schema,ou=System");
    public static final String DN_STRUCTURES = Configuration.getString("dn.structures", "ou=Structures");
    public static final String DN_ACCOUNTS = Configuration.getString("dn.accounts", "ou=Accounts");
    public static final String OBJECTCLASS_PERSONNE = Configuration.getString("objectclass.person", "inetOrgPerson");
    public static final String OBJECTCLASS_EMPLOYEE = Configuration.getString("objectclass.employee", "inetOrgPerson");
    public static final int DAYS_BEFORE_SUPPRESSION = Configuration.getInt("suppression.MARQUAGE_NOMBRE_DE_JOURS", 90);
    public static final String DN_REAL_ROOT = Configuration.getString("dn.real_root", "dc=interldap,dc=org");
    public static final int UID_MAX_LENGTH = Configuration.getInt("uid.maxlength", 8);
    private static org.apache.commons.configuration.Configuration config = null;

    protected Configuration() {
    }

    public static Properties getLdapProperties() {
        return Configuration.getAsProperties("ldap");
    }

    public static Properties getAsProperties(String prefix) {
        org.apache.commons.configuration.Configuration conf = Configuration.getConfiguration().subset(prefix);
        if (conf == null) {
            return null;
        }
        Iterator it = conf.getKeys();
        Properties result = new Properties();
        while (it.hasNext()) {
            String key = (String)it.next();
            Object value = conf.getProperty(key);
            value = Configuration.asString(value);
            result.put(key, value);
        }
        return result;
    }

    private static org.apache.commons.configuration.Configuration getConfiguration() {
        if (config == null) {
            try {
                Configuration.setConfiguration(Configuration.class, LSC_PROPERTIES);
            }
            catch (ConfigurationException e) {
                throw new ExceptionInInitializerError(e);
            }
        }
        return config;
    }

    public static int getInt(String key) {
        return Configuration.getConfiguration().getInt(key);
    }

    public static int getInt(String key, int defaultValue) {
        return Configuration.getConfiguration().getInt(key, defaultValue);
    }

    public static boolean getBoolean(String key) {
        return Configuration.getConfiguration().getBoolean(key);
    }

    public static boolean getBoolean(String key, boolean defaultValue) {
        return Configuration.getConfiguration().getBoolean(key, defaultValue);
    }

    public static String getString(String key) {
        Object o = Configuration.getConfiguration().getProperty(key);
        return Configuration.asString(o);
    }

    public static String getString(String key, String defaultValue) {
        Object o = Configuration.getConfiguration().getProperty(key);
        if (o == null) {
            return defaultValue;
        }
        return Configuration.asString(o);
    }

    private static String asString(Object value) {
        if (value instanceof List) {
            List list = (List)value;
            value = StringUtils.join(list.iterator(), (char)',');
        }
        return (String)value;
    }

    static void setConfiguration(Class clazz, String name) throws ConfigurationException {
        LOGGER.debug((Object)("Loading configuration file : " + name));
        config = new PropertiesConfiguration(name);
    }
}

