/*
 * Decompiled with CFR 0.152.
 */
package org.interldap.lsc;

import javax.naming.NamingException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.interldap.lsc.beans.BeanGenerator;
import org.interldap.lsc.jndi.JndiSrcObjectGenerator;
import org.interldap.lsc.objects.ObjectClassGenerator;
import org.interldap.lsc.service.JdbcServiceObjectGenerator;

public final class Generator {
    public static final String LOG4J_CONFIGURATION_FILE = "log4j.properties";
    private static Logger LOGGER = Logger.getLogger(Generator.class);
    private String srcClassName;
    private String dstClassName;
    private String destination;
    private GEN_TYPE genType;

    private Generator() {
    }

    private void launch() throws NamingException {
        BeanGenerator.run(this.srcClassName, this.destination);
        JndiSrcObjectGenerator.run(this.srcClassName, this.destination);
        if (this.genType == GEN_TYPE.LDAP2LDAP) {
            JndiSrcObjectGenerator.run(this.dstClassName, this.destination);
        }
        ObjectClassGenerator.run(this.srcClassName, this.destination);
        if (this.genType == GEN_TYPE.LDAP2LDAP) {
            ObjectClassGenerator.run(this.dstClassName, this.destination);
        } else {
            JdbcServiceObjectGenerator.run(this.srcClassName, this.destination);
        }
    }

    public static void main(String[] args) throws NamingException {
        PropertyConfigurator.configure((String)LOG4J_CONFIGURATION_FILE);
        Generator instance = new Generator();
        if (instance.parseArgs(args) == 0) {
            instance.launch();
        }
    }

    private static void printHelp() {
        System.err.println("Usage:");
        System.err.println("\tant -Dgenerator.parameters=\"-doc='localObjectClass' -db\" lsc::generator\n");
    }

    private int parseArgs(String[] args) {
        block8: {
            Options options = new Options();
            OptionGroup ocOption = new OptionGroup();
            ocOption.setRequired(true);
            ocOption.addOption(new Option("soc", "sourceOcName", true, "Specify the source object class name"));
            ocOption.addOption(new Option("doc", "destOcName", true, "Specify the destination object class name"));
            options.addOptionGroup(ocOption);
            options.addOption("c", "ocName", true, "Specify the object class name");
            options.addOption("d", "dest", true, "Specify the destination");
            options.addOption("l", "ldap2ldap", false, "Specify the destination");
            OptionGroup genTypeOption = new OptionGroup();
            genTypeOption.setRequired(true);
            genTypeOption.addOption(new Option("ld", "ldap2ldap", false, "Generate a LDAP to LDAP engine skeleton"));
            genTypeOption.addOption(new Option("db", "ldap2database", false, "Generate a LDAP to Database engine skeleton"));
            options.addOptionGroup(genTypeOption);
            GnuParser parser = new GnuParser();
            try {
                CommandLine cmdLine = parser.parse(options, args);
                if (cmdLine.getOptions().length > 0) {
                    if (cmdLine.hasOption("soc")) {
                        this.srcClassName = cmdLine.getOptionValue("soc");
                    }
                    if (cmdLine.hasOption("doc")) {
                        this.dstClassName = cmdLine.getOptionValue("doc");
                    }
                    if (cmdLine.hasOption("d")) {
                        this.destination = cmdLine.getOptionValue("d");
                    }
                    this.genType = cmdLine.hasOption("ld") ? GEN_TYPE.LDAP2LDAP : (cmdLine.hasOption("db") ? GEN_TYPE.LDAP2DATABASE : GEN_TYPE.UNKNOWN);
                    if (this.srcClassName == null || this.destination == null || this.genType == GEN_TYPE.UNKNOWN) {
                        Generator.printHelp();
                        return 1;
                    }
                    break block8;
                }
                Generator.printHelp();
                return 1;
            }
            catch (MissingOptionException e) {
                LOGGER.fatal((Object)("You must call this program with the required arguments :" + (Object)((Object)e)), (Throwable)e);
                return 1;
            }
            catch (ParseException e) {
                LOGGER.fatal((Object)("Unable to parse options : " + args + " (" + (Object)((Object)e) + ")"), (Throwable)e);
                return 1;
            }
        }
        return 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GEN_TYPE {
        LDAP2LDAP,
        LDAP2DATABASE,
        UNKNOWN;

    }
}

