/*
 * Decompiled with CFR 0.152.
 */
package org.interldap.lsc.beans;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.SearchResult;
import org.apache.log4j.Logger;
import org.interldap.lsc.beans.IBean;
import org.interldap.lsc.objects.top;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBean
implements IBean {
    private Map<String, Attribute> attrs = new HashMap<String, Attribute>();
    private String distinguishName;
    private static Logger LOGGER = Logger.getLogger(AbstractBean.class);
    public static String GET_ACCESSOR_PREFIX = "get";
    public static String MAP_FUNCTION_PREFIX = "map";
    public static String SET_ACCESSOR_PREFIX = "set";
    protected static Map<String, Method> localMethods;

    public static void mapper(Class cl, Map<String, Method> localMethods, IBean bean, Object o) throws IllegalAccessException, InvocationTargetException {
        localMethods = new HashMap<String, Method>();
        AbstractBean.loadLocalMethods(cl, localMethods, MAP_FUNCTION_PREFIX);
        Method[] methods = o.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().startsWith(GET_ACCESSOR_PREFIX) || methods[i].getName().substring(GET_ACCESSOR_PREFIX.length()).compareToIgnoreCase("dn") == 0) continue;
            String paramName = methods[i].getName().substring(GET_ACCESSOR_PREFIX.length());
            paramName = paramName.substring(0, 1).toLowerCase() + paramName.substring(1);
            Class<?> returnType = methods[i].getReturnType();
            Method localMethod = localMethods.get(paramName);
            if (localMethod != null) {
                Object o2 = methods[i].invoke(o, new Object[0]);
                Object[] params = new Object[]{o, bean, o2};
                Class<?>[] paramsType = localMethod.getParameterTypes();
                try {
                    localMethod.invoke((Object)bean, params);
                }
                catch (IllegalArgumentException iae) {
                    if (o2 != null) {
                        LOGGER.error((Object)("Unable to invoke the method because values class differs : bean wait for " + paramsType[2].getName() + " where as object can provide " + o2.getClass().getName() + " in method " + localMethod.toString() + " (" + iae + ")"), (Throwable)iae);
                        continue;
                    }
                    LOGGER.error((Object)("Unable to invoke the method because values class differs : bean wait for " + paramsType[2].getName() + " where as object is null " + " in method " + localMethod.toString() + " (" + iae + ")"), (Throwable)iae);
                }
                continue;
            }
            if (returnType == String.class) {
                AbstractBean.mapString(bean, paramName, (String)methods[i].invoke(o, new Object[0]));
                continue;
            }
            if (returnType == Integer.class) {
                AbstractBean.mapString(bean, paramName, ((Integer)methods[i].invoke(o, new Object[0])).toString());
                continue;
            }
            if (returnType == Boolean.class) {
                boolean bValue = (Boolean)methods[i].invoke(o, new Object[0]);
                if (bValue) {
                    AbstractBean.mapString(bean, paramName, "TRUE");
                    continue;
                }
                AbstractBean.mapString(bean, paramName, "FALSE");
                continue;
            }
            if (List.class.isAssignableFrom(returnType)) {
                AbstractBean.mapList(bean, paramName, (List)methods[i].invoke(o, new Object[0]));
                continue;
            }
            if (!Map.class.isAssignableFrom(returnType)) continue;
            AbstractBean.mapMap(bean, paramName, (Map)methods[i].invoke(o, new Object[0]));
        }
    }

    public static void loadLocalMethods(Class cl, Map<String, Method> lMs, String prefix) {
        Method[] methods = cl.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().startsWith(prefix)) continue;
            String paramName = methods[i].getName().substring(prefix.length());
            paramName = paramName.substring(0, 1).toLowerCase() + paramName.substring(1);
            lMs.put(paramName, methods[i]);
        }
    }

    protected static void mapList(IBean bean, String paramName, List values) {
        BasicAttribute attr = new BasicAttribute(paramName);
        if (values != null) {
            Iterator iter = values.iterator();
            while (iter.hasNext()) {
                String value = ((String)iter.next()).trim();
                if (value.length() <= 0) continue;
                attr.add(value);
            }
        }
        bean.setAttribute(attr);
    }

    protected static void mapMap(IBean bean, String paramName, Map values) {
        BasicAttribute attr = new BasicAttribute(paramName);
        if (values != null) {
            for (String key : values.keySet()) {
                List codesValues = (List)values.get(key);
                Iterator codesValuesIter = codesValues.iterator();
                while (codesValuesIter.hasNext()) {
                    attr.add("{" + key.trim() + "}" + ((String)codesValuesIter.next()).trim());
                }
            }
        }
        bean.setAttribute(attr);
    }

    protected static void mapString(IBean bean, String paramName, String value) {
        BasicAttribute attr = new BasicAttribute(paramName);
        if (value != null && value.trim().length() > 0) {
            attr.add(value.trim());
        }
        bean.setAttribute(attr);
    }

    public void mapDistinguishName(top t, IBean destBean, String value) {
        destBean.setDistinguishName(value);
    }

    public static AbstractBean getInstance(SearchResult entry, String baseDn, Class c) throws NamingException {
        try {
            if (entry != null) {
                AbstractBean ab = (AbstractBean)c.newInstance();
                String dn = entry.getName();
                if (dn.length() > 0 && dn.charAt(0) == '\"' && dn.charAt(dn.length() - 1) == '\"') {
                    dn = dn.substring(1, dn.length() - 1);
                }
                ab.setDistinguishName(dn + (baseDn != null && baseDn.length() != 0 ? (dn.length() > 0 ? "," : "") + baseDn : ""));
                NamingEnumeration<? extends Attribute> ne = entry.getAttributes().getAll();
                while (ne.hasMore()) {
                    ab.setAttribute(ne.next());
                }
                return ab;
            }
            return null;
        }
        catch (InstantiationException ie) {
            LOGGER.error((Object)ie, (Throwable)ie);
        }
        catch (IllegalAccessException iae) {
            LOGGER.error((Object)iae, (Throwable)iae);
        }
        return null;
    }

    @Override
    public final Attribute getAttributeById(String id) {
        return this.attrs.get(id);
    }

    @Override
    public final Set getAttributesNames() {
        return this.attrs.keySet();
    }

    @Override
    public final void setAttribute(Attribute attr) {
        this.attrs.put(attr.getID(), attr);
    }

    @Override
    public final String getDistinguishName() {
        return this.distinguishName;
    }

    @Override
    public final void setDistinguishName(String dn) {
        this.distinguishName = dn;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Iterator<String> keySetIter = this.attrs.keySet().iterator();
        sb.append("dn: ").append(this.distinguishName).append('\n');
        while (keySetIter.hasNext()) {
            String key = keySetIter.next();
            if (this.attrs.get(key) == null) continue;
            sb.append("=> " + key);
            Attribute values = this.attrs.get(key);
            if (values instanceof List) {
                Iterator valuesIter = ((List)((Object)values)).iterator();
                while (valuesIter.hasNext()) {
                    sb.append(" - ").append(valuesIter.next()).append("\n");
                }
                continue;
            }
            sb.append(" - ").append(values).append("\n");
        }
        return sb.toString();
    }
}

