/*
 * Decompiled with CFR 0.152.
 */
package org.interldap.lsc.beans;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.ModificationItem;
import org.apache.log4j.Logger;
import org.interldap.lsc.Configuration;
import org.interldap.lsc.beans.IBean;
import org.interldap.lsc.beans.syncoptions.ISyncOptions;
import org.interldap.lsc.jndi.JndiModifications;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BeanComparator {
    private static Logger LOGGER = Logger.getLogger(BeanComparator.class);

    private BeanComparator() {
    }

    public static JndiModifications calculateModifications(ISyncOptions syncOptions, IBean srcBean, IBean destBean) throws NamingException {
        JndiModifications jm = null;
        if (srcBean == null && destBean == null) {
            return null;
        }
        if (srcBean == null && destBean != null) {
            jm = new JndiModifications(1);
            jm.setDistinguishName(srcBean.getDistinguishName());
            LOGGER.info((Object)("Deleting entry : \"" + srcBean.getDistinguishName() + "\""));
        } else if (srcBean != null && destBean == null) {
            jm = BeanComparator.getAddEntry(syncOptions, srcBean);
        } else if (srcBean.getDistinguishName() == null || destBean.getDistinguishName().compareToIgnoreCase(srcBean.getDistinguishName()) == 0) {
            jm = BeanComparator.getModifyEntry(syncOptions, srcBean, destBean);
        } else {
            jm = new JndiModifications(3);
            jm.setDistinguishName(destBean.getDistinguishName());
            jm.setNewDistinguishName(srcBean.getDistinguishName());
            LOGGER.warn((Object)"Attention : updating the RDN of the entry with cancel the other modifications !");
        }
        if (jm.getOperation() == 3 || jm.getModificationItems() != null && jm.getModificationItems().size() != 0) {
            return jm;
        }
        return null;
    }

    private static JndiModifications getModifyEntry(ISyncOptions syncOptions, IBean srcJdbcBean, IBean destBean) throws NamingException {
        JndiModifications jm = new JndiModifications(2);
        jm.setDistinguishName(destBean.getDistinguishName());
        Iterator srcBeanAttrsNameIter = srcJdbcBean.getAttributesNames().iterator();
        ArrayList<ModificationItem> modificationItems = new ArrayList<ModificationItem>();
        while (srcBeanAttrsNameIter.hasNext()) {
            String srcAttrName = (String)srcBeanAttrsNameIter.next();
            ModificationItem mi = null;
            Attribute srcAttr = srcJdbcBean.getAttributeById(srcAttrName);
            Attribute destAttr = destBean.getAttributeById(srcAttrName);
            String defaultValue = syncOptions.getDefaultValue(srcJdbcBean.getDistinguishName(), srcAttrName);
            if ((srcAttr == null || srcAttr.size() == 0 || ((String)srcAttr.get(0)).length() == 0) && defaultValue != null) {
                if (srcAttr == null) {
                    srcAttr = new BasicAttribute(srcAttrName);
                }
                while (srcAttr.size() >= 1 && ((String)srcAttr.get(0)).length() == 0) {
                    srcAttr.remove(0);
                }
                srcAttr.add(defaultValue);
            }
            if (syncOptions.getStatus(srcJdbcBean.getDistinguishName(), srcAttrName) != ISyncOptions.STATUS_TYPE.FORCE) continue;
            if ((srcAttr == null || srcAttr.size() == 0) && destAttr != null && destAttr.size() > 0) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Deleting attribute  \"" + srcAttrName + "\" in entry \"" + destBean.getDistinguishName() + "\""));
                }
                mi = new ModificationItem(3, destBean.getAttributeById(srcAttrName));
            } else if (srcAttr != null && srcAttr.size() > 0 && (destAttr == null || destAttr.size() == 0)) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Adding attribute \"" + srcAttrName + "\" in entry \"" + destBean.getDistinguishName() + "\""));
                }
                mi = new ModificationItem(1, srcJdbcBean.getAttributeById(srcAttrName));
            } else if (srcAttr != null && srcAttr.size() != 0 || destAttr != null && destAttr.size() != 0) {
                mi = BeanComparator.compareAttribute(srcAttr, destAttr);
            }
            if (mi == null) continue;
            modificationItems.add(mi);
        }
        if (modificationItems.size() != 0) {
            jm.setModificationItems(modificationItems);
            LOGGER.info((Object)("Modifying entry \"" + destBean.getDistinguishName() + "\""));
        } else {
            LOGGER.debug((Object)("Entry \"" + srcJdbcBean.getDistinguishName() + "\" is the same in the database and in the directory."));
        }
        return jm;
    }

    private static JndiModifications getAddEntry(ISyncOptions syncOptions, IBean srcJdbcBean) throws NamingException {
        JndiModifications jm = new JndiModifications(0);
        if (srcJdbcBean.getDistinguishName() != null) {
            jm.setDistinguishName(srcJdbcBean.getDistinguishName());
        } else {
            LOGGER.warn((Object)"No DN set ! Trying to generate an DN based on the uid attribute !");
            if (srcJdbcBean.getAttributeById("uid") == null || srcJdbcBean.getAttributeById("uid").size() == 0) {
                throw new RuntimeException("-- Developpement error : No RDN found (uid by default) !");
            }
            jm.setDistinguishName("uid=" + srcJdbcBean.getAttributeById("uid").get() + "," + Configuration.DN_PEOPLE);
        }
        Iterator jdbcAttrsName = srcJdbcBean.getAttributesNames().iterator();
        ArrayList<ModificationItem> modificationItems = new ArrayList<ModificationItem>();
        while (jdbcAttrsName.hasNext()) {
            String jdbcAttrName = (String)jdbcAttrsName.next();
            Attribute srcJdbcAttribute = srcJdbcBean.getAttributeById(jdbcAttrName);
            String createValue = syncOptions.getCreateValue(srcJdbcBean.getDistinguishName(), srcJdbcAttribute.getID());
            if (!(createValue == null || srcJdbcAttribute.getAll() != null && srcJdbcAttribute.getAll().hasMore())) {
                srcJdbcAttribute.add(createValue);
            }
            modificationItems.add(new ModificationItem(1, srcJdbcAttribute));
        }
        jm.setModificationItems(modificationItems);
        LOGGER.info((Object)("Adding new entry \"" + jm.getDistinguishName() + "\""));
        return jm;
    }

    private static ModificationItem compareAttribute(Attribute srcAttr, Attribute destAttr) throws NamingException {
        boolean differs = false;
        NamingEnumeration<?> jdbcNe = srcAttr.getAll();
        BasicAttribute toReplaceAttr = new BasicAttribute(srcAttr.getID());
        while (jdbcNe.hasMore()) {
            String value = (String)jdbcNe.next();
            toReplaceAttr.add(value);
            if (destAttr.contains(value)) continue;
            differs = true;
        }
        NamingEnumeration<?> jndiNe = destAttr.getAll();
        while (jndiNe.hasMore()) {
            Object o = jndiNe.next();
            if (o.getClass() == String.class) {
                String value = (String)o;
                if (srcAttr.contains(value)) continue;
                differs = true;
                continue;
            }
            if (o.getClass().isAssignableFrom(List.class)) {
                List values = (List)o;
                if (BeanComparator.compare(values, srcAttr) == 0) continue;
                differs = true;
                continue;
            }
            if (!o.getClass().isAssignableFrom(byte[].class) || srcAttr.contains(new String((byte[])o))) continue;
            differs = true;
        }
        if (differs) {
            return new ModificationItem(2, toReplaceAttr);
        }
        return null;
    }

    private static int compare(List<?> l, Attribute attr) {
        if (l.size() != attr.size()) {
            return l.size() - attr.size();
        }
        Iterator<?> lIter = l.iterator();
        while (lIter.hasNext()) {
            if (attr.contains(lIter.next())) continue;
            return -1;
        }
        return 0;
    }

    public static JndiModifications[] checkOtherModifications(IBean srcBean, IBean destBean, JndiModifications jm) throws IllegalAccessException, InvocationTargetException {
        String methodName = "checkDependencies";
        Class[] params = new Class[]{JndiModifications.class};
        try {
            Method checkDependencies = destBean.getClass().getMethod(methodName, params);
            if (checkDependencies != null) {
                return (JndiModifications[])checkDependencies.invoke((Object)destBean, jm);
            }
        }
        catch (SecurityException e) {
            LOGGER.warn((Object)("Unattended exception has been raised : " + e), (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            LOGGER.debug((Object)("No method \"" + methodName + "\" to manage modification dependencies" + destBean.getClass().getName() + " (" + e + ") on "), (Throwable)e);
        }
        return new JndiModifications[0];
    }
}

