/*
 * Decompiled with CFR 0.152.
 */
package org.interldap.lsc.beans;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.naming.NamingException;
import org.interldap.lsc.AbstractGenerator;
import org.interldap.lsc.jndi.parser.LdapAttributeType;
import org.interldap.lsc.jndi.parser.LdapObjectClass;

public class BeanGenerator
extends AbstractGenerator {
    private String initialName;
    private List<String> monoAttrs;
    private List<String> multiAttrs;

    public boolean generate(String className) throws NamingException {
        if (this.ocs == null || this.ocs.size() <= 0 || this.attrs == null || this.attrs.size() <= 0) {
            LOGGER.error((Object)"Generator have to be initialized");
            return false;
        }
        this.initialName = className;
        this.className = className + "Bean";
        this.packageName = this.getGenericPackageName();
        HashMap<String, LdapAttributeType> ats = new HashMap<String, LdapAttributeType>();
        for (String atStr : this.attrs) {
            LdapAttributeType lat = LdapAttributeType.parse(atStr);
            if (lat == null) continue;
            ats.put(lat.getName(), lat);
        }
        LdapObjectClass myLoc = null;
        Iterator<String> ocIter = this.ocs.iterator();
        while (ocIter.hasNext() && myLoc == null) {
            String ocStr = ocIter.next();
            LdapObjectClass loc = LdapObjectClass.parse(ocStr, ats);
            if (loc == null || loc.getName().compareToIgnoreCase(this.initialName) != 0) continue;
            myLoc = loc;
        }
        if (myLoc != null) {
            this.monoAttrs = myLoc.getMonoAttrs();
            this.multiAttrs = myLoc.getMultiAttrs();
            if (this.writeContent(this.generateContent())) {
                LOGGER.info((Object)("Bean generation successed for " + this.getFileName()));
                return true;
            }
        } else {
            LOGGER.error((Object)("Bean generation failed : LDAP objectClass (" + this.initialName + ") could not be found in LDAP directory."));
        }
        return false;
    }

    public String getGenericPackageName() {
        return this.getClass().getPackage().getName();
    }

    protected String generateContent() {
        String beanClassName = super.getClassName();
        String initialClassName = this.initialName;
        String content = "";
        content = content + "/*\n * Generated - please do not edit manually\n */\n";
        content = content + "package " + this.getPackageName() + ";\n\n";
        content = content + "import java.lang.reflect.InvocationTargetException;\nimport java.lang.reflect.Method;\nimport java.util.HashMap;\nimport java.util.Vector;\n";
        if (this.multiAttrs.size() > 0) {
            content = content + "import java.util.List;\n";
        }
        content = content + "import javax.naming.NamingException;\n\nimport org.interldap.lsc.Configuration;\nimport org.interldap.lsc.jndi.JndiModifications;\nimport org.interldap.lsc.objects." + initialClassName + ";\n\n";
        content = content + "public class " + beanClassName + " extends AbstractBean implements IBean {\n\n";
        content = content + "\tstatic {\n\t\t\tlocalMethods = new HashMap<String,Method>();\n\t}\n\n";
        content = content + "\tpublic static " + beanClassName + " getInstance(" + initialClassName + " myclass) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, NamingException {\n" + "\t\t" + beanClassName + " bean = new " + beanClassName + "() ;\n" + "\t\tAbstractBean.mapper(" + beanClassName + ".class, localMethods, bean, myclass);\n" + "\t\tbean.generateDn();\n" + "\t\treturn bean;\n" + "\t}\n\n";
        content = content + "\tpublic " + beanClassName + "() {\n" + "\t\tsuper();\n" + "\t}\n\n";
        for (String attribute : this.monoAttrs) {
            String attributeName = attribute.substring(0, 1).toUpperCase() + attribute.substring(1);
            content = content + "\tpublic static void map" + attributeName + "(" + initialClassName + " soc, IBean doc, String value) throws NamingException {\n" + "\t\t// Do nothing because it is generated through other map methods !\n" + "\t\t//if (value != null && value.trim().length() > 0) {\n" + "\t\t//\tmapString(doc, \"" + attribute + "\", Filters.filterString(value));\n" + "\t\t//\tgenerate" + attributeName + "(soc, doc);\n" + "\t\t//}\n" + "\t}\n\n";
            content = content + "\tpublic static void generate" + attributeName + "(" + initialClassName + " soc, IBean doc) throws NamingException {\n" + "\t\t// to be completed\n" + "\t\t//String value = \"\";\n" + "\t\t//Attribute attr = new BasicAttribute(\"" + attribute + "\");\n" + "\t\t//attr.add(value);\n" + "\t\t//doc.setAttribute(attr);\n" + "\t}\n\n";
        }
        for (String attribute : this.multiAttrs) {
            String attributeName = attribute.substring(0, 1).toUpperCase() + attribute.substring(1);
            content = content + "\tpublic static void map" + attributeName + "(" + initialClassName + " soc, IBean doc, List values) throws NamingException {\n" + "\t\t// Do nothing because it is generated through other map methods !\n" + "\t\t//if (values != null && values.size() > 0) {\n" + "\t\t//\tVector<String> v = new Vector<String>();\n" + "\t\t//\tIterator valuesIter = values.iterator();\n" + "\t\t//\twhile (valuesIter.hasNext()) {\n" + "\t\t//\t\tString value = (String) values.iterator().next();\n" + "\t\t//\t\tif (value != null && value.trim().length() > 0) {\n" + "\t\t//\t\t\tmapString(doc, \"" + attribute + "\", Filters.filterString(value));\n" + "\t\t//\t\t\tgenerate" + attributeName + "(soc, doc);\n" + "\t\t//\t\t}\n" + "\t\t//\t}\n" + "\t\t//}\n" + "\t}\n\n";
            content = content + "\tpublic static void generate" + attributeName + "(" + initialClassName + " soc, IBean doc) throws NamingException {\n" + "\t\t// to be completed\n" + "\t\t//String value = \"\";\n" + "\t\t//Attribute attr = new BasicAttribute(\"" + attribute + "\");\n" + "\t\t//attr.add(value);\n" + "\t\t//doc.setAttribute(attr);\n" + "\t}\n\n";
        }
        content = content + "\tpublic JndiModifications[] checkDependenciesWith" + initialClassName + "(" + initialClassName + " soc, JndiModifications jm) {\n" + "\t\t// to be completed\n" + "\t\treturn new JndiModifications[] {};\n" + "\t}\n\n";
        content = content + "\tpublic void generateDn() throws NamingException {\n\t\t// to be completed\n\t\tsetDistinguishName(\"uid=\" + getAttributeById(\"uid\").get() + \",\" + Configuration.DN_PEOPLE);\n\t}\n\n";
        content = content + "}\n";
        return content;
    }

    public static void run(String arg, String destination) throws NamingException {
        BeanGenerator beanGenerator = new BeanGenerator();
        beanGenerator.init();
        beanGenerator.setDestination(destination);
        beanGenerator.generate(arg);
    }
}

