/*
 * Decompiled with CFR 0.152.
 */
package org.interldap.lsc.beans;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import javax.naming.NamingException;
import javax.naming.directory.BasicAttribute;
import org.apache.log4j.Logger;
import org.interldap.lsc.Configuration;
import org.interldap.lsc.beans.AbstractBean;
import org.interldap.lsc.beans.IBean;
import org.interldap.lsc.jndi.JndiServices;
import org.interldap.lsc.objects.inetOrgPerson;
import org.interldap.lsc.utils.CharacterUnacceptedException;
import org.interldap.lsc.utils.Filters;

public class inetOrgPersonBean
extends AbstractBean
implements IBean {
    private static final long serialVersionUID = -2467757255556676271L;
    private static Logger LOGGER = Logger.getLogger(inetOrgPersonBean.class);

    public static inetOrgPersonBean getInstance(inetOrgPerson employee) throws IllegalAccessException, InvocationTargetException, CharacterUnacceptedException, NamingException {
        inetOrgPersonBean seb = new inetOrgPersonBean();
        AbstractBean.mapper(inetOrgPersonBean.class, localMethods, seb, employee);
        seb.generateDn();
        return seb;
    }

    public static void mapSn(inetOrgPerson se, IBean destBean, String value) throws NamingException, CharacterUnacceptedException {
        if (value != null && value.trim().length() != 0) {
            try {
                inetOrgPersonBean.mapString(destBean, "sn", Filters.filterSn(value));
            }
            catch (CharacterUnacceptedException cue) {
                String newvalue = Filters.removeBadChars(value);
                inetOrgPersonBean.mapString(destBean, "sn", Filters.filterSn(newvalue));
            }
            inetOrgPersonBean.generateCn(se, destBean);
            inetOrgPersonBean.generateDisplayName(se, destBean);
        }
    }

    public static void mapGivenName(inetOrgPerson se, IBean destBean, String value) throws NamingException, CharacterUnacceptedException {
        if (value != null && value.trim().length() != 0) {
            try {
                inetOrgPersonBean.mapString(destBean, "givenName", Filters.filterGivenName(value));
            }
            catch (CharacterUnacceptedException cue) {
                String newvalue = Filters.removeBadChars(value);
                inetOrgPersonBean.mapString(destBean, "givenName", Filters.filterSn(newvalue));
            }
            inetOrgPersonBean.generateCn(se, destBean);
            inetOrgPersonBean.generateDisplayName(se, destBean);
        }
    }

    public static void mapCn(inetOrgPerson se, IBean destBean, String value) throws NamingException {
    }

    public static void mapStreet(inetOrgPerson se, IBean destBean, List values) throws NamingException, CharacterUnacceptedException {
        String value;
        if (values != null && values.size() > 0 && (value = (String)values.iterator().next()) != null && value.trim().length() != 0) {
            inetOrgPersonBean.mapString(destBean, "street", Filters.filterString(value));
            inetOrgPersonBean.generatePostalAddress(se, destBean);
        }
    }

    public static void mapL(inetOrgPerson se, IBean destBean, List values) throws NamingException, CharacterUnacceptedException {
        String value;
        if (values != null && values.size() > 0 && (value = (String)values.iterator().next()) != null && value.trim().length() != 0) {
            inetOrgPersonBean.mapString(destBean, "l", Filters.filterString(value));
            inetOrgPersonBean.generatePostalAddress(se, destBean);
        }
    }

    public static void mapPostalCode(inetOrgPerson se, IBean destBean, List values) throws NamingException, CharacterUnacceptedException {
        String value;
        if (values != null && values.size() > 0 && (value = (String)values.iterator().next()) != null && value.trim().length() != 0) {
            inetOrgPersonBean.mapString(destBean, "postalCode", Filters.filterString(value));
            inetOrgPersonBean.generatePostalAddress(se, destBean);
        }
    }

    public static void mapPostalAddress(inetOrgPerson se, IBean destBean, String value) throws NamingException {
    }

    public static void generateCn(inetOrgPerson se, IBean destBean) throws NamingException {
        if (destBean.getAttributeById("sn") != null && destBean.getAttributeById("sn").size() > 0 && destBean.getAttributeById("givenName") != null && destBean.getAttributeById("givenName").size() > 0) {
            BasicAttribute cnAttr = new BasicAttribute("cn");
            cnAttr.add(destBean.getAttributeById("sn").get() + " " + destBean.getAttributeById("givenName").get());
            destBean.setAttribute(cnAttr);
        }
    }

    public static void generateDisplayName(inetOrgPerson se, IBean destBean) throws NamingException {
        if (destBean.getAttributeById("sn") != null && destBean.getAttributeById("sn").size() > 0 && destBean.getAttributeById("givenName") != null && destBean.getAttributeById("givenName").size() > 0) {
            BasicAttribute cnAttr = new BasicAttribute("displayName");
            cnAttr.add(destBean.getAttributeById("sn").get() + " " + destBean.getAttributeById("givenName").get());
            destBean.setAttribute(cnAttr);
        }
    }

    public static void generatePostalAddress(inetOrgPerson se, IBean destBean) throws NamingException {
        String site = "";
        String houseIdentifier = "";
        String etage = "";
        String roomNumber = "";
        String postOffice = "";
        String street = destBean.getAttributeById("street") != null && destBean.getAttributeById("street").size() > 0 ? (String)destBean.getAttributeById("street").get() : "";
        String postalCode = destBean.getAttributeById("postalCode") != null && destBean.getAttributeById("postalCode").size() > 0 ? (String)destBean.getAttributeById("postalCode").get() : "";
        String l = destBean.getAttributeById("l") != null && destBean.getAttributeById("l").size() > 0 ? (String)destBean.getAttributeById("l").get() : "";
        String value = site + "$" + houseIdentifier + "$" + etage + "$" + roomNumber + "$" + postOffice + "$" + street + "$" + postalCode + "$" + l;
        BasicAttribute postalAddrAttr = new BasicAttribute("postalAddress");
        postalAddrAttr.add(value);
        destBean.setAttribute(postalAddrAttr);
    }

    public void generateDn() throws NamingException {
        String uid = this.getUid((String)this.getAttributeById("givenName").get(), (String)this.getAttributeById("sn").get(), (String)this.getAttributeById("employeeNumber").get());
        this.setDistinguishName(inetOrgPerson.getDn(uid));
    }

    private String getUid(String fN, String lN, String eN) {
        int i;
        String lastname = Filters.filterUid(lN);
        String firstname = Filters.filterUid(fN);
        String uid = inetOrgPersonBean.cutStrToLength(lastname, Configuration.UID_MAX_LENGTH);
        for (i = Configuration.UID_MAX_LENGTH - 1; i > 0; --i) {
            try {
                if (JndiServices.getInstance().getDnList(Configuration.DN_PEOPLE, "(&(uid=" + uid + ")(!(employeeNumber=" + eN + ")))", 1).size() <= 0) break;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Existing uid=" + uid));
                }
            }
            catch (NamingException e) {
                LOGGER.warn((Object)("Error while looking for an unique uid : " + e), (Throwable)e);
            }
            uid = inetOrgPersonBean.cutStrToLength(lastname, i).concat(inetOrgPersonBean.cutStrToLength(firstname, Configuration.UID_MAX_LENGTH - i));
        }
        if (i == 0) {
            uid = null;
        }
        return uid;
    }

    public static String cutStrToLength(String str, int expectedLength) {
        if (str.length() > expectedLength) {
            return str.substring(0, expectedLength);
        }
        return str;
    }

    static {
        localMethods = new HashMap();
    }
}

