/*
 * Decompiled with CFR 0.152.
 */
package org.interldap.lsc.beans.syncoptions;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.interldap.lsc.Configuration;
import org.interldap.lsc.beans.syncoptions.ISyncOptions;

public class PropertiesBasedSyncOptions
implements ISyncOptions {
    private Map<String, ISyncOptions.STATUS_TYPE> status;
    private Map<String, String> defaultValues;
    private Map<String, String> createValues;
    private ISyncOptions.STATUS_TYPE defaultStatus;
    private static Logger LOGGER = Logger.getLogger(PropertiesBasedSyncOptions.class);

    public void initialize(String syncName) {
        this.status = new HashMap<String, ISyncOptions.STATUS_TYPE>();
        this.defaultValues = new HashMap<String, String>();
        this.createValues = new HashMap<String, String>();
        this.defaultStatus = ISyncOptions.STATUS_TYPE.FORCE;
        Properties props = Configuration.getAsProperties("lsc.syncoptions." + syncName);
        Enumeration<Object> en = props.keys();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            if (key == "") continue;
            String value = props.getProperty(key);
            StringTokenizer stok = new StringTokenizer(key, ".");
            if (stok.countTokens() != 2) {
                LOGGER.error((Object)("Unable to use invalid name : lsc." + syncName + "." + key + " ! Bypassing ..."));
                continue;
            }
            String attributeName = stok.nextToken();
            String typeName = stok.nextToken();
            if (typeName.equalsIgnoreCase("action")) {
                ISyncOptions.STATUS_TYPE st;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Adding '" + value + "' sync type for attribute name " + attributeName + "."));
                }
                if ((st = this.parseSyncType(value)) == ISyncOptions.STATUS_TYPE.UNKNOWN) {
                    LOGGER.error((Object)("Unable to analyze action type \"" + value + "\" for the following attribute : lsc." + syncName + "." + key + " ! Bypassing ..."));
                    continue;
                }
                if (attributeName.equalsIgnoreCase("default")) {
                    this.defaultStatus = st;
                    continue;
                }
                this.status.put(attributeName, st);
                continue;
            }
            if (typeName.equalsIgnoreCase("default_value")) {
                this.defaultValues.put(attributeName, value);
                this.createValues.put(attributeName, value);
                continue;
            }
            if (typeName.equalsIgnoreCase("create_value")) {
                this.createValues.put(attributeName, value);
                continue;
            }
            LOGGER.error((Object)("Unable to identify attribute option \"" + typeName + "\" in this name : lsc." + syncName + "." + key + " ! Bypassing ..."));
        }
    }

    private ISyncOptions.STATUS_TYPE parseSyncType(String value) {
        if (value.equalsIgnoreCase("K")) {
            return ISyncOptions.STATUS_TYPE.KEEP;
        }
        if (value.equalsIgnoreCase("F")) {
            return ISyncOptions.STATUS_TYPE.FORCE;
        }
        return ISyncOptions.STATUS_TYPE.UNKNOWN;
    }

    public ISyncOptions.STATUS_TYPE getStatus(String id, String attributeName) {
        if (!this.status.containsKey(attributeName) || this.status.get(attributeName) == ISyncOptions.STATUS_TYPE.UNKNOWN) {
            return this.defaultStatus;
        }
        return this.status.get(attributeName);
    }

    public String getDefaultValue(String id, String attributeName) {
        return this.defaultValues.get(attributeName);
    }

    public String getCreateValue(String id, String attributeName) {
        return this.createValues.get(attributeName);
    }
}

