/*
 * Decompiled with CFR 0.152.
 */
package org.interldap.lsc.beans.syncoptions;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.interldap.lsc.Configuration;
import org.interldap.lsc.beans.syncoptions.ISyncOptions;

public class SyncOptionsFactory {
    private static SyncOptionsFactory INSTANCE;
    private Map<String, ISyncOptions> cache = new HashMap<String, ISyncOptions>();
    private static Logger LOGGER;

    private SyncOptionsFactory() {
    }

    private void loadOptions() {
        String tasks = Configuration.getString("lsc.tasks", "default");
        StringTokenizer stok = new StringTokenizer(tasks, ",");
        while (stok.hasMoreTokens()) {
            String taskname = stok.nextToken();
            String className = Configuration.getString("lsc.syncoptions." + taskname, "org.interldap.lsc.beans.syncoptions.ForceSyncOptions");
            try {
                Class<?> cSyncOptions = Class.forName(className);
                ISyncOptions iso = (ISyncOptions)cSyncOptions.newInstance();
                iso.initialize(taskname);
                this.cache.put(taskname, iso);
            }
            catch (ClassNotFoundException e) {
                LOGGER.error((Object)("Unable to found '" + className + "' name. Please respecify lsc.syncoptions." + taskname + " value."));
            }
            catch (InstantiationException e) {
                LOGGER.error((Object)("Internal error while instanciating '" + className + "' name. Choose another implementation or fix it !"));
            }
            catch (IllegalAccessException e) {
                LOGGER.error((Object)("Internal error while instanciating '" + className + "' name. Choose another implementation or fix it !"));
            }
        }
    }

    public static ISyncOptions getInstance(String syncName) {
        if (INSTANCE == null) {
            INSTANCE = new SyncOptionsFactory();
            INSTANCE.loadOptions();
        }
        return INSTANCE.get(syncName);
    }

    private ISyncOptions get(String syncName) {
        return this.cache.get(syncName);
    }

    static {
        LOGGER = Logger.getLogger(SyncOptionsFactory.class);
    }
}

