/*
 * Decompiled with CFR 0.152.
 */
package org.interldap.lsc.jndi;

import com.sun.jndi.ldap.LdapURL;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.LdapName;
import org.apache.log4j.Logger;
import org.interldap.lsc.Configuration;
import org.interldap.lsc.jndi.JndiModifications;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JndiServices {
    private static JndiServices instance;
    private Logger LOGGER = Logger.getLogger(JndiServices.class);
    private LdapContext ctx;
    private static Map<Properties, JndiServices> cache;

    private JndiServices() throws IOException, NamingException {
        this.ctx = new InitialLdapContext(Configuration.getLdapProperties(), null);
    }

    private JndiServices(Properties connProps) throws IOException, NamingException {
        this.ctx = new InitialLdapContext(connProps, null);
    }

    public static JndiServices getInstance() {
        if (instance == null) {
            try {
                instance = new JndiServices();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ExceptionInInitializerError(e);
            }
        }
        return instance;
    }

    public static JndiServices getInstance(Properties props) {
        try {
            if (cache == null) {
                cache = new HashMap<Properties, JndiServices>();
            }
            if (!cache.containsKey(props)) {
                cache.put(props, new JndiServices(props));
            }
            return cache.get(props);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ExceptionInInitializerError(e);
        }
    }

    public SearchResult getEntry(String base, String filter) throws NamingException {
        SearchControls sc = new SearchControls();
        return this.getEntry(base, filter, sc);
    }

    public SearchResult getEntry(String base, String filter, SearchControls sc) throws NamingException {
        NamingEnumeration<SearchResult> ne = null;
        try {
            sc.setSearchScope(2);
            String contextDn = new LdapURL((String)this.ctx.getEnvironment().get("java.naming.provider.url")).getDN().toString();
            String rewrittenBase = null;
            rewrittenBase = base.toLowerCase().endsWith(contextDn.toLowerCase()) ? (!base.equalsIgnoreCase(contextDn) ? base.substring(0, base.toLowerCase().lastIndexOf(contextDn.toLowerCase()) - 1) : "") : base;
            ne = this.ctx.search(rewrittenBase, filter, sc);
        }
        catch (NamingException nex) {
            this.LOGGER.error((Object)("Error while looking for " + filter + " in " + base + " : " + nex), (Throwable)nex);
            return null;
        }
        SearchResult sr = null;
        if (ne.hasMore()) {
            sr = ne.next();
            if (ne.hasMore()) {
                this.LOGGER.error((Object)("To many entries returned (base: \"" + base + "\", filter: \"" + filter + "\""));
            } else {
                return sr;
            }
        }
        return sr;
    }

    public boolean exists(String dn) {
        try {
            return this.readEntry(dn, true) != null;
        }
        catch (NamingException e) {
            this.LOGGER.error((Object)e, (Throwable)e);
            return false;
        }
    }

    public SearchResult readEntry(String base, boolean allowError) throws NamingException {
        SearchControls sc = new SearchControls();
        return this.readEntry(base, allowError, sc);
    }

    public String rewriteBase(String base) {
        try {
            String contextDn = new LdapURL((String)this.ctx.getEnvironment().get("java.naming.provider.url")).getDN().toString();
            String rewrittenBase = null;
            rewrittenBase = base.toLowerCase().endsWith(contextDn.toLowerCase()) ? (!base.equalsIgnoreCase(contextDn) ? base.substring(0, base.toLowerCase().lastIndexOf(contextDn.toLowerCase()) - 1) : "") : base;
            return rewrittenBase;
        }
        catch (NamingException nex) {
            this.LOGGER.error((Object)("Error rewriting LDAP DN " + base + " : " + nex), (Throwable)nex);
            return null;
        }
    }

    public SearchResult readEntry(String base, boolean allowError, SearchControls sc) throws NamingException {
        NamingEnumeration<SearchResult> ne = null;
        sc.setSearchScope(0);
        try {
            ne = this.ctx.search(this.rewriteBase(base), "objectClass=*", sc);
        }
        catch (NamingException nex) {
            if (!allowError) {
                this.LOGGER.error((Object)("Error while reading entry " + base + " : " + nex), (Throwable)nex);
            }
            return null;
        }
        SearchResult sr = null;
        if (ne.hasMore()) {
            sr = ne.next();
            if (ne.hasMore()) {
                this.LOGGER.error((Object)("To many entries returned (base: \"" + base + "\""));
            } else {
                return sr;
            }
        }
        return sr;
    }

    public List getDnList(String base, String filter, int scope) throws NamingException {
        NamingEnumeration<SearchResult> ne = null;
        ArrayList<String> l = new ArrayList<String>();
        try {
            SearchControls sc = new SearchControls();
            sc.setDerefLinkFlag(false);
            sc.setReturningAttributes(new String[]{"1.1"});
            sc.setSearchScope(scope);
            sc.setReturningObjFlag(true);
            ne = this.ctx.search(base, filter, sc);
            while (ne.hasMore()) {
                l.add(ne.next().getName() + (base.length() != 0 ? "," : "") + base);
            }
        }
        catch (NamingException nex) {
            this.LOGGER.error((Object)nex, (Throwable)nex);
        }
        return l;
    }

    public Map<String, String> getAttrList(String base, String filter, int scope, String attrName) throws NamingException {
        NamingEnumeration<SearchResult> ne = null;
        HashMap<String, String> l = new HashMap<String, String>();
        try {
            SearchControls sc = new SearchControls();
            sc.setDerefLinkFlag(false);
            sc.setReturningAttributes(new String[]{attrName});
            sc.setSearchScope(scope);
            sc.setReturningObjFlag(true);
            ne = this.ctx.search(base, filter, sc);
            while (ne.hasMore()) {
                SearchResult ldapResult = ne.next();
                Attribute attr = ldapResult.getAttributes().get(attrName);
                if (attr == null || attr.get() == null) continue;
                l.put(ldapResult.getName(), (String)attr.get());
            }
        }
        catch (NamingException nex) {
            this.LOGGER.debug((Object)nex, (Throwable)nex);
        }
        return l;
    }

    public boolean apply(JndiModifications jm) {
        try {
            switch (jm.getOperation()) {
                case 0: {
                    this.ctx.createSubcontext(new LdapName(this.rewriteBase(jm.getDistinguishName())), this.getAttributes(jm.getModificationItems(), true));
                    break;
                }
                case 1: {
                    this.ctx.destroySubcontext(new LdapName(this.rewriteBase(jm.getDistinguishName())));
                    break;
                }
                case 2: {
                    Object[] table = jm.getModificationItems().toArray();
                    ModificationItem[] mis = new ModificationItem[table.length];
                    for (int i = 0; i < table.length; ++i) {
                        mis[i] = (ModificationItem)table[i];
                    }
                    this.ctx.modifyAttributes(new LdapName(this.rewriteBase(jm.getDistinguishName())), mis);
                    break;
                }
                case 3: {
                    this.ctx.rename(new LdapName(this.rewriteBase(jm.getDistinguishName())), new LdapName(this.rewriteBase(jm.getNewDistinguishName())));
                    break;
                }
                default: {
                    this.LOGGER.error((Object)("Unable to identify the right modification type : " + jm.getOperation()));
                    return false;
                }
            }
            return true;
        }
        catch (NamingException ne) {
            this.LOGGER.error((Object)("Error while modifying directory on entry " + jm.getDistinguishName() + " / " + jm.getModificationItems()), (Throwable)ne);
            return false;
        }
    }

    private Attributes getAttributes(List modificationItems, boolean forgetEmpty) {
        BasicAttributes attrs = new BasicAttributes();
        for (ModificationItem mi : modificationItems) {
            if (forgetEmpty && mi.getAttribute().size() == 0) continue;
            attrs.put(mi.getAttribute());
        }
        return attrs;
    }

    public Map<String, List<String>> getSchema(String[] attrsToReturn) throws NamingException {
        HashMap<String, List<String>> attrs = new HashMap<String, List<String>>();
        Hashtable<?, ?> props = this.ctx.getEnvironment();
        String baseUrl = (String)props.get("java.naming.provider.url");
        baseUrl = baseUrl.substring(0, baseUrl.lastIndexOf("/"));
        props.put("java.naming.provider.url", baseUrl);
        InitialLdapContext schemaCtx = new InitialLdapContext(props, null);
        Attributes schemaAttrs = schemaCtx.getAttributes(Configuration.DN_LDAP_SCHEMA, new String[]{"*", "+"});
        if (schemaAttrs != null) {
            for (int i = 0; i < attrsToReturn.length; ++i) {
                Attribute schemaAttr = schemaAttrs.get(attrsToReturn[i]);
                if (schemaAttr == null) continue;
                attrs.put(schemaAttr.getID(), Collections.list(schemaAttr.getAll()));
            }
        }
        return attrs;
    }
}

