/*
 * Decompiled with CFR 0.152.
 */
package org.interldap.lsc.jndi;

import java.util.HashMap;
import java.util.Iterator;
import javax.naming.NamingException;
import org.interldap.lsc.AbstractGenerator;
import org.interldap.lsc.jndi.parser.LdapAttributeType;
import org.interldap.lsc.jndi.parser.LdapObjectClass;

public class JndiSrcObjectGenerator
extends AbstractGenerator {
    private String initialName;

    public boolean generate(String className) throws NamingException {
        if (this.ocs == null || this.ocs.size() <= 0 || this.attrs == null || this.attrs.size() <= 0) {
            LOGGER.error((Object)"Generator have to be initialized");
            return false;
        }
        this.initialName = className;
        this.className = className.substring(0, 1).toUpperCase() + className.substring(1) + "JNDIService";
        this.packageName = this.getGenericPackageName();
        HashMap<String, LdapAttributeType> ats = new HashMap<String, LdapAttributeType>();
        for (String atStr : this.attrs) {
            LdapAttributeType lat = LdapAttributeType.parse(atStr);
            if (lat == null) continue;
            ats.put(lat.getName(), lat);
        }
        LdapObjectClass myLoc = null;
        Iterator<String> ocIter = this.ocs.iterator();
        while (ocIter.hasNext() && myLoc == null) {
            String ocStr = ocIter.next();
            LdapObjectClass loc = LdapObjectClass.parse(ocStr, ats);
            if (loc == null || loc.getName().compareToIgnoreCase(this.initialName) != 0) continue;
            myLoc = loc;
        }
        if (myLoc != null) {
            String content = this.generateContent();
            if (this.writeContent(content)) {
                LOGGER.info((Object)("JndiObject generation successed for " + this.getFileName()));
                return true;
            }
        } else {
            LOGGER.error((Object)("JndiObject generation failed : LDAP objectClass (" + this.initialName + ") could not be found in LDAP directory."));
        }
        return false;
    }

    public String getGenericPackageName() {
        return this.getClass().getPackage().getName();
    }

    protected String generateContent() {
        String beanClassName = this.initialName + "Bean";
        String jndiClassName = super.getClassName();
        String content = "";
        content = content + "/*\n * Generated - please do not edit manually\n */\n";
        content = content + "package " + this.getPackageName() + ";\n\n";
        content = content + "import java.util.Iterator;\n\nimport javax.naming.NamingException;\n\nimport javax.naming.directory.SearchControls;\nimport org.interldap.lsc.Configuration;\nimport org.interldap.lsc.objects.top;\n\n";
        content = content + "public class " + jndiClassName + " implements IJndiSrcService {\n\n";
        content = content + "\tpublic top getObject(String id) throws NamingException {\n\t\t//@TODO: Please refactor to find the correct entry\n\t\t//return (" + beanClassName + ") " + beanClassName + ".getInstance(JndiServices.getInstance().getEntry(Configuration.DN_PEOPLE, \"uid=\" + id), Configuration.DN_PEOPLE, " + beanClassName + ".class);\n" + "\t\treturn null;\n" + "\t}\n\n";
        content = content + "\tpublic Iterator<String> getIdsList() throws NamingException {\n\t\t//@TODO: Please refactor to find the correct entry\n\t\t//return JndiServices.getInstance().getAttrList(Configuration.DN_PEOPLE, \"objectClass=" + this.initialName + "\", SearchControls.SUBTREE_SCOPE, \"uid\").values().iterator();\n" + "\t\treturn null;\n" + "\t}\n\n";
        content = content + "}";
        return content;
    }

    public static void run(String arg, String destination) throws NamingException {
        JndiSrcObjectGenerator jndiGenerator = new JndiSrcObjectGenerator();
        jndiGenerator.init();
        jndiGenerator.setDestination(destination);
        jndiGenerator.generate(arg);
    }
}

