/*
 * Decompiled with CFR 0.152.
 */
package org.interldap.lsc.jndi.parser;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.interldap.lsc.jndi.parser.LdapObjectClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdapAttributeType {
    private boolean singleValue = false;
    private boolean noUserModification = false;
    private boolean directoryOperation = false;
    private boolean dSAOperation = false;
    private boolean distributedOperation = false;
    private String oid;
    private String name;
    private String usage;
    private String syntax;
    private Map<String, String> x = new HashMap<String, String>();
    private String inheritFrom;
    private String description;
    private String equalityRule;
    private String substringRule;
    private String orderingRule;
    private static Logger LOGGER = Logger.getLogger(LdapAttributeType.class);

    public static LdapAttributeType parse(String atStr) {
        int maxPass;
        LdapAttributeType lat = new LdapAttributeType();
        String rest = atStr;
        String[] ret = LdapObjectClass.execRegex(rest, "\\(\\s+([0-9\\.]+)(.*)\\s*\\)\\s*");
        if (ret == null) {
            LOGGER.error((Object)("Unable to match the oid in \"" + atStr + "\""));
            return null;
        }
        lat.oid = ret[0];
        rest = ret[1];
        ret = LdapObjectClass.execRegex(rest, "\\s*NAME\\s+(\\([^\\)]+\\)|[^ ]+)(.*)\\s*");
        if (ret != null) {
            if (ret[0].startsWith("(")) {
                ret[0] = ret[0].substring(1, ret[0].length() - 1);
            }
            StringTokenizer names = new StringTokenizer(ret[0], " ");
            lat.setName(names.nextToken());
            if (names.hasMoreElements()) {
                LOGGER.debug((Object)("Multiple names not supported. Using first one (" + lat.name + ") for \"" + atStr + "\""));
            }
        } else {
            LOGGER.error((Object)("Unable to match the name in \"" + atStr + "\""));
            return null;
        }
        rest = ret[1];
        for (maxPass = 0; rest != null && rest.length() > 0 && maxPass < 100; ++maxPass) {
            LOGGER.debug((Object)("Re/Starting analysis with rest=\"" + rest + "\""));
            ret = LdapObjectClass.execRegex(rest, "\\s*SYNTAX\\s+([^\\s]+)\\s*(.*)\\s*");
            if (ret != null) {
                lat.syntax = ret[0];
                rest = ret[1];
            }
            if ((ret = LdapObjectClass.execRegex(rest, "\\s*SUP\\s+([^\\s]+)\\s*(.*)\\s*")) != null) {
                lat.description = ret[0];
                rest = ret[1];
            }
            if ((ret = LdapObjectClass.execRegex(rest, "\\s*DESC\\s+('[^']*')\\s*(.*)\\s*")) != null) {
                lat.description = ret[0];
                rest = ret[1];
            }
            if ((ret = LdapObjectClass.execRegex(rest, "\\s*EQUALITY\\s+([^\\s]+)\\s*(.*)\\s*")) != null) {
                lat.equalityRule = ret[0];
                rest = ret[1];
            }
            if ((ret = LdapObjectClass.execRegex(rest, "\\s*SUBSTR\\s+([^\\s]+)\\s*(.*)\\s*")) != null) {
                lat.substringRule = ret[0];
                rest = ret[1];
            }
            if ((ret = LdapObjectClass.execRegex(rest, "\\s*SUBSTRINGS\\s+([^\\s]+)\\s*(.*)\\s*")) != null) {
                lat.substringRule = ret[0];
                rest = ret[1];
            }
            if ((ret = LdapObjectClass.execRegex(rest, "\\s*ORDERING\\s+([^\\s]+)\\s*(.*)\\s*")) != null) {
                lat.orderingRule = ret[0];
                rest = ret[1];
            }
            if ((ret = LdapObjectClass.execRegex(rest, "\\s*USAGE\\s+([^\\s]+)\\s*(.*)\\s*")) != null) {
                lat.usage = ret[0];
                rest = ret[1];
            }
            if ((ret = LdapObjectClass.execRegex3(rest, "\\s*X-([^\\s]+)\\s+('[^']+')?\\s*(.*)\\s*")) != null) {
                lat.x.put(ret[0], ret[1]);
                rest = ret[2];
            }
            if ((ret = LdapObjectClass.execRegex(rest, "\\s*(SINGLE-VALUE)\\s*(.*)\\s*")) != null) {
                lat.singleValue = true;
                rest = ret[1];
            }
            if ((ret = LdapObjectClass.execRegex(rest, "\\s*(NO-USER-MODIFICATION)\\s*(.*)\\s*")) != null) {
                lat.noUserModification = true;
                rest = ret[1];
            }
            if ((ret = LdapObjectClass.execRegex(rest, "\\s*(directoryOperation)\\s*(.*)\\s*")) != null) {
                lat.directoryOperation = true;
                rest = ret[1];
            }
            if ((ret = LdapObjectClass.execRegex(rest, "\\s*(dSAOperation)\\s*(.*)\\s*")) != null) {
                lat.dSAOperation = true;
                rest = ret[1];
            }
            if ((ret = LdapObjectClass.execRegex(rest, "\\s*(distributedOperation)\\s*(.*)\\s*")) == null) continue;
            lat.distributedOperation = true;
            rest = ret[1];
        }
        if (maxPass >= 100) {
            LOGGER.error((Object)("The parser encountered an error while parsing the following string : " + rest + " while parsing " + atStr));
            return null;
        }
        if (lat.inheritFrom == null) {
            LOGGER.debug((Object)("No inheritence found for \"" + atStr + "\""));
        }
        if (lat.description == null) {
            LOGGER.debug((Object)("No description found for \"" + atStr + "\""));
        }
        if (lat.equalityRule == null) {
            LOGGER.debug((Object)("No equality rule found for \"" + atStr + "\""));
        }
        if (lat.substringRule == null) {
            LOGGER.debug((Object)("No substring rule found for \"" + atStr + "\""));
        }
        if (lat.orderingRule == null) {
            LOGGER.debug((Object)("No ordering rule found for \"" + atStr + "\""));
        }
        if (lat.x.size() == 0) {
            LOGGER.debug((Object)("No x rule found for \"" + atStr + "\""));
        }
        return lat;
    }

    public boolean isSingleValue() {
        return this.singleValue;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getEqualityRule() {
        return this.equalityRule;
    }

    public void setEqualityRule(String equalityRule) {
        this.equalityRule = equalityRule;
    }

    public String getInheritFrom() {
        return this.inheritFrom;
    }

    public void setInheritFrom(String inheritFrom) {
        this.inheritFrom = inheritFrom;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name.trim().startsWith("'") ? name.trim().substring(1, name.length() - 1) : name.trim();
    }

    public String getOid() {
        return this.oid;
    }

    public void setOid(String oid) {
        this.oid = oid;
    }

    public String getOrderingRule() {
        return this.orderingRule;
    }

    public void setOrderingRule(String orderingRule) {
        this.orderingRule = orderingRule;
    }

    public String getSubstringRule() {
        return this.substringRule;
    }

    public void setSubstringRule(String substringRule) {
        this.substringRule = substringRule;
    }

    public void setSingleValue(boolean singleValued) {
        this.singleValue = singleValued;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void setSyntax(String syntax) {
        this.syntax = syntax;
    }

    public boolean isDirectoryOperation() {
        return this.directoryOperation;
    }

    public void setDirectoryOperation(boolean directoryOperation) {
        this.directoryOperation = directoryOperation;
    }

    public boolean isDistributedOperation() {
        return this.distributedOperation;
    }

    public void setDistributedOperation(boolean distributedOperation) {
        this.distributedOperation = distributedOperation;
    }

    public boolean isDSAOperation() {
        return this.dSAOperation;
    }

    public void setDSAOperation(boolean operation) {
        this.dSAOperation = operation;
    }

    public boolean isNoUserModification() {
        return this.noUserModification;
    }

    public void setNoUserModification(boolean noUserModification) {
        this.noUserModification = noUserModification;
    }

    public String getUsage() {
        return this.usage;
    }

    public void setUsage(String usage) {
        this.usage = usage;
    }

    public Map<String, String> getX() {
        return this.x;
    }

    public void setXordered(Map<String, String> x) {
        this.x = x;
    }
}

