/*
 * Decompiled with CFR 0.152.
 */
package org.interldap.lsc.jndi.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.interldap.lsc.jndi.parser.LdapAttributeType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdapObjectClass {
    private String oid;
    private String name;
    private String type;
    private String inheritFrom;
    private String description;
    private Map<String, String> x = new HashMap<String, String>();
    private List<String> monoAttrs = new ArrayList<String>();
    private List<String> multiAttrs = new ArrayList<String>();
    private static Logger LOGGER = Logger.getLogger(LdapObjectClass.class);

    public static String[] execRegex(String value, String pattern) {
        Pattern ocPattern = Pattern.compile(pattern, 2);
        Matcher ocMatcher = ocPattern.matcher(value);
        if (ocMatcher.matches()) {
            return new String[]{ocMatcher.group(1), ocMatcher.group(2)};
        }
        return null;
    }

    public static String[] execRegex3(String value, String pattern) {
        Pattern ocPattern = Pattern.compile(pattern, 2);
        Matcher ocMatcher = ocPattern.matcher(value);
        if (ocMatcher.matches()) {
            return new String[]{ocMatcher.group(1), ocMatcher.group(2), ocMatcher.group(3)};
        }
        return null;
    }

    public static LdapObjectClass parse(String ocStr, Map<String, LdapAttributeType> ats) {
        int maxPass;
        LdapObjectClass loc = new LdapObjectClass();
        String rest = ocStr;
        ArrayList<String> attrs = new ArrayList<String>();
        String[] ret = LdapObjectClass.execRegex(rest, "\\(\\s+([0-9\\.]+)(.*)\\s*\\)\\s*");
        if (ret == null) {
            LOGGER.error((Object)("Unable to match the oid in \"" + ocStr + "\""));
            return null;
        }
        loc.oid = ret[0];
        rest = ret[1];
        ret = LdapObjectClass.execRegex(rest, "\\s*NAME\\s+(\\([^\\)]+\\)|[^ ]+)(.*)\\s*");
        if (ret != null) {
            if (ret[0].startsWith("(")) {
                ret[0] = ret[0].substring(1, ret[0].length() - 1);
            }
            StringTokenizer names = new StringTokenizer(ret[0], " ");
            loc.setName(names.nextToken());
            if (names.hasMoreElements()) {
                LOGGER.debug((Object)("Multiple names not supported. Using first one (" + loc.name + ") for \"" + ocStr + "\""));
            }
        } else {
            LOGGER.error((Object)("Unable to match the name in \"" + ocStr + "\""));
            return null;
        }
        rest = ret[1];
        for (maxPass = 0; rest != null && rest.length() > 0 && maxPass < 100; ++maxPass) {
            LOGGER.debug((Object)("Re/Starting analysis with rest=\"" + rest + "\""));
            ret = LdapObjectClass.execRegex(rest, "\\s*SUP\\s+(\\([^\\)]+\\)|[^\\s]+)?\\s*(.*)\\s*");
            if (ret != null) {
                if (ret[0].startsWith("(")) {
                    ret[0] = ret[0].substring(1, ret[0].length() - 2);
                }
                StringTokenizer sups = new StringTokenizer(ret[0], "$");
                loc.inheritFrom = sups.nextToken();
                if (sups.hasMoreElements()) {
                    LOGGER.warn((Object)("Multiple inheritence not supported. Using first one (" + loc.inheritFrom + ") for \"" + ocStr + "\""));
                }
                rest = ret[1];
            }
            if ((ret = LdapObjectClass.execRegex(rest, "\\s*DESC\\s+('[^']*')\\s*(.*)\\s*")) != null) {
                loc.description = ret[0];
                rest = ret[1];
            }
            if ((ret = LdapObjectClass.execRegex(rest, "\\s*MUST\\s+(\\([^\\)]+\\)|[^\\s]+)?\\s*(.*)\\s*")) != null) {
                if (ret[0].startsWith("(")) {
                    ret[0] = ret[0].substring(1, ret[0].length() - 2);
                }
                StringTokenizer musts = new StringTokenizer(ret[0], "$");
                attrs.addAll(LdapObjectClass.toList(musts));
                rest = ret[1];
            }
            if ((ret = LdapObjectClass.execRegex(rest, "\\s*MAY\\s+(\\([^\\)]+\\)|[^\\s]+)?\\s*(.*)\\s*")) != null) {
                if (ret[0].startsWith("(")) {
                    ret[0] = ret[0].substring(1, ret[0].length() - 2);
                }
                StringTokenizer mays = new StringTokenizer(ret[0], "$");
                attrs.addAll(LdapObjectClass.toList(mays));
                rest = ret[1];
            }
            if ((ret = LdapObjectClass.execRegex3(rest, "\\s*X-([^\\s]+)\\s+('[^']+')?\\s*(.*)\\s*")) != null) {
                loc.x.put(ret[0], ret[1]);
                rest = ret[2];
            }
            if ((ret = LdapObjectClass.execRegex(rest, "\\s*(STRUCTURAL|AUXILIARY|ABSTRACT)\\s*(.*)\\s*")) == null) continue;
            loc.type = ret[0];
            rest = ret[1];
        }
        if (maxPass >= 100) {
            LOGGER.error((Object)("The parser encountered an error while parsing the following string : " + rest + " while parsing " + ocStr));
            return null;
        }
        if (loc.inheritFrom == null) {
            LOGGER.debug((Object)("No inheritence found for \"" + ocStr + "\". Defaulting to top"));
            loc.inheritFrom = "top";
        }
        if (loc.description == null) {
            LOGGER.debug((Object)("No description found for \"" + ocStr + "\""));
        }
        if (loc.type == null) {
            loc.type = "AUXILIARY";
            LOGGER.debug((Object)("No structural or abstract type found. Defaulting to auxiliary in \"" + ocStr + "\""));
        }
        for (String attributeName : attrs) {
            if (ats.get(attributeName) != null && ats.get(attributeName).isSingleValue()) {
                loc.monoAttrs.add(attributeName);
                continue;
            }
            loc.multiAttrs.add(attributeName);
        }
        LOGGER.debug((Object)("Successfully parsed objectclass " + loc.name));
        return loc;
    }

    private static List<String> toList(StringTokenizer names) {
        ArrayList<String> ret = new ArrayList<String>();
        while (names.hasMoreTokens()) {
            ret.add(names.nextToken().trim());
        }
        return ret;
    }

    public String getInheritFrom() {
        return this.inheritFrom;
    }

    public void setInheritFrom(String inheritFrom) {
        this.inheritFrom = inheritFrom;
    }

    public List<String> getMultiAttrs() {
        return this.multiAttrs;
    }

    public void setMultiAttrs(List<String> multiAttrs) {
        this.multiAttrs = multiAttrs;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name.trim().startsWith("'") ? name.trim().substring(1, name.length() - 1) : name.trim();
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<String> getMonoAttrs() {
        return this.monoAttrs;
    }

    public void setMonoAttrs(List<String> optionalAttrs) {
        this.monoAttrs = optionalAttrs;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getOid() {
        return this.oid;
    }

    public void setOid(String oid) {
        this.oid = oid;
    }
}

