/*
 * Decompiled with CFR 0.152.
 */
package org.interldap.lsc.objects;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.naming.NamingException;
import org.apache.log4j.Logger;
import org.interldap.lsc.AbstractGenerator;
import org.interldap.lsc.jndi.parser.LdapAttributeType;
import org.interldap.lsc.jndi.parser.LdapObjectClass;

public class ObjectClassGenerator
extends AbstractGenerator {
    protected String initialName;
    protected String objectName;
    protected String flatName;
    protected List<String> monoAttrs;
    protected List<String> multiAttrs;
    protected LdapObjectClass myLoc;
    private static final Logger LOGGER = Logger.getLogger(ObjectClassGenerator.class);

    protected String generateContent() {
        throw new RuntimeException("Must never be there !");
    }

    protected String generateContent(String inheritFrom) {
        String classContent = "";
        classContent = classContent + "/*\n * Generated - please do not edit manually\n */\n";
        classContent = classContent + "package " + this.packageName + ";\n\n";
        if (this.multiAttrs.size() > 0) {
            classContent = classContent + "import java.util.List;\n\n";
        }
        classContent = classContent + "/**\n * LDAP " + this.className + " objectClass representation\n */\n";
        classContent = classContent + "public class " + this.className + (inheritFrom != null ? " extends " + inheritFrom : "") + " {\n\n";
        if (!this.className.startsWith("f")) {
            classContent = classContent + "\tpublic " + this.className + "() {\n";
            classContent = classContent + "\t\tsuper();\n\t\tobjectClass.add(\"" + this.className + "\");\n\t}\n\n";
        }
        for (String attr : this.multiAttrs) {
            classContent = classContent + "   /** Multivalued attribute : " + attr + " */\n";
            classContent = classContent + "   protected List " + attr + ";\n\n";
        }
        for (String attr : this.monoAttrs) {
            classContent = classContent + "   /** Monovalued attribute : " + attr + " */\n";
            classContent = classContent + "   protected String " + attr + ";\n\n";
        }
        for (String attr : this.multiAttrs) {
            classContent = classContent + "   /**\n";
            classContent = classContent + "    * " + attr + " getter\n";
            classContent = classContent + "    * @return " + attr + " values\n";
            classContent = classContent + "    */\n";
            classContent = classContent + "   public List get" + attr.substring(0, 1).toUpperCase() + attr.substring(1) + "() {\n";
            classContent = classContent + "       return " + attr + ";\n";
            classContent = classContent + "   }\n\n";
            classContent = classContent + "   /**\n";
            classContent = classContent + "    * " + attr + " setter\n";
            classContent = classContent + "    * @param values " + attr + " values\n";
            classContent = classContent + "    */\n";
            classContent = classContent + "   public void set" + attr.substring(0, 1).toUpperCase() + attr.substring(1) + "(List values) {\n";
            classContent = classContent + "       this." + attr + " = values;\n";
            classContent = classContent + "   }\n\n";
        }
        for (String attr : this.monoAttrs) {
            classContent = classContent + "   /**\n";
            classContent = classContent + "    * " + attr + " getter\n";
            classContent = classContent + "    * @return " + attr + " value\n";
            classContent = classContent + "    */\n";
            classContent = classContent + "   public String get" + attr.substring(0, 1).toUpperCase() + attr.substring(1) + "() {\n";
            classContent = classContent + "       return " + attr + ";\n";
            classContent = classContent + "   }\n\n";
            classContent = classContent + "   /**\n";
            classContent = classContent + "    * " + attr + " setter\n";
            classContent = classContent + "    * @param value " + attr + " value\n";
            classContent = classContent + "    */\n";
            classContent = classContent + "   public void set" + attr.substring(0, 1).toUpperCase() + attr.substring(1) + "(String value) {\n";
            classContent = classContent + "       this." + attr + " = value;\n";
            classContent = classContent + "   }\n\n";
        }
        classContent = classContent + "}";
        return classContent;
    }

    public boolean generate(String className) throws NamingException {
        if (this.ocs == null || this.ocs.size() <= 0 || this.attrs == null || this.attrs.size() <= 0) {
            LOGGER.error((Object)"Generator have to be initialized");
            return false;
        }
        this.initialName = className;
        this.objectName = this.initialName.substring(0, 1).toUpperCase() + this.initialName.substring(1);
        this.flatName = "f" + this.initialName.substring(0, 1).toUpperCase() + this.initialName.substring(1);
        this.className = className;
        this.packageName = this.getGenericPackageName();
        HashMap<String, LdapAttributeType> ats = new HashMap<String, LdapAttributeType>();
        for (String atStr : this.attrs) {
            LdapAttributeType lat = LdapAttributeType.parse(atStr);
            if (lat == null) continue;
            ats.put(lat.getName(), lat);
        }
        Iterator<String> ocIter = this.ocs.iterator();
        while (ocIter.hasNext() && this.myLoc == null) {
            String ocStr = ocIter.next();
            LdapObjectClass loc = LdapObjectClass.parse(ocStr, ats);
            if (loc == null || loc.getName().compareToIgnoreCase(this.initialName) != 0) continue;
            this.myLoc = loc;
        }
        boolean ret = true;
        if (this.myLoc != null) {
            this.monoAttrs = this.myLoc.getMonoAttrs();
            this.multiAttrs = this.myLoc.getMultiAttrs();
            if (this.writeContent(this.generateContent(this.myLoc.getInheritFrom()))) {
                this.myLoc.getMonoAttrs().addAll(this.myLoc.getMultiAttrs());
                this.myLoc.getMultiAttrs().clear();
                this.className = "f" + className.substring(0, 1).toUpperCase() + className.substring(1);
                this.packageName = this.getClass().getPackage().getName() + ".flat";
                if (this.writeContent(this.generateContent("f" + this.myLoc.getInheritFrom().substring(0, 1).toUpperCase() + this.myLoc.getInheritFrom().substring(1)))) {
                    LOGGER.info((Object)("POJOs generation successed for " + this.getFileName()));
                    ret &= true;
                } else {
                    LOGGER.info((Object)("Flat POJO generation failed for " + this.getFileName()));
                    ret &= false;
                }
            } else {
                LOGGER.info((Object)("Non flat POJO generation failed for " + this.getFileName()));
                ret &= false;
            }
        } else {
            LOGGER.error((Object)("POJOs generation failed : LDAP objectClass (" + this.initialName + ") could not be found in LDAP directory."));
            ret &= false;
        }
        return ret;
    }

    public String getGenericPackageName() {
        return this.getClass().getPackage().getName();
    }

    public static void run(String ocName, String destination) throws NamingException {
        ObjectClassGenerator ocg = new ObjectClassGenerator();
        ocg.init();
        ocg.setDestination(destination);
        ocg.generate(ocName);
    }
}

