/*
 * Decompiled with CFR 0.152.
 */
package org.interldap.lsc.service;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.naming.NamingException;
import org.interldap.lsc.AbstractGenerator;
import org.interldap.lsc.jndi.parser.LdapAttributeType;
import org.interldap.lsc.jndi.parser.LdapObjectClass;

public class JdbcServiceObjectGenerator
extends AbstractGenerator {
    protected String initialName;
    protected String objectName;
    protected String flatName;
    protected List<String> monoAttrs;
    protected List<String> multiAttrs;
    protected LdapObjectClass myLoc;

    public boolean generate(String className) throws NamingException {
        if (this.ocs == null || this.ocs.size() <= 0 || this.attrs == null || this.attrs.size() <= 0) {
            LOGGER.error((Object)"Generator have to be initialized");
            return false;
        }
        this.initialName = className;
        this.objectName = this.initialName.substring(0, 1).toUpperCase() + this.initialName.substring(1);
        this.flatName = "f" + this.initialName.substring(0, 1).toUpperCase() + this.initialName.substring(1);
        this.className = className.substring(0, 1).toUpperCase() + className.substring(1) + "JDBCService";
        this.packageName = this.getGenericPackageName();
        HashMap<String, LdapAttributeType> ats = new HashMap<String, LdapAttributeType>();
        for (String atStr : this.attrs) {
            LdapAttributeType lat = LdapAttributeType.parse(atStr);
            if (lat == null) continue;
            ats.put(lat.getName(), lat);
        }
        Iterator<String> ocIter = this.ocs.iterator();
        while (ocIter.hasNext() && this.myLoc == null) {
            String ocStr = ocIter.next();
            LdapObjectClass loc = LdapObjectClass.parse(ocStr, ats);
            if (loc == null || loc.getName().compareToIgnoreCase(this.initialName) != 0) continue;
            this.myLoc = loc;
        }
        boolean ret = true;
        if (this.myLoc != null) {
            this.monoAttrs = this.myLoc.getMonoAttrs();
            this.multiAttrs = this.myLoc.getMultiAttrs();
            if (!this.writeContent(this.generateContent())) {
                LOGGER.info((Object)("JndiObject generation failed for " + this.getFileName()));
                ret &= false;
            } else {
                LOGGER.info((Object)("JndiObject generation successed for " + this.getFileName()));
                ret &= true;
            }
            String myFlatPackage = this.getClass().getPackage().getName();
            myFlatPackage = myFlatPackage.substring(0, myFlatPackage.lastIndexOf(".")) + ".objects.flat";
            String inheritFrom = myFlatPackage + ".f" + this.myLoc.getInheritFrom().substring(0, 1).toUpperCase() + this.myLoc.getInheritFrom().substring(1);
            String myXMLFilename = this.getMyXMLFileName();
            if (!this.writeXMLContent(myXMLFilename, this.generateAssociatedXMLContent(inheritFrom))) {
                LOGGER.info((Object)("Associated XML file generation failed for " + myXMLFilename));
                ret &= false;
            } else {
                LOGGER.info((Object)("Associated XML file generation successed for " + myXMLFilename));
                ret &= true;
            }
        } else {
            LOGGER.error((Object)("JndiObject generation failed : LDAP objectClass (" + this.initialName + ") could not be found in LDAP directory."));
            ret &= false;
        }
        return ret;
    }

    private String getMyXMLFileName() {
        String myXMLPackage = this.getClass().getPackage().getName();
        myXMLPackage = myXMLPackage.substring(0, myXMLPackage.lastIndexOf(".")) + ".persistence.xml";
        String mainLocation = null;
        mainLocation = this.destination != null ? this.destination : System.getProperty("user.dir") + this.separator + "src" + this.separator + "impl" + this.separator + "java";
        return mainLocation + this.separator + myXMLPackage.replaceAll("\\.", this.separator) + this.separator + this.objectName + ".xml";
    }

    protected String generateContent() {
        String serviceClassName = super.getClassName();
        String content = "";
        content = content + "package " + this.getPackageName() + ";\n\n";
        content = content + "import java.sql.SQLException;\n";
        content = content + "import java.util.Iterator;\n\n";
        content = content + "import org.apache.log4j.Logger;\n";
        content = content + "import org.interldap.lsc.persistence.DaoConfig;\n\n";
        content = content + "import org.interldap.lsc.objects.flat.fTop;\n";
        content = content + "import org.interldap.lsc.objects.flat." + this.flatName + ";\n\n";
        content = content + "import com.ibatis.sqlmap.client.SqlMapClient;\n\n";
        content = content + "public class " + serviceClassName + " implements IJdbcSrcService {\n\n";
        content = content + "\tprivate Logger LOGGER = Logger.getLogger(" + serviceClassName + ".class);\n\n";
        content = content + "\tprivate static " + serviceClassName + " INSTANCE;\n";
        content = content + "\tprivate SqlMapClient sqlMapper;\n\n";
        content = content + "\tpublic " + serviceClassName + "() {\n" + "\t\tsqlMapper = DaoConfig.getSqlMapClient();\n" + "\t}\n\n";
        content = content + "\tpublic static " + serviceClassName + " getInstance() {\n" + "\t\tif(INSTANCE == null) {\n\t\t\tINSTANCE = new " + serviceClassName + "();\n" + "\t\t\tINSTANCE.sqlMapper = DaoConfig.getSqlMapClient();\n" + "\t\t}\n" + "\t\t\treturn INSTANCE;\n" + "\t}\n\n";
        content = content + "\tpublic final fTop getFlatObject(final String id) {\n\t\ttry {\n\t\t\treturn (" + this.flatName + ") sqlMapper.queryForObject(\"get" + this.objectName + "\", id);\n" + "\t\t} catch (SQLException e) {\n" + "\t\t\tLOGGER.warn(\"Unable to found " + this.initialName + " with id=\" + id + \" (\" + e + \")\", e);\n" + "\t\t}\n" + "\t\treturn null;\n" + "\t}\n\n";
        content = content + "\tpublic final Iterator<String> getIdsList() {\n\t\ttry {\n\t\t\treturn sqlMapper.queryForList(\"get" + this.objectName + "List\", null).iterator();\n" + "\t\t} catch (SQLException e) {\n" + "\t\t\tLOGGER.warn(\"Unable to return objects list (\" + e + \")\", e);\n" + "\t\t}\n" + "\t\treturn null;\n" + "\t}\n\n";
        content = content + "}";
        return content;
    }

    protected String generateAssociatedXMLContent(String inheritFrom) {
        Vector<String> allInheritAttrs = new Vector<String>();
        String xmlContent = "";
        xmlContent = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n";
        xmlContent = xmlContent + "<!DOCTYPE sqlMap PUBLIC \"-//iBATIS.com//DTD SQL Map 2.0//EN\" \"http://www.ibatis.com/dtd/sql-map-2.dtd\">\n\n";
        xmlContent = xmlContent + "<sqlMap namespace=\"" + this.initialName + "\">\n\n";
        xmlContent = xmlContent + "\t<typeAlias alias=\"" + this.objectName + "\" type=\"org.interldap.lsc.objects.flat." + this.flatName + "\" />\n\n";
        if (this.multiAttrs.size() != 0 || this.monoAttrs.size() != 0) {
            xmlContent = xmlContent + "\t<resultMap id=\"" + this.objectName + "Result\" class=\"" + this.objectName + "\">\n";
            String superClassName = inheritFrom;
            while (superClassName != null && superClassName.substring(superClassName.lastIndexOf(".") + 1).compareToIgnoreCase("Object") != 0) {
                LOGGER.debug((Object)("Get inherited attributes from " + superClassName));
                try {
                    Class<?> superClassObject = Class.forName(superClassName);
                    Field[] superAttrsTab = superClassObject.getDeclaredFields();
                    for (int i = 0; i < superAttrsTab.length; ++i) {
                        String attr = superAttrsTab[i].getName();
                        if (allInheritAttrs.contains(attr) || attr.equalsIgnoreCase("logger")) continue;
                        allInheritAttrs.add(attr);
                    }
                    superClassName = superClassObject.getSuperclass().getSimpleName();
                    if (superClassObject.getPackage().getName() == null || superClassObject.getPackage().getName().length() <= 0) continue;
                    superClassName = superClassObject.getPackage().getName() + "." + superClassName;
                }
                catch (Exception e) {
                    LOGGER.error((Object)("Reflective Exception : " + e), (Throwable)e);
                    superClassName = null;
                }
            }
            for (String attribute : this.monoAttrs) {
                if (allInheritAttrs.contains(attribute)) continue;
                allInheritAttrs.add(attribute);
            }
            for (String attribute : this.multiAttrs) {
                if (allInheritAttrs.contains(attribute)) continue;
                allInheritAttrs.add(attribute);
            }
            for (String attr : allInheritAttrs) {
                xmlContent = xmlContent + "\t\t<result property=\"" + attr + "\" column=\"" + attr + "\"/>\n";
            }
            xmlContent = xmlContent + "\t</resultMap>\n\n";
        }
        xmlContent = xmlContent + "\t<select id=\"get" + this.objectName + "\" resultMap=\"" + this.objectName + "Result\" parameterClass=\"string\">\n";
        xmlContent = xmlContent + "\t\t<!-- FILL IT, BE CAREFULL AT SPECIAL CHARACTER REPRESENTATION -->\n";
        xmlContent = xmlContent + "\t\tSelect\n";
        for (String attr : allInheritAttrs) {
            xmlContent = xmlContent + "\t\t\t" + attr + ",\n";
        }
        xmlContent = xmlContent + "\t\t\t...\n";
        xmlContent = xmlContent + "\t\tFROM ...\n\t\t\tWHERE ...\n\t</select>\n\n";
        xmlContent = xmlContent + "\t<select id=\"get" + this.objectName + "List\" resultClass=\"string\">\n";
        xmlContent = xmlContent + "\t\t<!-- FILL IT, BE CAREFULL AT SPECIAL CHARACTER REPRESENTATION -->\n";
        xmlContent = xmlContent + "\t\tSelect ...\n\t\tFROM ...\n\t\t\tWHERE ...\n\t</select>\n\n</sqlMap>";
        return xmlContent;
    }

    public String getGenericPackageName() {
        return this.getClass().getPackage().getName();
    }

    protected boolean writeXMLContent(String fileName, String content) {
        File file = new File(fileName);
        LOGGER.info((Object)("Creating file (" + fileName + ") ..."));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("\n---------------\n" + content + "---------------\n"));
        }
        try {
            if (file.exists()) {
                LOGGER.warn((Object)("XML File generation failed: file (" + fileName + ") already exists."));
            } else {
                if (file.createNewFile()) {
                    FileOutputStream os = new FileOutputStream(file);
                    os.write(content.getBytes());
                    return true;
                }
                LOGGER.error((Object)("XML File generation failed: file (" + fileName + ") could not be created (probably a rights issue)."));
            }
        }
        catch (FileNotFoundException fnfe) {
            LOGGER.error((Object)fnfe, (Throwable)fnfe);
        }
        catch (IOException e) {
            LOGGER.error((Object)e, (Throwable)e);
        }
        return false;
    }

    public static void run(String arg, String destination) throws NamingException {
        JdbcServiceObjectGenerator serviceGenerator = new JdbcServiceObjectGenerator();
        serviceGenerator.init();
        serviceGenerator.setDestination(destination);
        serviceGenerator.generate(arg);
    }
}

