/*
 * Decompiled with CFR 0.152.
 */
package org.interldap.lsc.service;

import com.ibatis.sqlmap.client.SqlMapClient;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.interldap.lsc.objects.flat.fOrganizationalUnit;
import org.interldap.lsc.objects.organizationalUnit;
import org.interldap.lsc.service.IJdbcSrcService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OrganizationalUnitJDBCService
implements IJdbcSrcService {
    private Logger LOGGER = Logger.getLogger(OrganizationalUnitJDBCService.class);
    protected SqlMapClient sqlMapper;
    protected Vector<String> orderedOu = new Vector();
    protected Map<String, List<String>> ouChildren = new HashMap<String, List<String>>();
    protected Map<String, fOrganizationalUnit> ou = new HashMap<String, fOrganizationalUnit>();
    protected boolean init = false;
    protected int lastOuMemberNb = -1;
    protected String sqlFunctionNameForGetMembersList;
    protected String sqlFunctionNameForGetObject;
    protected String sqlFunctionNameForGetObjectList;
    protected String sqlFunctionNameForGetParentObjectId;
    protected String baseDn;

    public List<fOrganizationalUnit> getChildren(String ouId) {
        if (this.init) {
            Iterator childrenIdIter = ((List)((Object)this.ou.get(ouId))).iterator();
            ArrayList<fOrganizationalUnit> children = new ArrayList<fOrganizationalUnit>();
            while (childrenIdIter.hasNext()) {
                String childrenId = (String)childrenIdIter.next();
                children.add(this.ou.get(childrenId));
            }
            return children;
        }
        return new ArrayList<fOrganizationalUnit>();
    }

    public final List getList() {
        if (this.init) {
            return this.orderedOu.subList(0, this.orderedOu.size());
        }
        return new Vector();
    }

    public organizationalUnit getParent(String ouId) {
        List parent = this._getParent(ouId);
        if (parent.size() <= 0) {
            this.LOGGER.warn((Object)("There is a big problem with the structure identified by \"" + ouId + "\": no parent structure !"));
        } else if (parent.size() >= 1) {
            this.LOGGER.warn((Object)("There is a big problem with the structure identified by \"" + ouId + "\": more than one parent !"));
        } else {
            return (organizationalUnit)parent.get(0);
        }
        return null;
    }

    public void initialize() {
        this.init = true;
        ArrayList<String> topLevelOuIds = new ArrayList<String>();
        List originalOuIdList = this._getOuIdList();
        for (String originalOuId : originalOuIdList) {
            List parent = this._getParent(originalOuId);
            while (parent.contains(originalOuId)) {
                parent.remove(originalOuId);
            }
            if (parent.size() <= 0) {
                this.LOGGER.debug((Object)("We got the top ! (\"" + originalOuId + "\")"));
                topLevelOuIds.add(originalOuId);
                continue;
            }
            if (parent.size() > 1) {
                this.LOGGER.warn((Object)("There is a big problem with the structure identified by \"" + originalOuId + "\": more than one parent !"));
                continue;
            }
            String parentId = (String)parent.get(0);
            if (this.ouChildren.containsKey(parentId)) {
                this.ouChildren.get(parentId).add(originalOuId);
                continue;
            }
            ArrayList<String> values = new ArrayList<String>();
            values.add(originalOuId);
            this.ouChildren.put(parentId, values);
        }
        for (String actualOuId : originalOuIdList) {
            fOrganizationalUnit st = this._getOu(actualOuId);
            if (topLevelOuIds.contains(actualOuId)) {
                st.setDistinguishName("ou=" + st.getOu() + "," + this.getBaseDn());
            }
            this.ou.put(actualOuId, st);
        }
        this.initializeVector(topLevelOuIds);
    }

    public fOrganizationalUnit _getOu(String ouId) {
        try {
            return (fOrganizationalUnit)this.sqlMapper.queryForObject(this.getSqlFunctionNameForGetObject(), (Object)ouId);
        }
        catch (SQLException e) {
            this.LOGGER.warn((Object)("Unable to found ou with id=" + ouId + " (" + e + ")"), (Throwable)e);
            return null;
        }
    }

    public List _getOuMemberIdList(String ouId) {
        try {
            List l = this.sqlMapper.queryForList(this.getSqlFunctionNameForGetMembersList(), (Object)ouId);
            this.lastOuMemberNb = l.size();
            return l;
        }
        catch (SQLException e) {
            this.LOGGER.warn((Object)("Unable to return ou member list (" + e + ")"), (Throwable)e);
            return null;
        }
    }

    public int _getNbOuMember() {
        return this.lastOuMemberNb;
    }

    public List _getOuIdList() {
        try {
            return this.sqlMapper.queryForList(this.getSqlFunctionNameForGetObjectsList(), null);
        }
        catch (SQLException e) {
            this.LOGGER.warn((Object)("Unable to return ou list (" + e + ")"), (Throwable)e);
            return null;
        }
    }

    public List _getParent(String ouId) {
        try {
            return this.sqlMapper.queryForList(this.getSqlFunctionNameForGetParentObjectId(), (Object)ouId);
        }
        catch (SQLException e) {
            this.LOGGER.warn((Object)("Unable to return ou parents list (" + e + ")"), (Throwable)e);
            return null;
        }
    }

    private void initializeVector(List<String> ouIds) {
        Iterator<String> ouIdsIter = ouIds.iterator();
        while (ouIdsIter.hasNext()) {
            this.initializeVector(ouIdsIter.next());
        }
    }

    private void initializeVector(String ouId) {
        this.orderedOu.add(ouId);
        List<String> children = this.ouChildren.get(ouId);
        if (children != null) {
            for (String childId : children) {
                fOrganizationalUnit childStructure = this.ou.get(childId);
                childStructure.setDistinguishName("ou=" + childStructure.getOu() + "," + this.ou.get(ouId).getDistinguishName());
                this.initializeVector(childId);
            }
        }
    }

    @Override
    public fOrganizationalUnit getFlatObject(String id) {
        return this.ou.get(id);
    }

    public String getSqlFunctionNameForGetParentObjectId() {
        return this.sqlFunctionNameForGetParentObjectId;
    }

    public String getSqlFunctionNameForGetMembersList() {
        return this.sqlFunctionNameForGetMembersList;
    }

    public String getSqlFunctionNameForGetObject() {
        return this.sqlFunctionNameForGetObject;
    }

    public String getSqlFunctionNameForGetObjectsList() {
        return this.sqlFunctionNameForGetObjectList;
    }

    public String getBaseDn() {
        return this.baseDn;
    }
}

