/*
 * Decompiled with CFR 0.152.
 */
package org.interldap.lsc.service;

import com.ibatis.sqlmap.client.SqlMapClient;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.interldap.lsc.Configuration;
import org.interldap.lsc.objects.Structure;
import org.interldap.lsc.objects.flat.fStructure;
import org.interldap.lsc.persistence.DaoConfig;
import org.interldap.lsc.service.IJdbcSrcService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StructureJDBCService
implements IJdbcSrcService {
    private Logger LOGGER = Logger.getLogger(StructureJDBCService.class);
    private static StructureJDBCService INSTANCE;
    private SqlMapClient sqlMapper;
    private Vector<String> orderedStructures = new Vector();
    private Map<String, List<String>> structuresChildren = new HashMap<String, List<String>>();
    private Map<String, fStructure> structures = new HashMap<String, fStructure>();

    private StructureJDBCService() {
    }

    public static StructureJDBCService getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new StructureJDBCService();
            StructureJDBCService.INSTANCE.sqlMapper = DaoConfig.getSqlMapClient();
            INSTANCE.initialize();
        }
        return INSTANCE;
    }

    private void initialize() {
        ArrayList<String> topLevelStructureIds = new ArrayList<String>();
        List originalStructuresList = this._getStructuresIdList();
        for (String structureId : originalStructuresList) {
            List parent = this._getParentStructureId(structureId);
            while (parent.contains(structureId)) {
                parent.remove(structureId);
            }
            if (parent.size() == 0) {
                if (topLevelStructureIds.size() == 0) {
                    this.LOGGER.debug((Object)("We got the top ! (\"" + structureId + "\")"));
                    topLevelStructureIds.add(structureId.toLowerCase());
                    continue;
                }
                this.LOGGER.warn((Object)("There is a big problem with the structure identified by \"" + structureId + "\": no parent structure and the top level has bean already specified by id=" + topLevelStructureIds + " !"));
                continue;
            }
            String parentId = null;
            if (parent.size() > 1) {
                int maxCount = -1;
                String maxCountTop = null;
                for (String parentIdTmp : parent) {
                    int parentIdCount = this.countSubemployee(parentIdTmp);
                    if (parentIdCount < maxCount) continue;
                    maxCount = parentIdCount;
                    maxCountTop = parentIdTmp;
                }
                if (maxCountTop != null) {
                    parentId = maxCountTop;
                    if (!topLevelStructureIds.contains(maxCountTop.toLowerCase())) {
                        topLevelStructureIds.clear();
                        topLevelStructureIds.add(maxCountTop.toLowerCase());
                    }
                } else {
                    this.LOGGER.warn((Object)("There is a big problem with the structure identified by \"" + structureId + "\": more than one parent !"));
                }
            } else {
                parentId = (String)parent.get(0);
            }
            if (this.structuresChildren.containsKey(parentId)) {
                this.structuresChildren.get(parentId).add(structureId);
                continue;
            }
            ArrayList<String> values = new ArrayList<String>();
            values.add(structureId);
            this.structuresChildren.put(parentId, values);
        }
        Iterator siIter = originalStructuresList.iterator();
        while (siIter.hasNext()) {
            String actualStructureId = (String)siIter.next();
            fStructure st = this._getStructure(actualStructureId);
            if (topLevelStructureIds.size() > 0) {
                if (topLevelStructureIds.contains(st.getOu().toLowerCase())) {
                    st.setDistinguishName("ou=" + st.getOu() + "," + Configuration.DN_STRUCTURES);
                }
            } else if (!siIter.hasNext()) {
                this.LOGGER.warn((Object)("Not able to found one parent, taking the last one ou=" + st.getOu()));
                st.setDistinguishName("ou=" + st.getOu() + "," + Configuration.DN_STRUCTURES);
            }
            this.structures.put(actualStructureId, st);
        }
        Iterator topLevelStructureIdsIter = topLevelStructureIds.iterator();
        while (topLevelStructureIdsIter.hasNext()) {
            this.initializeVector((String)topLevelStructureIdsIter.next(), new ArrayList<String>());
        }
    }

    private void initializeVector(String structureId, List<String> alreadyDoneStructures) {
        alreadyDoneStructures.add(structureId);
        this.orderedStructures.add(structureId);
        List<String> children = this.structuresChildren.get(structureId);
        if (children != null) {
            for (String childId : children) {
                if (alreadyDoneStructures.contains(childId)) continue;
                fStructure childStructure = this.structures.get(childId);
                childStructure.setDistinguishName("ou=" + childStructure.getOu() + "," + this.structures.get(structureId).getDistinguishName());
                this.initializeVector(childId, alreadyDoneStructures);
            }
        }
    }

    @Override
    public fStructure getFlatObject(String id) {
        return this.structures.get(id);
    }

    public int countSubemployee(String grhId) {
        return this._countSubemployee(grhId);
    }

    public Structure getParentStructure(String structureId) {
        List parent = this._getParentStructureId(structureId);
        if (parent.size() <= 0) {
            this.LOGGER.warn((Object)("There is a big problem with the structure identified by \"" + structureId + "\": no parent structure !"));
        } else if (parent.size() >= 1) {
            this.LOGGER.warn((Object)("There is a big problem with the structure identified by \"" + structureId + "\": more than one parent !"));
        } else {
            return (Structure)parent.get(0);
        }
        return null;
    }

    public List getChildrenStructureId(String structureId) {
        Iterator childrenIdIter = ((List)((Object)this.structures.get(structureId))).iterator();
        ArrayList<fStructure> children = new ArrayList<fStructure>();
        while (childrenIdIter.hasNext()) {
            String childrenId = (String)childrenIdIter.next();
            children.add(this.structures.get(childrenId));
        }
        return children;
    }

    @Override
    public Iterator<String> getIdsList() {
        return this.orderedStructures.subList(0, this.orderedStructures.size()).iterator();
    }

    public fStructure _getStructure(String id) {
        try {
            return (fStructure)this.sqlMapper.queryForObject("getStructure", (Object)id);
        }
        catch (SQLException e) {
            this.LOGGER.warn((Object)("Unable to found structure with id=" + id + " (" + e + ")"), (Throwable)e);
            return null;
        }
    }

    private List _getStructuresIdList() {
        try {
            return this.sqlMapper.queryForList("getStructuresIdList", null);
        }
        catch (SQLException e) {
            this.LOGGER.warn((Object)("Unable to return structures list (" + e + ")"), (Throwable)e);
            return null;
        }
    }

    private List _getParentStructureId(String structureId) {
        try {
            return this.sqlMapper.queryForList("getParentStructure", (Object)structureId);
        }
        catch (SQLException e) {
            this.LOGGER.warn((Object)("Unable to return structure parents list (" + e + ")"), (Throwable)e);
        }
        catch (RuntimeException e) {
            this.LOGGER.warn((Object)("Unable to return structure parents list (" + e + ")"), (Throwable)e);
        }
        return null;
    }

    private int _countSubemployee(String grhId) {
        try {
            return (Integer)this.sqlMapper.queryForObject("countSubemployee", (Object)grhId);
        }
        catch (SQLException e) {
            this.LOGGER.warn((Object)("Unable to return count sub employes (" + e + ")"), (Throwable)e);
            return -1;
        }
    }
}

