/*
 * Decompiled with CFR 0.152.
 */
package org.interldap.lsc.service;

import java.lang.reflect.Field;
import java.util.Vector;
import javax.naming.NamingException;
import org.interldap.lsc.service.JdbcServiceObjectGenerator;

public class StructureServiceObjectGenerator
extends JdbcServiceObjectGenerator {
    protected String generateContent() {
        String objectName = this.initialName.substring(0, 1).toUpperCase() + this.initialName.substring(1);
        String serviceClassName = super.getClassName();
        String content = "";
        content = content + "package " + this.getPackageName() + ";\n\n";
        content = content + "import org.interldap.lsc.Configuration;\n\n";
        String inheritedFrom = this.myLoc.getInheritFrom().substring(0, 1).toUpperCase() + this.myLoc.getInheritFrom().substring(1);
        content = content + "public class " + serviceClassName + " extends " + inheritedFrom + "JDBCService {\n\n";
        content = content + "\tprivate static final " + serviceClassName + " INSTANCE = new " + serviceClassName + "();\n";
        content = content + "\tpublic " + serviceClassName + "() {\n" + "\t\t\tbaseDn = TO_FILL_WITH_RIGHT_VALUES;\n" + "\t\t\tsqlFunctionNameForGetMembersList = \"get" + objectName + "MembersList\";\n" + "\t\t\tsqlFunctionNameForGetObject = \"get" + objectName + "\";\n" + "\t\t\tsqlFunctionNameForGetObjectList = \"get" + objectName + "List\";\n" + "\t\t\tsgetSqlFunctionNameForGetParentObjectId = \"getParent" + objectName + "Id\";\n" + "\t}\n\n";
        content = content + "\tpublic static " + serviceClassName + " getInstance() {\n" + "\t\treturn INSTANCE;\n" + "\t}\n\n";
        content = content + "}";
        return content;
    }

    protected String generateAssociatedXMLContent(String inheritFrom) {
        Vector<String> allInheritAttrs = new Vector<String>();
        String xmlContent = "";
        xmlContent = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n";
        xmlContent = xmlContent + "<!DOCTYPE sqlMap PUBLIC \"-//iBATIS.com//DTD SQL Map 2.0//EN\" \"http://www.ibatis.com/dtd/sql-map-2.dtd\">\n\n";
        xmlContent = xmlContent + "<sqlMap namespace=\"" + this.initialName + "\">\n\n";
        xmlContent = xmlContent + "\t<typeAlias alias=\"" + this.objectName + "\" type=\"" + this.flatName + "\" />\n\n";
        if (this.multiAttrs.size() != 0 || this.monoAttrs.size() != 0) {
            xmlContent = xmlContent + "\t<resultMap id=\"" + this.objectName + "Result\" class=\"" + this.objectName + "\">\n";
            String superClassName = inheritFrom;
            while (superClassName != null && superClassName.substring(superClassName.lastIndexOf(".") + 1).compareToIgnoreCase("Object") != 0) {
                LOGGER.debug((Object)("Get inherited attributes from " + superClassName));
                try {
                    Class<?> superClassObject = Class.forName(superClassName);
                    Field[] superAttrsTab = superClassObject.getDeclaredFields();
                    for (int i = 0; i < superAttrsTab.length; ++i) {
                        String attr = superAttrsTab[i].getName();
                        if (allInheritAttrs.contains(attr)) continue;
                        allInheritAttrs.add(attr);
                    }
                    superClassName = superClassObject.getSuperclass().getSimpleName();
                    if (superClassObject.getPackage().getName() == null || superClassObject.getPackage().getName().length() <= 0) continue;
                    superClassName = superClassObject.getPackage().getName() + "." + superClassName;
                }
                catch (Exception e) {
                    System.out.println("Reflective Exception : " + e);
                    superClassName = null;
                }
            }
            for (String attribute : this.monoAttrs) {
                if (allInheritAttrs.contains(attribute)) continue;
                allInheritAttrs.add(attribute);
            }
            for (String attribute : this.multiAttrs) {
                if (allInheritAttrs.contains(attribute)) continue;
                allInheritAttrs.add(attribute);
            }
            for (String attr : allInheritAttrs) {
                xmlContent = xmlContent + "\t\t<result property=\"" + attr + "\" column=\"" + attr + "\"/>\n";
            }
            xmlContent = xmlContent + "\t</resultMap>\n\n";
        }
        xmlContent = xmlContent + "\t<select id=\"get" + this.objectName + "\" resultMap=\"" + this.objectName + "Result\" parameterClass=\"string\">\n";
        xmlContent = xmlContent + "\t\t<!-- FILL IT, BE CAREFULL AT SPECIAL CHARACTER REPRESENTATION -->\n";
        xmlContent = xmlContent + "\t\tSelect\n";
        for (String attr : allInheritAttrs) {
            xmlContent = xmlContent + "\t\t\t" + attr + ",\n";
        }
        xmlContent = xmlContent + "\t\t\t...\n";
        xmlContent = xmlContent + "\t\tFROM ...\n\t\t\tWHERE ...\n\t</select>\n\n";
        xmlContent = xmlContent + "\t<select id=\"get" + this.objectName + "List\" resultClass=\"string\">\n";
        xmlContent = xmlContent + "\t\t<!-- FILL IT, BE CAREFULL AT SPECIAL CHARACTER REPRESENTATION -->\n";
        xmlContent = xmlContent + "\t\tSelect ...\n\t\tFROM ...\n\t\t\tWHERE ...\n\t</select>\n\n";
        xmlContent = xmlContent + "\t<select id=\"get" + this.objectName + "MembersList\" resultClass=\"string\">\n";
        xmlContent = xmlContent + "\t\t<!-- FILL IT, BE CAREFULL AT SPECIAL CHARACTER REPRESENTATION -->\n";
        xmlContent = xmlContent + "\t\tSelect ...\n\t\tFROM ...\n\t\t\tWHERE ...\n\t</select>\n\n";
        xmlContent = xmlContent + "\t<select id=\"getParent" + this.objectName + "Id\" resultClass=\"string\">\n";
        xmlContent = xmlContent + "\t\t<!-- FILL IT, BE CAREFULL AT SPECIAL CHARACTER REPRESENTATION -->\n";
        xmlContent = xmlContent + "\t\tSelect ...\n\t\tFROM ...\n\t\t\tWHERE ...\n\t</select>\n\n";
        xmlContent = xmlContent + "</sqlMap>\n";
        return xmlContent;
    }

    public static void run(String arg) throws NamingException {
        StructureServiceObjectGenerator structureServiceGenerator = new StructureServiceObjectGenerator();
        structureServiceGenerator.init();
        structureServiceGenerator.generate(arg);
    }
}

