/*
 * Decompiled with CFR 0.152.
 */
package org.interldap.lsc.utils;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;
import org.interldap.lsc.utils.CharacterUnacceptedException;
import org.interldap.utils.DateUtils;

public final class Filters {
    private static final String REGEXP_CHARACTERS = "[\\p{Alpha}\\s'\"\u00e1\u00c1&agrave;&agrave;\u00e2\u00c2\u00e4\u00c4&eacute;&eacute;&egrave;&egrave;\u00ea\u00ca\u00eb\u00cb\u00cc\u00ec\u00cd\u00ed\u00ee\u00ce\u00ef\u00cf\u00d2\u00f2\u00d3\u00f3\u00f4\u00d4\u00f6\u00d6\u00f9\u00d9\u00da\u00fa\u00fb\u00db\u00fc\u00dc\u00dd\u00fd\u00e7-]+";
    private static final String[] REGEXP_ACCENTS_CEDILLES = new String[]{"\u00e1", "\u00c1", "&agrave;", "&agrave;", "\u00e2", "\u00c2", "\u00e4", "\u00c4", "&eacute;", "&eacute;", "&egrave;", "&egrave;", "\u00ea", "\u00ca", "\u00eb", "\u00cb", "\u00c8", "\u00c9", "\u00e9", "\u00e8", "\u00cc", "\u00ec", "\u00cd", "\u00ed", "\u00ee", "\u00ce", "\u00ef", "\u00cf", "\u00d2", "\u00f2", "\u00d3", "\u00f3", "\u00f4", "\u00d4", "\u00f6", "\u00d6", "\u00f9", "\u00d9", "\u00da", "\u00fa", "\u00fb", "\u00db", "\u00fc", "\u00dc", "\u00dd", "\u00fd", "\u00e7"};
    private static final String[] REGEXP_STRING_ACCENTS_CEDILLES = new String[]{"a", "A", "a", "A", "a", "A", "a", "A", "e", "E", "e", "E", "e", "E", "e", "E", "E", "E", "e", "e", "I", "i", "I", "i", "i", "I", "i", "I", "O", "o", "O", "o", "o", "O", "o", "O", "u", "U", "U", "u", "u", "U", "u", "U", "Y", "y", "c"};
    private static final String[] SEPARATORS_FOR_UPPER_BEGINNING_NAME = new String[]{" ", "'", "\"", "-", "_"};
    public static final String[] BAD_SEPARATOR_FOR_EMAIL = new String[]{" ", "'", "\""};
    public static final String[] GOOD_SEPARATOR_FOR_EMAIL = new String[]{"_", "_", "_"};
    public static final String[] BAD_SEPARATOR_FOR_PHONE = new String[]{"-", " ", "\\.", "/", "\\+", "\\(", "\\)", ";", ":", "_", ","};
    public static final String[] GOOD_SEPARATOR_FOR_PHONE = new String[]{"", "", "", "", "", "", "", "", "", "", ""};
    private static final String REGEXP_FOR_FISRTNAME = "[\\p{Alpha}\u00e1\u00c1&agrave;&agrave;\u00e2\u00c2\u00e4\u00c4&eacute;&eacute;&egrave;&egrave;\u00ea\u00ca\u00eb\u00cb\u00cc\u00ec\u00cd\u00ed\u00ee\u00ce\u00ef\u00cf\u00d2\u00f2\u00d3\u00f3\u00f4\u00d4\u00f6\u00d6\u00f9\u00d9\u00da\u00fa\u00fb\u00db\u00fc\u00dc\u00dd\u00fd\u00e7' -]+";
    private static final String REGEXP_FOR_LASTNAME = "[\\p{Alpha}\u00e1\u00c1&agrave;&agrave;\u00e2\u00c2\u00e4\u00c4&eacute;&eacute;&egrave;&egrave;\u00ea\u00ca\u00eb\u00cb\u00cc\u00ec\u00cd\u00ed\u00ee\u00ce\u00ef\u00cf\u00d2\u00f2\u00d3\u00f3\u00f4\u00d4\u00f6\u00d6\u00f9\u00d9\u00da\u00fa\u00fb\u00db\u00fc\u00dc\u00dd\u00fd\u00e7'\"\\s -_]+";
    private static final String[] BAD_SEPARATOR_FOR_ID = new String[]{" ", "'", "\"", "-"};
    private static final String GOOD_PASSWORD = "abcdefghijkmnopqrstuvwxyzABCDEFGHJKLMNPQRSTUVWXYZ23456789/";
    private static final String REGEXP_FOR_NUMERICAL_ID = "-?[0123456789]+";
    private static final String REGEXP_FOR_ALPHA_NUMERICAL_ID = "[\\p{Alpha}0123456789]+";

    private Filters() {
    }

    public static boolean containsInTab(String[] tab, String name) {
        boolean trouve = false;
        for (int i = 0; i < tab.length && !trouve; ++i) {
            if (!tab[i].equals(name)) continue;
            trouve = true;
        }
        return trouve;
    }

    public static String removeBadChars(String src) {
        return Filters.filterRegexp(src, REGEXP_ACCENTS_CEDILLES, REGEXP_STRING_ACCENTS_CEDILLES);
    }

    public static String filterRegexp(String src, String[] srcRegexp, String[] destRegexp) {
        String dest = src;
        for (int i = 0; i < srcRegexp.length; ++i) {
            dest = dest.replaceAll(srcRegexp[i], destRegexp[i]);
        }
        return dest;
    }

    private static String filterDelStringIntoString(String charactere, String chaine) {
        String returned = "";
        String tmp = chaine;
        int i = tmp.indexOf(charactere);
        while (i != -1 && i < chaine.length()) {
            returned = returned + tmp.substring(0, i);
            tmp = tmp.substring(i + 1, tmp.length());
            i = tmp.indexOf(charactere);
        }
        if (tmp.length() > 0) {
            returned = returned + tmp;
        }
        return returned;
    }

    public static String filterPhones(String phone2parse) {
        String phoneResult = Filters.filterRegexp(phone2parse, BAD_SEPARATOR_FOR_PHONE, GOOD_SEPARATOR_FOR_PHONE);
        switch (phoneResult.length()) {
            case 8: {
                return "331" + phoneResult;
            }
            case 10: {
                return "33" + phoneResult.substring(1, phoneResult.length());
            }
        }
        return phoneResult;
    }

    private static String toUpperCaseAllBeginingNames(String chaine) {
        String returned = "";
        String tmp = chaine;
        tmp = tmp.substring(0, 1).toUpperCase() + tmp.substring(1, tmp.length());
        for (int j = 0; j < SEPARATORS_FOR_UPPER_BEGINNING_NAME.length; ++j) {
            int i = tmp.indexOf(SEPARATORS_FOR_UPPER_BEGINNING_NAME[j]);
            while (i != -1 && i < tmp.length() - 1) {
                returned = returned + tmp.substring(0, i + 1);
                try {
                    tmp = tmp.substring(i + 1, i + 2).toUpperCase() + tmp.substring(i + 2, tmp.length());
                }
                catch (StringIndexOutOfBoundsException e) {
                    System.err.println(e + " caused by '" + chaine + "'");
                    throw e;
                }
                i = tmp.indexOf(SEPARATORS_FOR_UPPER_BEGINNING_NAME[j]);
            }
        }
        if (tmp.length() > 0) {
            returned = returned + tmp;
        }
        return returned;
    }

    public static String filterSn(String sn) throws CharacterUnacceptedException {
        String tmp = Filters.toUpperCaseAllBeginingNames(Filters.filterName(sn));
        if (!tmp.matches(REGEXP_FOR_LASTNAME)) {
            throw new CharacterUnacceptedException();
        }
        return tmp;
    }

    private static String filterBadChars(String startString) {
        String tmp = Filters.filterName(startString);
        for (int i = 0; i < BAD_SEPARATOR_FOR_ID.length; ++i) {
            tmp = Filters.filterDelStringIntoString(BAD_SEPARATOR_FOR_ID[i], tmp);
        }
        tmp = Filters.removeBadChars(tmp);
        return tmp;
    }

    public static String filterUid(String sn) {
        String tmp = Filters.filterBadChars(sn);
        if (tmp.length() > 14) {
            return tmp.substring(0, 14);
        }
        return tmp;
    }

    public static String filterShortUid(String sn) {
        String tmp = Filters.filterBadChars(sn);
        if (tmp.length() > 8) {
            return tmp.substring(0, 8);
        }
        return tmp;
    }

    public static String filterNomPatronymique(String name) throws CharacterUnacceptedException {
        String tmp = Filters.toUpperCaseAllBeginingNames(Filters.filterName(name));
        if (!tmp.matches(REGEXP_CHARACTERS)) {
            throw new CharacterUnacceptedException(tmp);
        }
        return tmp;
    }

    public static String filterPrenomEtatCivil(String name) throws CharacterUnacceptedException {
        String tmp = Filters.toUpperCaseAllBeginingNames(Filters.filterName(name));
        if (!tmp.matches(REGEXP_FOR_FISRTNAME)) {
            throw new CharacterUnacceptedException(tmp);
        }
        return tmp;
    }

    public static String filterGivenName(String oldValue) throws CharacterUnacceptedException {
        String tmp = Filters.toUpperCaseAllBeginingNames(Filters.filterName(oldValue));
        if (!tmp.matches(REGEXP_FOR_FISRTNAME)) {
            throw new CharacterUnacceptedException(tmp);
        }
        return tmp;
    }

    public static String generatePwd() {
        StringBuffer passwd = new StringBuffer("");
        Random r = new Random();
        for (int i = 0; i < 8; ++i) {
            passwd.append(GOOD_PASSWORD.charAt(r.nextInt(64)));
        }
        return passwd.toString();
    }

    public static String filterName(String aString) {
        String tmp = aString.trim().replace('.', '-').toLowerCase();
        while (tmp.lastIndexOf(45) == tmp.length() - 1) {
            if (tmp.length() != 1) {
                tmp = tmp.substring(0, tmp.length() - 1);
                continue;
            }
            tmp = "UNKNOWN";
        }
        return tmp;
    }

    public static String filterString(String aString) {
        return aString.trim();
    }

    public static String filterNumber(String value) throws CharacterUnacceptedException {
        int n = Integer.parseInt(value);
        String tmp = String.valueOf(n);
        if (!tmp.matches(REGEXP_FOR_NUMERICAL_ID)) {
            throw new CharacterUnacceptedException(tmp);
        }
        return tmp;
    }

    public static String filterAlpha(String value) throws CharacterUnacceptedException {
        String tmp = value.trim();
        if (!tmp.matches(REGEXP_FOR_ALPHA_NUMERICAL_ID)) {
            throw new CharacterUnacceptedException(tmp);
        }
        return tmp;
    }

    public static String filterDate(String value, String format) throws CharacterUnacceptedException {
        SimpleDateFormat myFormat;
        Date myDate;
        String tmp = value.trim();
        if (tmp.length() > 0 && (myDate = (myFormat = new SimpleDateFormat(format)).parse(value, new ParsePosition(0))) != null) {
            return DateUtils.format(myDate);
        }
        throw new CharacterUnacceptedException(tmp);
    }
}

