/*
 * Decompiled with CFR 0.152.
 */
package org.interldap.lsc.utils;

import java.util.Iterator;
import java.util.List;
import javax.naming.InvalidNameException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.ModificationItem;
import javax.naming.ldap.LdapName;
import org.apache.log4j.Layout;
import org.apache.log4j.SimpleLayout;
import org.apache.log4j.spi.LoggingEvent;
import org.interldap.lsc.jndi.JndiModifications;
import org.linagora.interldap.common.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalizedJndiModificationsLayout
extends Layout {
    private SimpleLayout sl = new SimpleLayout();

    public String format(LoggingEvent le) {
        Object message = le.getMessage();
        if (!JndiModifications.class.isAssignableFrom(message.getClass())) {
            return this.sl.format(le);
        }
        JndiModifications jm = (JndiModifications)message;
        String msg = null;
        switch (jm.getOperation()) {
            case 0: {
                msg = I18n.getMessage((Object)((Object)this), (String)"ADD_ENTRY", (Object[])new Object[]{jm.getDistinguishName(), this.listToLdif(jm.getModificationItems(), true)});
                break;
            }
            case 3: {
                try {
                    LdapName ln = new LdapName(jm.getNewDistinguishName());
                    msg = I18n.getMessage((Object)((Object)this), (String)"MODRDN_ENTRY", (Object[])new Object[]{jm.getDistinguishName(), ln.get(0), ln.getSuffix(1)});
                }
                catch (InvalidNameException e) {
                    msg = I18n.getMessage((Object)((Object)this), (String)"MODRDN_ENTRY", (Object[])new Object[]{jm.getDistinguishName(), jm.getNewDistinguishName(), jm.getNewDistinguishName()});
                }
                break;
            }
            case 2: {
                msg = I18n.getMessage((Object)((Object)this), (String)"MODIFY_ENTRY", (Object[])new Object[]{jm.getDistinguishName(), this.listToLdif(jm.getModificationItems(), false)});
                break;
            }
            case 1: {
                msg = I18n.getMessage((Object)((Object)this), (String)"REMOVE_ENTRY", (Object[])new Object[]{jm.getDistinguishName()});
                break;
            }
        }
        return msg;
    }

    private String listToLdif(List<?> modificationItems, boolean addEntry) {
        StringBuffer sb = new StringBuffer();
        Iterator<?> miIter = modificationItems.iterator();
        boolean first = true;
        while (miIter.hasNext()) {
            ModificationItem mi = (ModificationItem)miIter.next();
            Attribute attr = mi.getAttribute();
            try {
                if (!addEntry) {
                    if (!first) {
                        sb.append("\n--\n");
                    }
                    switch (mi.getModificationOp()) {
                        case 3: {
                            sb.append("delete: ").append(attr.getID()).append("\n");
                            break;
                        }
                        case 2: {
                            sb.append("replace: ").append(attr.getID()).append("\n");
                            break;
                        }
                        default: {
                            sb.append("add: ").append(attr.getID()).append("\n");
                        }
                    }
                }
                NamingEnumeration<?> ne = attr.getAll();
                while (ne.hasMore()) {
                    Object value = ne.next();
                    sb.append(attr.getID()).append(": ").append(value).append("\n");
                }
            }
            catch (NamingException e) {
                sb.append(attr.getID()).append(": ").append("!!! Unable to print value !!!\n");
            }
            first = false;
        }
        return sb.toString();
    }

    public boolean ignoresThrowable() {
        return false;
    }

    public void activateOptions() {
    }
}

