/*
 * Decompiled with CFR 0.152.
 */
package org.lsc;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.lsc.AbstractSynchronize;
import org.lsc.InfoCounter;
import org.lsc.LscDatasets;
import org.lsc.SynchronizeTask;
import org.lsc.SynchronizeThreadPoolExecutor;
import org.lsc.Task;
import org.lsc.exception.LscServiceException;
import org.lsc.service.IAsynchronousService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AsynchronousRunner
implements Runnable {
    static final Logger LOGGER = LoggerFactory.getLogger(AsynchronousRunner.class);
    private AbstractSynchronize abstractSynchronize;
    private Task task;
    private InfoCounter counter;

    public AsynchronousRunner(Task task, AbstractSynchronize abstractSynchronize) {
        this.task = task;
        this.abstractSynchronize = abstractSynchronize;
    }

    @Override
    public void run() {
        this.counter = new InfoCounter();
        SynchronizeThreadPoolExecutor threadPool = new SynchronizeThreadPoolExecutor(this.abstractSynchronize.getThreads());
        Map.Entry<String, LscDatasets> nextId = null;
        try {
            IAsynchronousService aService = null;
            boolean fromSource = true;
            if (this.task.getDestinationService() instanceof IAsynchronousService) {
                aService = (IAsynchronousService)((Object)this.task.getDestinationService());
                fromSource = false;
            } else if (this.task.getSourceService() instanceof IAsynchronousService) {
                aService = (IAsynchronousService)this.task.getSourceService();
            } else {
                LOGGER.error("LSC should never reach this point ! Please consider debugging the code because we are trying to launch an asynchronous sync without any asynchronous servoice !");
                return;
            }
            AbstractSynchronize.LOGGER.debug("Asynchronous synchronize {}", (Object)this.task.getName());
            boolean interrupted = false;
            while (!interrupted) {
                nextId = aService.getNextId();
                if (nextId != null) {
                    threadPool.runTask(new SynchronizeTask(this.task, this.counter, this.abstractSynchronize, nextId, fromSource));
                    continue;
                }
                try {
                    Thread.sleep(aService.getInterval());
                }
                catch (InterruptedException e) {
                    AbstractSynchronize.LOGGER.debug("Synchronization thread interrupted !");
                    interrupted = true;
                }
            }
        }
        catch (LscServiceException e) {
            this.counter.incrementCountError();
            this.abstractSynchronize.logActionError(null, nextId, e);
        }
        try {
            threadPool.shutdown();
            threadPool.awaitTermination(this.abstractSynchronize.getTimeLimit(), TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            LOGGER.error("Tasks terminated according to time limit: " + e.toString(), (Throwable)e);
            LOGGER.info("If you want to avoid this message, increase the time limit by using dedicated parameter.");
        }
    }

    public InfoCounter getCounter() {
        return this.counter;
    }
}

