/*
 * Decompiled with CFR 0.152.
 */
package org.lsc;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.joran.spi.JoranException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;
import org.lsc.configuration.CsvAuditType;
import org.lsc.configuration.JaxbXmlConfigurationHelper;
import org.lsc.configuration.LdapConnectionType;
import org.lsc.configuration.LdifAuditType;
import org.lsc.configuration.LscConfiguration;
import org.lsc.configuration.PropertiesConfigurationHelper;
import org.lsc.exception.LscConfigurationException;
import org.lsc.exception.LscException;
import org.lsc.jndi.JndiServices;
import org.lsc.utils.output.CsvLayout;
import org.lsc.utils.output.LdifLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configuration {
    private static final Logger LOGGER = LoggerFactory.getLogger(Configuration.class);
    public static final String PROPERTIES_FILENAME = "lsc.properties";
    public static final String DATABASE_PROPERTIES_FILENAME = "database.properties";
    public static String location;
    private static boolean loggingSetup;
    public static String DN_PEOPLE;
    public static String DN_LDAP_SCHEMA;
    public static String DN_ENHANCED_SCHEMA;
    public static String DN_STRUCTURES;
    public static String DN_ACCOUNTS;
    public static String OBJECTCLASS_PERSON;
    public static String OBJECTCLASS_EMPLOYEE;
    public static int DAYS_BEFORE_SUPPRESSION;
    public static String DN_REAL_ROOT;
    public static int UID_MAX_LENGTH;
    private static PropertiesConfiguration config;
    public static final String LSC_TASKS_PREFIX = "lsc.tasks";
    public static final String LSC_SYNCOPTIONS_PREFIX = "lsc.syncoptions";
    public static final int MAX_CONCURRENT_SYNCHRONIZED = 100000;

    protected Configuration() {
    }

    @Deprecated
    public static Properties getSrcProperties() throws LscConfigurationException {
        return JndiServices.getLdapProperties((LdapConnectionType)LscConfiguration.getConnection("src-ldap"));
    }

    @Deprecated
    public static Properties getDstProperties() throws LscConfigurationException {
        return JndiServices.getLdapProperties((LdapConnectionType)LscConfiguration.getConnection("dst-ldap"));
    }

    @Deprecated
    public static Properties getAsProperties(String prefix) {
        return Configuration.getAsProperties(Configuration.getConfiguration(), prefix);
    }

    @Deprecated
    public static Properties getAsProperties(String filename, String prefix) {
        return Configuration.getAsProperties(Configuration.getConfiguration(filename), prefix);
    }

    @Deprecated
    public static Properties getAsProperties(PropertiesConfiguration propsConf, String prefix) {
        org.apache.commons.configuration.Configuration conf = propsConf.subset(prefix);
        if (conf == null) {
            return null;
        }
        Iterator it = conf.getKeys();
        Properties result = new Properties();
        String key = null;
        String value = null;
        while (it.hasNext()) {
            key = (String)it.next();
            value = Configuration.asString(conf.getProperty(key));
            result.put(key, value);
        }
        return result;
    }

    public static Properties getPropertiesSubset(Properties originalProperties, String prefix) {
        if (originalProperties == null) {
            return null;
        }
        Properties result = new Properties();
        for (Object propertyName : originalProperties.keySet()) {
            String propertyNameStr = (String)propertyName;
            if (!propertyNameStr.startsWith(prefix + ".")) continue;
            String newPropertyName = propertyNameStr.substring(prefix.length() + 1);
            result.put(newPropertyName, originalProperties.getProperty(propertyNameStr));
        }
        return result;
    }

    @Deprecated
    public static int getInt(String key, int defaultValue) {
        return Configuration.getConfiguration().getInt(key, defaultValue);
    }

    @Deprecated
    public static String getString(String key) {
        return Configuration.asString(Configuration.getConfiguration().getProperty(key));
    }

    @Deprecated
    public static String getString(String key, String defaultValue) {
        Object o = Configuration.getConfiguration().getProperty(key);
        if (o == null) {
            return defaultValue;
        }
        return Configuration.asString(o);
    }

    private static String cleanup(String path) {
        String ret = path.trim();
        if (ret.charAt(0) == '\'' && ret.charAt(ret.length() - 1) == '\'') {
            ret = ret.substring(1, ret.length() - 1);
        }
        return ret;
    }

    public static String getConfigurationDirectory() {
        if (location == null) {
            Configuration.setUp();
        }
        return location != null ? new File(location).getAbsolutePath() + File.separator : "";
    }

    @Deprecated
    protected static PropertiesConfiguration getConfiguration() {
        return Configuration.getConfiguration(new File(location, PROPERTIES_FILENAME).getAbsolutePath());
    }

    @Deprecated
    protected static PropertiesConfiguration getConfiguration(String filename) {
        if (config == null) {
            URL url = null;
            try {
                url = new File(filename).toURI().toURL();
                LOGGER.debug("Loading configuration url: {}", (Object)url);
                config = new PropertiesConfiguration(url);
                config.getKeys();
                DN_PEOPLE = Configuration.getString("dn.people", DN_PEOPLE);
                DN_LDAP_SCHEMA = Configuration.getString("dn.ldap_schema", DN_LDAP_SCHEMA);
                DN_ENHANCED_SCHEMA = Configuration.getString("dn.ldap_schema", DN_ENHANCED_SCHEMA);
                DN_STRUCTURES = Configuration.getString("dn.structures", DN_STRUCTURES);
                DN_ACCOUNTS = Configuration.getString("dn.accounts", DN_STRUCTURES);
                OBJECTCLASS_PERSON = Configuration.getString("objectclass.person", OBJECTCLASS_PERSON);
                OBJECTCLASS_EMPLOYEE = Configuration.getString("objectclass.employee", OBJECTCLASS_EMPLOYEE);
                DAYS_BEFORE_SUPPRESSION = Configuration.getInt("suppression.MARQUAGE_NOMBRE_DE_JOURS", DAYS_BEFORE_SUPPRESSION);
                DN_REAL_ROOT = Configuration.getString("dn.real_root", DN_REAL_ROOT);
                UID_MAX_LENGTH = Configuration.getInt("uid.maxlength", UID_MAX_LENGTH);
            }
            catch (ConfigurationException e) {
                throw new RuntimeException("Unable to find '" + url + "' file", e);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Unable to find file", e);
            }
        }
        return config;
    }

    private static String asString(Object value) {
        if (value instanceof List) {
            List list = (List)value;
            value = StringUtils.join(list.iterator(), (String)",");
        }
        return (String)value;
    }

    public static void setProperties(String prefix, Properties props) throws ConfigurationException {
        Enumeration<Object> propsEnum = props.keys();
        PropertiesConfiguration conf = Configuration.getConfiguration();
        while (propsEnum.hasMoreElements()) {
            String key = (String)propsEnum.nextElement();
            conf.setProperty((prefix != null ? prefix + "." : "") + key, (Object)props.getProperty(key));
        }
        conf.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static Properties getPropertiesFromFile(String pathToFile) throws FileNotFoundException, IOException {
        File propertiesFile = new File(pathToFile);
        Properties props = new Properties();
        FileInputStream st = new FileInputStream(propertiesFile);
        try {
            props.load(st);
        }
        finally {
            ((InputStream)st).close();
        }
        return props;
    }

    @Deprecated
    public static Properties getPropertiesFromFileInConfigDir(String fileName) throws FileNotFoundException, IOException {
        return Configuration.getPropertiesFromFile(Configuration.getConfigurationDirectory() + fileName);
    }

    public static void setUp() {
        if (LscConfiguration.isInitialized()) {
            return;
        }
        try {
            if (new File(System.getProperty("LSC_HOME"), "etc").isDirectory() && new File(System.getProperty("LSC_HOME"), "etc/lsc.xml").exists()) {
                Configuration.setUp(new File(System.getProperty("LSC_HOME"), "etc").getAbsolutePath(), false);
            } else if (Configuration.class.getClassLoader().getResource("etc") != null) {
                Configuration.setUp(Configuration.class.getClassLoader().getResource("etc").getPath(), false);
            }
        }
        catch (LscException le) {
            System.err.println("Something strange appened: " + le.getMessage());
        }
    }

    public static void setUp(String lscConfigurationPath) throws LscException {
        Configuration.setUp(lscConfigurationPath, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void setUp(String lscConfigurationPath, boolean validate) throws LscException {
        block12: {
            String message = null;
            if (lscConfigurationPath == null || !new File(lscConfigurationPath).isDirectory() || !new File(lscConfigurationPath, "lsc.xml").isFile() && !new File(lscConfigurationPath, PROPERTIES_FILENAME).isFile()) {
                message = "Defined configuration location (" + lscConfigurationPath + ") points to a non existing LSC configured instance. LSC configuration loading will fail !";
                LOGGER.error(message);
                throw new RuntimeException(message);
            }
            try {
                location = Configuration.cleanup(lscConfigurationPath);
                if (!LscConfiguration.isInitialized()) {
                    File xml = new File(location, "lsc.xml");
                    File properties = new File(location, PROPERTIES_FILENAME);
                    if (xml.exists() && xml.isFile()) {
                        LscConfiguration.loadFromInstance(new JaxbXmlConfigurationHelper().getConfiguration(xml.toString()));
                        break block12;
                    }
                    if (properties.exists() && properties.isFile()) {
                        LOGGER.warn("LSC configuration loaded from old properties file format !");
                        PropertiesConfigurationHelper.loadConfigurationFrom(properties.getAbsolutePath());
                        break block12;
                    } else {
                        message = "Unable to load configuration configuration inside the directory: " + location;
                        LOGGER.error(message);
                        return;
                    }
                }
                LOGGER.error("LSC already configured. Unable to load new parameters ...");
            }
            catch (LscConfigurationException e) {
                message = "Unable to load configuration (" + e + ")";
                LOGGER.error(message, (Throwable)e);
                return;
            }
        }
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        JoranConfigurator configurator = new JoranConfigurator();
        configurator.setContext((Context)context);
        context.reset();
        String logBackXMLPropertiesFile = new File(Configuration.getConfigurationDirectory(), "logback.xml").getAbsolutePath();
        try {
            configurator.doConfigure(logBackXMLPropertiesFile);
            LOGGER.info("Logging configuration successfully loaded from " + logBackXMLPropertiesFile + " ");
            if (LscConfiguration.getAudit("CSV") != null) {
                Configuration.setUpCsvLogging(context);
            }
            if (LscConfiguration.getAudit("LDIF") != null) {
                Configuration.setUpLdifLogging(context);
            }
        }
        catch (JoranException je) {
            System.err.println("Cannot find logging configuration file (" + logBackXMLPropertiesFile + ") !");
        }
        Configuration.setLoggingSetup(true);
        if (validate) {
            LscConfiguration.getInstance().validate();
        }
        LOGGER.info("LSC configuration successfully loaded from {}", (Object)Configuration.getConfigurationDirectory());
    }

    public static void assertPropertyNotEmpty(String propertyName, String propertyValue, String location) throws LscConfigurationException {
        if (propertyValue == null || propertyValue.length() == 0) {
            throw new RuntimeException("No " + propertyName + " property specified in " + location + ". Aborting.");
        }
    }

    public static void setLoggingSetup(boolean loggingSetup) {
        Configuration.loggingSetup = loggingSetup;
    }

    public static boolean isLoggingSetup() {
        return loggingSetup;
    }

    protected static void setUpCsvLogging(LoggerContext context) {
        CsvAuditType audit = (CsvAuditType)LscConfiguration.getAudit("CSV");
        FileAppender appender = new FileAppender();
        appender.setName(audit.getName());
        appender.setAppend(audit.isAppend().booleanValue());
        appender.setFile(audit.getFile());
        appender.setContext((Context)context);
        CsvLayout csvLayout = new CsvLayout();
        csvLayout.setLogOperations(audit.getOperations());
        csvLayout.setAttrs(audit.getDatasets());
        csvLayout.setSeparator(audit.getSeparator());
        csvLayout.setOutputHeader(audit.isOutputHeader());
        if (audit.getTaskNames() != null && audit.getTaskNames().getString() != null) {
            csvLayout.setTaskNames(audit.getTaskNames().getString().toArray(new String[audit.getTaskNames().getString().size()]));
        }
        csvLayout.setContext((Context)context);
        csvLayout.start();
        appender.setLayout((Layout)csvLayout);
        appender.start();
        ch.qos.logback.classic.Logger rootLogger = context.getLogger("ROOT");
        rootLogger.addAppender((Appender)appender);
    }

    protected static void setUpLdifLogging(LoggerContext context) {
        LdifAuditType audit = (LdifAuditType)LscConfiguration.getAudit("LDIF");
        FileAppender appender = new FileAppender();
        appender.setName(audit.getName());
        appender.setAppend(audit.isAppend().booleanValue());
        appender.setFile(audit.getFile());
        appender.setContext((Context)context);
        LdifLayout ldifLayout = new LdifLayout();
        ldifLayout.setLogOperations(audit.getOperations());
        if (audit.isLogOnlyLdif() != null) {
            ldifLayout.setOnlyLdif(audit.isLogOnlyLdif());
        }
        ldifLayout.setContext((Context)context);
        ldifLayout.start();
        appender.setLayout((Layout)ldifLayout);
        appender.start();
        ch.qos.logback.classic.Logger rootLogger = context.getLogger("ROOT");
        rootLogger.addAppender((Appender)appender);
    }

    static {
        loggingSetup = false;
        DN_PEOPLE = "ou=People";
        DN_LDAP_SCHEMA = "cn=Subschema";
        DN_ENHANCED_SCHEMA = "ou=Schema,ou=System";
        DN_STRUCTURES = "ou=Structures";
        DN_ACCOUNTS = "ou=Accounts";
        OBJECTCLASS_PERSON = "inetOrgPerson";
        OBJECTCLASS_EMPLOYEE = "inetOrgPerson";
        DAYS_BEFORE_SUPPRESSION = 90;
        DN_REAL_ROOT = "dc=lsc-project,dc=org";
        UID_MAX_LENGTH = 8;
        config = null;
    }
}

