/*
 * Decompiled with CFR 0.152.
 */
package org.lsc.jndi;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.lsc.Configuration;
import org.lsc.LscDatasets;
import org.lsc.beans.IBean;
import org.lsc.configuration.LdapConnectionType;
import org.lsc.configuration.LdapServiceType;
import org.lsc.exception.LscConfigurationException;
import org.lsc.exception.LscServiceConfigurationException;
import org.lsc.jndi.JndiServices;
import org.lsc.utils.SetUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSimpleJndiService
implements Closeable {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractSimpleJndiService.class);
    protected String filterIdSync;
    protected String filterAll;
    protected String baseDn;
    protected List<String> attrsId;
    protected List<String> attrs;
    protected SearchControls _filteredSc;
    protected JndiServices jndiServices;

    @Deprecated
    public AbstractSimpleJndiService(Properties serviceProps) throws LscServiceConfigurationException {
        String attrsIdValue;
        this.baseDn = serviceProps.getProperty("baseDn");
        this.filterIdSync = serviceProps.getProperty("filterId");
        this.filterAll = serviceProps.getProperty("filterAll");
        this._filteredSc = new SearchControls();
        String attrsValue = serviceProps.getProperty("attrs");
        if (attrsValue != null) {
            String[] attributes = attrsValue.split(" ");
            this.attrs = Arrays.asList(attributes);
            this._filteredSc.setReturningAttributes(attributes);
        }
        if ((attrsIdValue = serviceProps.getProperty("pivotAttrs")) != null) {
            this.attrsId = Arrays.asList(attrsIdValue.split(" "));
        }
        try {
            Configuration.assertPropertyNotEmpty("filterId", this.filterIdSync, this.getClass().getName());
            Configuration.assertPropertyNotEmpty("filterAll", this.filterAll, this.getClass().getName());
        }
        catch (LscConfigurationException e) {
            throw new LscServiceConfigurationException(e);
        }
        try {
            this.jndiServices = JndiServices.getInstance(serviceProps);
        }
        catch (NamingException e) {
            throw new LscServiceConfigurationException(e);
        }
        catch (IOException e) {
            throw new LscServiceConfigurationException(e);
        }
        LOGGER.warn("Properties configuration is not any more supported ! Please consider upgrading your LSC version !");
    }

    public AbstractSimpleJndiService(LdapServiceType ldapService) throws LscServiceConfigurationException {
        this.baseDn = ldapService.getBaseDn();
        this.filterIdSync = ldapService.getOneFilter() != null ? ldapService.getOneFilter().trim() : ldapService.getGetOneFilter().trim();
        this.filterAll = ldapService.getAllFilter() != null ? ldapService.getAllFilter().trim() : ldapService.getGetAllFilter().trim();
        this._filteredSc = new SearchControls();
        this._filteredSc.setReturningAttributes(ldapService.getFetchedAttributes().getString().toArray(new String[ldapService.getFetchedAttributes().getString().size()]));
        this.attrsId = new ArrayList<String>(ldapService.getPivotAttributes().getString().size());
        for (String pivotAttr : ldapService.getPivotAttributes().getString()) {
            this.attrsId.add(pivotAttr);
        }
        this.attrs = new ArrayList<String>(ldapService.getFetchedAttributes().getString().size());
        for (String attr : ldapService.getFetchedAttributes().getString()) {
            this.attrs.add(attr);
        }
        this.jndiServices = JndiServices.getInstance((LdapConnectionType)ldapService.getConnection().getReference());
        if (!this.baseDn.endsWith(this.jndiServices.getContextDn())) {
            LOGGER.warn("Your baseDn settings (" + this.baseDn + ") does not end with the LDAP naming context (" + this.jndiServices.getContextDn() + "). This is probably an error ! For LSC 1.X users, this is part of the changelog to 2.X.");
        }
    }

    public final IBean getBeanFromSR(SearchResult sr, IBean beanToFill) throws NamingException {
        if (sr == null) {
            return null;
        }
        beanToFill.setMainIdentifier(sr.getNameInNamespace());
        NamingEnumeration<? extends Attribute> ne = sr.getAttributes().getAll();
        while (ne.hasMore()) {
            Attribute attr = ne.next();
            beanToFill.setDataset(attr.getID(), SetUtils.attributeToSet(attr));
        }
        return beanToFill;
    }

    protected static List<?> getValue(NamingEnumeration<?> ne) throws NamingException {
        ArrayList l = new ArrayList();
        while (ne.hasMore()) {
            l.add(ne.next());
        }
        return l;
    }

    public SearchResult get(String id, LscDatasets pivotAttrs, boolean fromSource, String searchString) throws NamingException {
        searchString = Pattern.compile("\\{id\\}", 2).matcher(searchString).replaceAll(Matcher.quoteReplacement(id));
        if (pivotAttrs != null && pivotAttrs.getDatasets() != null && pivotAttrs.getDatasets().size() > 0) {
            for (String attributeName : pivotAttrs.getAttributesNames()) {
                String valueId = pivotAttrs.getValueForFilter(attributeName.toLowerCase());
                searchString = Pattern.compile("\\{" + attributeName + "\\}", 2).matcher(searchString).replaceAll(Matcher.quoteReplacement(valueId));
            }
        } else {
            searchString = this.attrsId.size() == 1 ? Pattern.compile("\\{" + this.attrsId.get(0) + "\\}", 2).matcher(searchString).replaceAll(Matcher.quoteReplacement(id)) : this.filterIdSync.replaceAll("\\{0\\}", Matcher.quoteReplacement(id));
        }
        return this.getJndiServices().getEntry(this.baseDn, searchString, this._filteredSc);
    }

    @Override
    public void close() throws IOException {
        try {
            this.jndiServices.finalize();
        }
        catch (Throwable e) {
            throw new IOException(e);
        }
    }

    public final JndiServices getJndiServices() {
        return this.jndiServices;
    }

    public final List<String> getAttrsId() {
        return this.attrsId;
    }

    public final List<String> getAttrs() {
        return this.attrs;
    }

    public final String getBaseDn() {
        return this.baseDn;
    }

    public final String getFilterAll() {
        return this.filterAll;
    }

    public final String getFilterId() {
        return this.filterIdSync;
    }
}

