/*
 * Decompiled with CFR 0.152.
 */
package org.lsc.jndi;

import java.util.Map;
import java.util.Properties;
import javax.naming.NamingException;
import org.lsc.LscDatasets;
import org.lsc.beans.IBean;
import org.lsc.configuration.LdapSourceServiceType;
import org.lsc.configuration.LscConfiguration;
import org.lsc.configuration.TaskType;
import org.lsc.exception.LscServiceConfigurationException;
import org.lsc.exception.LscServiceException;
import org.lsc.jndi.AbstractSimpleJndiService;
import org.lsc.service.IService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleJndiSrcService
extends AbstractSimpleJndiService
implements IService {
    protected static final Logger LOGGER = LoggerFactory.getLogger(SimpleJndiSrcService.class);
    protected Class<IBean> beanClass;
    protected String filterIdClean;

    @Deprecated
    public SimpleJndiSrcService(Properties props, String beanClassName) throws LscServiceConfigurationException {
        super(props);
        this.filterIdClean = props.getProperty("filterIdClean");
        try {
            this.beanClass = Class.forName(beanClassName);
        }
        catch (ClassNotFoundException e) {
            throw new LscServiceConfigurationException(e);
        }
    }

    public SimpleJndiSrcService(TaskType task) throws LscServiceConfigurationException {
        super((LdapSourceServiceType)LscConfiguration.getSourceService(task));
        this.filterIdClean = ((LdapSourceServiceType)LscConfiguration.getSourceService(task)).getCleanFilter();
        if (this.filterIdClean == null) {
            LOGGER.warn("No clean filter has been specified for task=" + task.getName() + ". During the clean phase, LSC wouldn't be able to get the right entries and may delete all destination entries !");
        }
        try {
            this.beanClass = Class.forName(task.getBean());
        }
        catch (ClassNotFoundException e) {
            throw new LscServiceConfigurationException(e);
        }
    }

    @Override
    public IBean getBean(String pivotName, LscDatasets pivotAttributes, boolean fromSameService) throws LscServiceException {
        try {
            IBean srcBean = this.beanClass.newInstance();
            String searchString = null;
            searchString = fromSameService || this.filterIdClean == null ? this.filterIdSync : this.filterIdClean;
            return this.getBeanFromSR(this.get(pivotName, pivotAttributes, fromSameService, searchString), srcBean);
        }
        catch (InstantiationException e) {
            LOGGER.error("Bad class name: " + this.beanClass.getName() + "(" + e + ")");
            LOGGER.debug(e.toString(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOGGER.error("Bad class name: " + this.beanClass.getName() + "(" + e + ")");
            LOGGER.debug(e.toString(), (Throwable)e);
        }
        catch (NamingException e) {
            throw new LscServiceException(e);
        }
        return null;
    }

    @Override
    public Map<String, LscDatasets> getListPivots() throws LscServiceException {
        try {
            return this.jndiServices.getAttrsList(this.getBaseDn(), this.getFilterAll(), 2, this.getAttrsId());
        }
        catch (NamingException e) {
            throw new LscServiceException(e);
        }
    }

    public final String getFilterIdClean() {
        return this.filterIdClean;
    }
}

