/*
 * Decompiled with CFR 0.152.
 */
package org.lsc.jndi.parser;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.lsc.jndi.parser.LdapObjectClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapAttributeType {
    private static final int MAX_PASS_BEFORE_FAILING = 100;
    private boolean singleValue = false;
    private boolean noUserModification = false;
    private boolean directoryOperation = false;
    private boolean dSAOperation = false;
    private boolean obsolete;
    private boolean distributedOperation = false;
    private String oid;
    private String name;
    private String usage;
    private String syntax;
    private Map<String, String> x = new HashMap<String, String>();
    private String inheritFrom;
    private String description;
    private String equalityRule;
    private String substringRule;
    private String orderingRule;
    private static final Logger LOGGER = LoggerFactory.getLogger(LdapAttributeType.class);

    public static LdapAttributeType parse(String atStr) {
        int maxPass;
        LdapAttributeType lat = new LdapAttributeType();
        String rest = atStr;
        String[] ret = LdapObjectClass.execRegex(rest, "\\(\\s+([0-9\\.]+)(.*)\\s*\\)\\s*");
        if (ret == null) {
            LOGGER.error("Unable to match the oid in \"{}\"", (Object)atStr);
            return null;
        }
        lat.oid = ret[0];
        rest = ret[1];
        ret = LdapObjectClass.execRegex(rest, "\\s*NAME\\s+(\\([^\\)]+\\)|[^ ]+)(.*)\\s*");
        if (ret != null) {
            if (ret[0].startsWith("(")) {
                ret[0] = ret[0].substring(1, ret[0].length() - 1);
            }
            StringTokenizer names = new StringTokenizer(ret[0], " ");
            lat.setName(names.nextToken());
            if (names.hasMoreElements()) {
                LOGGER.debug("Multiple names not supported. Using first one ({}) for \"{}\"", (Object)lat.name, (Object)atStr);
            }
        } else {
            LOGGER.error("Unable to match the name in \"{}\"", (Object)atStr);
            return null;
        }
        rest = ret[1];
        for (maxPass = 0; rest != null && rest.length() > 0 && maxPass < 100; ++maxPass) {
            LOGGER.debug("Re/Starting analysis with rest=\"{}\"", (Object)rest);
            ret = LdapObjectClass.execRegex(rest, "\\s*SYNTAX\\s+([^\\s]+)\\s*(.*)\\s*");
            if (ret != null) {
                lat.syntax = ret[0];
                rest = ret[1];
            }
            if ((ret = LdapObjectClass.execRegex(rest, "\\s*SUP\\s+([^\\s]+)\\s*(.*)\\s*")) != null) {
                lat.description = ret[0];
                rest = ret[1];
            }
            if ((ret = LdapObjectClass.execRegex(rest, "\\s*DESC\\s+('[^']*')\\s*(.*)\\s*")) != null) {
                lat.description = ret[0];
                rest = ret[1];
            }
            if ((ret = LdapObjectClass.execRegex(rest, "\\s*EQUALITY\\s+([^\\s]+)\\s*(.*)\\s*")) != null) {
                lat.equalityRule = ret[0];
                rest = ret[1];
            }
            if ((ret = LdapObjectClass.execRegex(rest, "\\s*SUBSTR\\s+([^\\s]+)\\s*(.*)\\s*")) != null) {
                lat.substringRule = ret[0];
                rest = ret[1];
            }
            if ((ret = LdapObjectClass.execRegex(rest, "\\s*SUBSTRINGS\\s+([^\\s]+)\\s*(.*)\\s*")) != null) {
                lat.substringRule = ret[0];
                rest = ret[1];
            }
            if ((ret = LdapObjectClass.execRegex(rest, "\\s*ORDERING\\s+([^\\s]+)\\s*(.*)\\s*")) != null) {
                lat.orderingRule = ret[0];
                rest = ret[1];
            }
            if ((ret = LdapObjectClass.execRegex(rest, "\\s*USAGE\\s+([^\\s]+)\\s*(.*)\\s*")) != null) {
                lat.usage = ret[0];
                rest = ret[1];
            }
            if ((ret = LdapObjectClass.execRegex3(rest, "\\s*X-([^\\s]+)\\s+('[^']+')?\\s*(.*)\\s*")) != null) {
                lat.x.put(ret[0], ret[1]);
                rest = ret[2];
            }
            if ((ret = LdapObjectClass.execRegex(rest, "\\s*(SINGLE-VALUE)\\s*(.*)\\s*")) != null) {
                lat.singleValue = true;
                rest = ret[1];
            }
            if ((ret = LdapObjectClass.execRegex(rest, "\\s*(NO-USER-MODIFICATION)\\s*(.*)\\s*")) != null) {
                lat.noUserModification = true;
                rest = ret[1];
            }
            if ((ret = LdapObjectClass.execRegex(rest, "\\s*(directoryOperation)\\s*(.*)\\s*")) != null) {
                lat.directoryOperation = true;
                rest = ret[1];
            }
            if ((ret = LdapObjectClass.execRegex(rest, "\\s*(dSAOperation)\\s*(.*)\\s*")) != null) {
                lat.dSAOperation = true;
                rest = ret[1];
            }
            if ((ret = LdapObjectClass.execRegex(rest, "\\s*(distributedOperation)\\s*(.*)\\s*")) != null) {
                lat.distributedOperation = true;
                rest = ret[1];
            }
            if ((ret = LdapObjectClass.execRegex(rest, "\\s*(OBSOLETE)\\s*(.*)\\s*")) == null) continue;
            lat.obsolete = true;
            rest = ret[1];
        }
        if (maxPass >= 100) {
            LOGGER.error("The parser encountered an error while parsing the following string : {} while parsing {}", (Object)rest, (Object)atStr);
            return null;
        }
        if (lat.inheritFrom == null) {
            LOGGER.debug("No inheritence found for \"{}\"", (Object)atStr);
        }
        if (lat.description == null) {
            LOGGER.debug("No description found for \"{}\"", (Object)atStr);
        }
        if (lat.equalityRule == null) {
            LOGGER.debug("No equality rule found for \"{}\"", (Object)atStr);
        }
        if (lat.substringRule == null) {
            LOGGER.debug("No substring rule found for \"{}\"", (Object)atStr);
        }
        if (lat.orderingRule == null) {
            LOGGER.debug("No ordering rule found for \"{}\"", (Object)atStr);
        }
        if (lat.x.size() == 0) {
            LOGGER.debug("No x rule found for \"{}\"", (Object)atStr);
        }
        return lat;
    }

    public final void setName(String lname) {
        this.name = lname.trim();
        if (this.name.startsWith("'")) {
            this.name = this.name.substring(1, this.name.length() - 1);
        }
    }

    public final boolean isSingleValue() {
        return this.singleValue;
    }

    public final String getName() {
        return this.name;
    }

    public static int getMAX_PASS_BEFORE_FAILING() {
        return 100;
    }

    public boolean isNoUserModification() {
        return this.noUserModification;
    }

    public boolean isDirectoryOperation() {
        return this.directoryOperation;
    }

    public boolean isDSAOperation() {
        return this.dSAOperation;
    }

    public boolean isObsolete() {
        return this.obsolete;
    }

    public boolean isDistributedOperation() {
        return this.distributedOperation;
    }

    public String getOid() {
        return this.oid;
    }

    public String getUsage() {
        return this.usage;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public Map<String, String> getX() {
        return this.x;
    }

    public String getInheritFrom() {
        return this.inheritFrom;
    }

    public String getDescription() {
        return this.description;
    }

    public String getEqualityRule() {
        return this.equalityRule;
    }

    public String getSubstringRule() {
        return this.substringRule;
    }

    public String getOrderingRule() {
        return this.orderingRule;
    }
}

