/*
 * Decompiled with CFR 0.152.
 */
package org.lsc.persistence;

import com.ibatis.common.resources.Resources;
import com.ibatis.sqlmap.client.SqlMapClient;
import com.ibatis.sqlmap.client.SqlMapClientBuilder;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.lsc.Configuration;
import org.lsc.configuration.DatabaseConnectionType;
import org.lsc.exception.LscServiceConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DaoConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(DaoConfig.class);
    public static final String IBATIS_SQLMAP_CONFIGURATION_FILENAME = "sql-map-config.xml";
    public static final String IBATIS_SQLMAP_CONFIGURATION_FILE = "org/lsc/persistence/xml/sql-map-config.xml";
    public static final String IBATIS_SQLMAP_FILES_DIRNAME = "sql-map-config.d";
    private static Map<String, SqlMapClient> sqlMappers = new HashMap<String, SqlMapClient>();

    private DaoConfig() {
    }

    public static SqlMapClient getSqlMapClient(Properties databaseProps) throws LscServiceConfigurationException {
        String mapperKey = new StringBuffer().append(databaseProps.get("username")).append("|").append(databaseProps.get("password")).append("|").append(databaseProps.get("url")).append("|").append(databaseProps.get("driver")).toString();
        SqlMapClient sqlMapper = sqlMappers.get(mapperKey);
        if (sqlMapper == null) {
            try {
                Reader reader = null;
                File configFile = new File(Configuration.getConfigurationDirectory(), IBATIS_SQLMAP_CONFIGURATION_FILENAME);
                if (!configFile.exists()) {
                    throw new LscServiceConfigurationException("Unable to find iBatis SQL map file in " + Configuration.getConfigurationDirectory());
                }
                String pathToFile = configFile.toURI().toURL().toString();
                LOGGER.debug("Reading {} from {}", (Object)IBATIS_SQLMAP_CONFIGURATION_FILENAME, (Object)pathToFile);
                reader = Resources.getUrlAsReader((String)pathToFile);
                databaseProps.put("lsc.config", new File(Configuration.getConfigurationDirectory()).toURI().toURL().getFile());
                try {
                    sqlMapper = SqlMapClientBuilder.buildSqlMapClient((Reader)reader, (Properties)databaseProps);
                }
                catch (RuntimeException re) {
                    throw new LscServiceConfigurationException("Something bad happened while building the SqlMapClient instance." + re, re);
                }
                reader.close();
            }
            catch (IOException e) {
                throw new LscServiceConfigurationException("Something bad happened while building the SqlMapClient instance." + e, e);
            }
            sqlMappers.put(mapperKey, sqlMapper);
        }
        return sqlMapper;
    }

    public static SqlMapClient getSqlMapClient(DatabaseConnectionType connection) throws LscServiceConfigurationException {
        Properties databaseProps = new Properties();
        databaseProps.put("username", connection.getUsername());
        databaseProps.put("password", connection.getPassword());
        databaseProps.put("url", connection.getUrl());
        databaseProps.put("driver", connection.getDriver());
        return DaoConfig.getSqlMapClient(databaseProps);
    }
}

