/*
 * Decompiled with CFR 0.152.
 */
package org.lsc.service;

import com.google.gdata.client.ClientLoginAccountType;
import com.google.gdata.client.GoogleService;
import com.google.gdata.client.Query;
import com.google.gdata.client.appsforyourdomain.AppsForYourDomainQuery;
import com.google.gdata.client.appsforyourdomain.AppsGroupsService;
import com.google.gdata.client.appsforyourdomain.EmailListRecipientService;
import com.google.gdata.client.appsforyourdomain.EmailListService;
import com.google.gdata.client.appsforyourdomain.NicknameService;
import com.google.gdata.client.appsforyourdomain.UserService;
import com.google.gdata.data.Extension;
import com.google.gdata.data.IEntry;
import com.google.gdata.data.ILink;
import com.google.gdata.data.Link;
import com.google.gdata.data.appsforyourdomain.AppsForYourDomainException;
import com.google.gdata.data.appsforyourdomain.Login;
import com.google.gdata.data.appsforyourdomain.Name;
import com.google.gdata.data.appsforyourdomain.Nickname;
import com.google.gdata.data.appsforyourdomain.Quota;
import com.google.gdata.data.appsforyourdomain.provisioning.NicknameEntry;
import com.google.gdata.data.appsforyourdomain.provisioning.NicknameFeed;
import com.google.gdata.data.appsforyourdomain.provisioning.UserEntry;
import com.google.gdata.data.appsforyourdomain.provisioning.UserFeed;
import com.google.gdata.util.AuthenticationException;
import com.google.gdata.util.ServiceException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;
import org.lsc.LscDatasets;
import org.lsc.LscModifications;
import org.lsc.beans.IBean;
import org.lsc.configuration.GoogleAppsConnectionType;
import org.lsc.configuration.GoogleAppsServiceType;
import org.lsc.configuration.TaskType;
import org.lsc.exception.LscServiceConfigurationException;
import org.lsc.exception.LscServiceException;
import org.lsc.service.IWritableService;
import org.lsc.utils.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoogleAppsService
implements IWritableService {
    public static final String DATASET_NAME_ID = "id";
    public static final String DATASET_NAME_MAIL = "mail";
    public static final String DATASET_NAME_LOGIN = "uid";
    public static final String DATASET_NAME_PASSWORD = "userPassword";
    public static final String DATASET_NAME_PASSWORD_HASH = "userPasswordHash";
    public static final String DATASET_NAME_SUSPENDED = "isSuspended";
    public static final String DATASET_NAME_ADMIN = "isAdmin";
    public static final String DATASET_NAME_AGREEDTOTERMS = "isAgreedToTerms";
    public static final String DATASET_NAME_WHITELISTED = "isIpWhitelisted";
    public static final String DATASET_NAME_GIVENNAME = "givenName";
    public static final String DATASET_NAME_SURNAME = "sn";
    public static final String DATASET_NAME_QUOTA = "quotaInMb";
    public static final String DATASET_NAME_CREATETS = "createTimestamp";
    public static final String DATASET_NAME_MODIFYTS = "modifyTimestamp";
    public static final String DATASET_NAME_NICKNAME = "nickname";
    private static final Logger LOGGER = LoggerFactory.getLogger(GoogleAppsService.class);
    private static final String APPS_FEEDS_URL_BASE = "https://apps-apis.google.com/a/feeds/";
    protected static final String SERVICE_VERSION = "2.0";
    protected String domainUrlBase;
    private Map<String, UserEntry> usersCache;
    protected EmailListRecipientService emailListRecipientService;
    protected EmailListService emailListService;
    protected NicknameService nicknameService;
    protected UserService userService;
    protected AppsGroupsService groupService;
    private GoogleAppsConnectionType conn;
    private GoogleAppsServiceType service;
    private Class<IBean> beanClass;

    public GoogleAppsService(TaskType task) throws LscServiceException {
        this.service = task.getGoogleAppsDestinationService() != null ? task.getGoogleAppsDestinationService() : task.getGoogleAppsSourceService();
        this.conn = (GoogleAppsConnectionType)this.service.getConnection().getReference();
        this.domainUrlBase = APPS_FEEDS_URL_BASE + this.conn.getUrl() + "/";
        if (!this.domainUrlBase.startsWith(APPS_FEEDS_URL_BASE)) {
            LOGGER.warn("It seems very strange the your Google Apps provisioning URL doesn't start with: https://apps-apis.google.com/a/feeds/");
        }
        String answer = null;
        try {
            this.userService = new UserService("lsc-project.org-AppsForYourDomain-UserService");
            this.userService.setUserCredentials(this.conn.getUsername(), this.conn.getPassword(), ClientLoginAccountType.HOSTED);
        }
        catch (GoogleService.CaptchaRequiredException e) {
            System.out.println("Please visit " + e.getCaptchaUrl());
            System.out.print("Answer to the challenge? ");
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            try {
                answer = in.readLine();
                this.userService.setUserCredentials(this.conn.getName(), this.conn.getPassword(), e.getCaptchaToken(), answer);
            }
            catch (IOException ioex) {
                throw new LscServiceConfigurationException(ioex);
            }
            catch (AuthenticationException ae) {
                throw new LscServiceConfigurationException((Exception)((Object)ae));
            }
        }
        catch (AuthenticationException e) {
            throw new LscServiceConfigurationException((Exception)((Object)e));
        }
        try {
            this.nicknameService = new NicknameService("lsc-project.org-GoogleApps-NicknameService");
            this.nicknameService.setUserCredentials(this.conn.getUsername(), this.conn.getPassword());
            this.emailListService = new EmailListService("lsc-project.org-GoogleApps-EmailListService");
            this.emailListService.setUserCredentials(this.conn.getUsername(), this.conn.getPassword());
            this.emailListRecipientService = new EmailListRecipientService("lsc-GoogleApps-EmailListRecipientService");
            this.emailListRecipientService.setUserCredentials(this.conn.getUsername(), this.conn.getPassword());
            this.groupService = new AppsGroupsService(this.conn.getUsername(), this.conn.getPassword(), this.conn.getUrl(), "lsc-GoogleApps-AppsGroupService");
            this.beanClass = Class.forName(task.getBean());
        }
        catch (AuthenticationException e) {
            throw new LscServiceConfigurationException((Exception)((Object)e));
        }
        catch (ClassNotFoundException e) {
            throw new LscServiceConfigurationException(e);
        }
    }

    @Override
    public IBean getBean(String pivotName, LscDatasets pivotAttributes, boolean fromSameService) throws LscServiceException {
        try {
            switch (this.service.getApiCategory()) {
                case USER_ACCOUNTS: {
                    return this.convertUserEntryToBean(this.getUsersCache().get(pivotAttributes.getStringValueAttribute(DATASET_NAME_LOGIN) != null ? pivotAttributes.getStringValueAttribute(DATASET_NAME_LOGIN) : pivotName));
                }
            }
            throw new UnsupportedOperationException();
        }
        catch (InstantiationException e) {
            throw new LscServiceException(e);
        }
        catch (IllegalAccessException e) {
            throw new LscServiceException(e);
        }
        catch (AppsForYourDomainException e) {
            throw new LscServiceException((Exception)((Object)e));
        }
        catch (ServiceException e) {
            throw new LscServiceException((Exception)((Object)e));
        }
        catch (IOException e) {
            throw new LscServiceException(e);
        }
    }

    private Map<String, UserEntry> getUsersCache() throws AppsForYourDomainException, ServiceException, IOException {
        if (this.usersCache == null) {
            this.usersCache = new HashMap<String, UserEntry>();
            for (UserEntry userEntry : this.retrieveAllUsers().getEntries()) {
                this.usersCache.put(userEntry.getLogin().getUserName(), userEntry);
            }
        }
        return this.usersCache;
    }

    private IBean convertUserEntryToBean(UserEntry userEntry) throws InstantiationException, IllegalAccessException {
        if (userEntry == null || !userEntry.getCategories().contains(UserEntry.USER_CATEGORY)) {
            return null;
        }
        IBean result = this.beanClass.newInstance();
        result.setMainIdentifier(userEntry.getLogin().getUserName());
        LscDatasets datasets = new LscDatasets();
        datasets.getDatasets().put(DATASET_NAME_ID, userEntry.getId());
        if (userEntry.getEmail() != null) {
            datasets.getDatasets().put(DATASET_NAME_MAIL, userEntry.getEmail().toString());
        }
        datasets.getDatasets().put(DATASET_NAME_LOGIN, userEntry.getLogin().getUserName());
        datasets.getDatasets().put(DATASET_NAME_PASSWORD, userEntry.getLogin().getPassword());
        datasets.getDatasets().put(DATASET_NAME_SUSPENDED, userEntry.getLogin().getSuspended());
        datasets.getDatasets().put(DATASET_NAME_ADMIN, userEntry.getLogin().getAdmin());
        datasets.getDatasets().put(DATASET_NAME_AGREEDTOTERMS, userEntry.getLogin().getAgreedToTerms());
        datasets.getDatasets().put(DATASET_NAME_WHITELISTED, userEntry.getLogin().getIpWhitelisted());
        datasets.getDatasets().put(DATASET_NAME_GIVENNAME, userEntry.getName().getGivenName());
        datasets.getDatasets().put(DATASET_NAME_SURNAME, userEntry.getName().getFamilyName());
        datasets.getDatasets().put(DATASET_NAME_QUOTA, userEntry.getQuota().getLimit());
        if (userEntry.getPublished() != null) {
            datasets.getDatasets().put(DATASET_NAME_CREATETS, DateUtils.format(new Date(userEntry.getPublished().getValue())));
        }
        if (userEntry.getUpdated() != null) {
            datasets.getDatasets().put(DATASET_NAME_MODIFYTS, DateUtils.format(new Date(userEntry.getUpdated().getValue())));
        }
        result.setDatasets(datasets);
        return result;
    }

    @Override
    public Map<String, LscDatasets> getListPivots() throws LscServiceException {
        HashMap<String, LscDatasets> pivots = new HashMap<String, LscDatasets>();
        try {
            switch (this.service.getApiCategory()) {
                case USER_ACCOUNTS: {
                    for (UserEntry userEntry : this.getUsersCache().values()) {
                        pivots.put(userEntry.getLogin().getUserName(), new LscDatasets());
                    }
                    return pivots;
                }
            }
            throw new UnsupportedOperationException();
        }
        catch (IOException e) {
            throw new LscServiceException(e);
        }
        catch (AppsForYourDomainException e) {
            throw new LscServiceException((Exception)((Object)e));
        }
        catch (ServiceException e) {
            throw new LscServiceException((Exception)((Object)e));
        }
    }

    @Override
    public boolean apply(LscModifications lm) throws LscServiceException {
        try {
            block1 : switch (this.service.getApiCategory()) {
                case USER_ACCOUNTS: {
                    switch (lm.getOperation()) {
                        case CREATE_OBJECT: {
                            this.createUser(lm.getMainIdentifier(), this.convertLMToUserEntry(lm, new UserEntry()));
                            break block1;
                        }
                        case UPDATE_OBJECT: 
                        case CHANGE_ID: {
                            this.updateUser(lm.getMainIdentifier(), this.convertLMToUserEntry(lm, this.usersCache.get(lm.getMainIdentifier())));
                            break block1;
                        }
                        case DELETE_OBJECT: {
                            if (System.getenv("I_UNDERSTAND_THAT_GOOGLEAPPS_ACCOUNTS_WILL_BE_DELETED_WITH_THEIR_DATA") != null) {
                                this.deleteUser(lm.getMainIdentifier());
                                break block1;
                            }
                            if (lm.getSourceBean().getDatasetById(DATASET_NAME_NICKNAME) != null) {
                                this.deleteNickname(lm.getSourceBean().getDatasetFirstValueById(DATASET_NAME_NICKNAME));
                            }
                            UserEntry userEntry = this.usersCache.get(lm.getMainIdentifier());
                            userEntry.getLogin().setSuspended(Boolean.valueOf(true));
                            this.updateUser(lm.getMainIdentifier(), userEntry);
                        }
                    }
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }
        catch (IOException e) {
            throw new LscServiceException(e);
        }
        catch (AppsForYourDomainException e) {
            throw new LscServiceException((Exception)((Object)e));
        }
        catch (ServiceException e) {
            throw new LscServiceException((Exception)((Object)e));
        }
        catch (NamingException e) {
            throw new LscServiceException(e);
        }
        return true;
    }

    private UserEntry convertLMToUserEntry(LscModifications lm, UserEntry entry) throws NamingException {
        Login login = new Login();
        boolean loginUpdated = false;
        if (lm.getModificationsItemsByHash().containsKey(DATASET_NAME_LOGIN)) {
            login.setUserName(lm.getModificationsItemsByHash().get(DATASET_NAME_LOGIN).get(0).toString());
            loginUpdated = true;
        }
        if (lm.getModificationsItemsByHash().containsKey(DATASET_NAME_PASSWORD)) {
            login.setPassword(lm.getModificationsItemsByHash().get(DATASET_NAME_PASSWORD).get(0).toString());
            if (lm.getModificationsItemsByHash().containsKey(DATASET_NAME_PASSWORD_HASH)) {
                login.setHashFunctionName(lm.getModificationsItemsByHash().get(DATASET_NAME_PASSWORD_HASH).get(0).toString());
            }
            loginUpdated = true;
        }
        if (loginUpdated) {
            entry.addExtension((Extension)login);
        }
        entry.setCanEdit(false);
        Name name = new Name();
        boolean nameUpdated = false;
        if (lm.getModificationsItemsByHash().containsKey(DATASET_NAME_GIVENNAME)) {
            name.setGivenName(lm.getModificationsItemsByHash().get(DATASET_NAME_GIVENNAME).get(0).toString());
            nameUpdated = true;
        }
        if (lm.getModificationsItemsByHash().containsKey(DATASET_NAME_SURNAME)) {
            name.setFamilyName(lm.getModificationsItemsByHash().get(DATASET_NAME_SURNAME).get(0).toString());
            nameUpdated = true;
        }
        if (nameUpdated) {
            entry.addExtension((Extension)name);
        }
        if (lm.getModificationsItemsByHash().containsKey(DATASET_NAME_QUOTA)) {
            Quota quota = new Quota();
            quota.setLimit(Integer.valueOf(Integer.parseInt(lm.getModificationsItemsByHash().get(DATASET_NAME_QUOTA).get(0).toString())));
            entry.addExtension((Extension)quota);
        }
        return entry;
    }

    @Override
    public List<String> getWriteDatasetIds() {
        ArrayList<String> writableIds = new ArrayList<String>();
        switch (this.service.getApiCategory()) {
            case USER_ACCOUNTS: {
                writableIds.addAll(Arrays.asList(DATASET_NAME_ID, DATASET_NAME_MAIL, DATASET_NAME_LOGIN, DATASET_NAME_PASSWORD, DATASET_NAME_PASSWORD_HASH, DATASET_NAME_SUSPENDED, DATASET_NAME_ADMIN, DATASET_NAME_AGREEDTOTERMS, DATASET_NAME_WHITELISTED, DATASET_NAME_GIVENNAME, DATASET_NAME_SURNAME, DATASET_NAME_QUOTA, DATASET_NAME_CREATETS, DATASET_NAME_MODIFYTS));
                break;
            }
            case GROUPS: {
                throw new UnsupportedOperationException();
            }
            case ORGANIZATION_UNITS: {
                throw new UnsupportedOperationException();
            }
        }
        return writableIds;
    }

    public UserEntry createUser(String username, String givenName, String familyName, String password) throws AppsForYourDomainException, ServiceException, IOException {
        return this.createUser(username, givenName, familyName, password, null, null);
    }

    public UserEntry createUser(String username, String givenName, String familyName, String password, Integer quotaLimitInMb) throws AppsForYourDomainException, ServiceException, IOException {
        return this.createUser(username, givenName, familyName, password, null, quotaLimitInMb);
    }

    public UserEntry createUser(String username, String givenName, String familyName, String password, String passwordHashFunction) throws AppsForYourDomainException, ServiceException, IOException {
        return this.createUser(username, givenName, familyName, password, passwordHashFunction, null);
    }

    public UserEntry createUser(String username, String givenName, String familyName, String password, String passwordHashFunction, Integer quotaLimitInMb) throws AppsForYourDomainException, ServiceException, IOException {
        LOGGER.info("Creating user '" + username + "'. Given Name: '" + givenName + "' Family Name: '" + familyName + (passwordHashFunction != null ? "' Hash Function: '" + passwordHashFunction : "") + (quotaLimitInMb != null ? "' Quota Limit: '" + quotaLimitInMb + "'." : "'."));
        UserEntry entry = new UserEntry();
        Login login = new Login();
        login.setUserName(username);
        login.setPassword(password);
        if (passwordHashFunction != null) {
            login.setHashFunctionName(passwordHashFunction);
        }
        entry.addExtension((Extension)login);
        Name name = new Name();
        name.setGivenName(givenName);
        name.setFamilyName(familyName);
        entry.addExtension((Extension)name);
        if (quotaLimitInMb != null) {
            Quota quota = new Quota();
            quota.setLimit(quotaLimitInMb);
            entry.addExtension((Extension)quota);
        }
        URL insertUrl = new URL(this.domainUrlBase + "user/" + SERVICE_VERSION);
        return (UserEntry)this.userService.insert(insertUrl, (IEntry)entry);
    }

    public UserEntry createUser(String username, UserEntry entry) throws AppsForYourDomainException, IOException, ServiceException {
        URL insertUrl = new URL(this.domainUrlBase + "user/" + SERVICE_VERSION);
        return (UserEntry)this.userService.insert(insertUrl, (IEntry)entry);
    }

    public UserEntry retrieveUser(String username) throws AppsForYourDomainException, ServiceException, IOException {
        LOGGER.info("Retrieving user '" + username + "'.");
        URL retrieveUrl = new URL(this.domainUrlBase + "user/" + SERVICE_VERSION + "/" + username);
        return (UserEntry)this.userService.getEntry(retrieveUrl, UserEntry.class);
    }

    public UserFeed retrieveAllUsers() throws AppsForYourDomainException, ServiceException, IOException {
        Link nextLink;
        LOGGER.info("Retrieving all users.");
        URL retrieveUrl = new URL(this.domainUrlBase + "user/" + SERVICE_VERSION + "/");
        UserFeed allUsers = new UserFeed();
        do {
            UserFeed currentPage = (UserFeed)this.userService.getFeed(retrieveUrl, UserFeed.class);
            allUsers.getEntries().addAll(currentPage.getEntries());
            nextLink = currentPage.getLink("next", ILink.Type.ATOM);
            if (nextLink == null) continue;
            retrieveUrl = new URL(nextLink.getHref());
        } while (nextLink != null);
        return allUsers;
    }

    public UserFeed retrievePageOfUsers(String startUsername) throws AppsForYourDomainException, ServiceException, IOException {
        LOGGER.info("Retrieving one page of users" + (startUsername != null ? " starting at " + startUsername : "") + ".");
        URL retrieveUrl = new URL(this.domainUrlBase + "user/" + SERVICE_VERSION + "/");
        AppsForYourDomainQuery query = new AppsForYourDomainQuery(retrieveUrl);
        query.setStartUsername(startUsername);
        return (UserFeed)this.userService.query((Query)query, UserFeed.class);
    }

    public UserEntry updateUser(String username, UserEntry userEntry) throws AppsForYourDomainException, ServiceException, IOException {
        LOGGER.info("Updating user '" + username + "'.");
        URL updateUrl = new URL(this.domainUrlBase + "user/" + SERVICE_VERSION + "/" + username);
        return (UserEntry)this.userService.update(updateUrl, (IEntry)userEntry);
    }

    public void deleteUser(String username) throws AppsForYourDomainException, ServiceException, IOException {
        LOGGER.info("Deleting user '" + username + "'.");
        URL deleteUrl = new URL(this.domainUrlBase + "user/" + SERVICE_VERSION + "/" + username);
        this.userService.delete(deleteUrl);
    }

    public UserEntry suspendUser(String username) throws AppsForYourDomainException, ServiceException, IOException {
        LOGGER.info("Suspending user '" + username + "'.");
        URL retrieveUrl = new URL(this.domainUrlBase + "user/" + SERVICE_VERSION + "/" + username);
        UserEntry userEntry = (UserEntry)this.userService.getEntry(retrieveUrl, UserEntry.class);
        userEntry.getLogin().setSuspended(Boolean.valueOf(true));
        URL updateUrl = new URL(this.domainUrlBase + "user/" + SERVICE_VERSION + "/" + username);
        return (UserEntry)this.userService.update(updateUrl, (IEntry)userEntry);
    }

    public UserEntry restoreUser(String username) throws AppsForYourDomainException, ServiceException, IOException {
        LOGGER.info("Restoring user '" + username + "'.");
        URL retrieveUrl = new URL(this.domainUrlBase + "user/" + SERVICE_VERSION + "/" + username);
        UserEntry userEntry = (UserEntry)this.userService.getEntry(retrieveUrl, UserEntry.class);
        userEntry.getLogin().setSuspended(Boolean.valueOf(false));
        URL updateUrl = new URL(this.domainUrlBase + "user/" + SERVICE_VERSION + "/" + username);
        return (UserEntry)this.userService.update(updateUrl, (IEntry)userEntry);
    }

    public UserEntry addAdminPrivilege(String username) throws AppsForYourDomainException, ServiceException, IOException {
        LOGGER.info("Setting admin privileges for user '" + username + "'.");
        URL retrieveUrl = new URL(this.domainUrlBase + "user/" + SERVICE_VERSION + "/" + username);
        UserEntry userEntry = (UserEntry)this.userService.getEntry(retrieveUrl, UserEntry.class);
        userEntry.getLogin().setAdmin(Boolean.valueOf(true));
        URL updateUrl = new URL(this.domainUrlBase + "user/" + SERVICE_VERSION + "/" + username);
        return (UserEntry)this.userService.update(updateUrl, (IEntry)userEntry);
    }

    public UserEntry removeAdminPrivilege(String username) throws AppsForYourDomainException, ServiceException, IOException {
        LOGGER.info("Removing admin privileges for user '" + username + "'.");
        URL retrieveUrl = new URL(this.domainUrlBase + "user/" + SERVICE_VERSION + "/" + username);
        UserEntry userEntry = (UserEntry)this.userService.getEntry(retrieveUrl, UserEntry.class);
        userEntry.getLogin().setAdmin(Boolean.valueOf(false));
        URL updateUrl = new URL(this.domainUrlBase + "user/" + SERVICE_VERSION + "/" + username);
        return (UserEntry)this.userService.update(updateUrl, (IEntry)userEntry);
    }

    public UserEntry forceUserToChangePassword(String username) throws AppsForYourDomainException, ServiceException, IOException {
        LOGGER.info("Requiring " + username + " to change password at next login.");
        URL retrieveUrl = new URL(this.domainUrlBase + "user/" + SERVICE_VERSION + "/" + username);
        UserEntry userEntry = (UserEntry)this.userService.getEntry(retrieveUrl, UserEntry.class);
        userEntry.getLogin().setChangePasswordAtNextLogin(Boolean.valueOf(true));
        URL updateUrl = new URL(this.domainUrlBase + "user/" + SERVICE_VERSION + "/" + username);
        return (UserEntry)this.userService.update(updateUrl, (IEntry)userEntry);
    }

    public NicknameEntry createNickname(String username, String nickname) throws AppsForYourDomainException, ServiceException, IOException {
        LOGGER.info("Creating nickname '" + nickname + "' for user '" + username + "'.");
        NicknameEntry entry = new NicknameEntry();
        Nickname nicknameExtension = new Nickname();
        nicknameExtension.setName(nickname);
        entry.addExtension((Extension)nicknameExtension);
        Login login = new Login();
        login.setUserName(username);
        entry.addExtension((Extension)login);
        URL insertUrl = new URL(this.domainUrlBase + "nickname/" + SERVICE_VERSION);
        return (NicknameEntry)this.nicknameService.insert(insertUrl, (IEntry)entry);
    }

    public NicknameEntry retrieveNickname(String nickname) throws AppsForYourDomainException, ServiceException, IOException {
        LOGGER.info("Retrieving nickname '" + nickname + "'.");
        URL retrieveUrl = new URL(this.domainUrlBase + "nickname/" + SERVICE_VERSION + "/" + nickname);
        return (NicknameEntry)this.nicknameService.getEntry(retrieveUrl, NicknameEntry.class);
    }

    public NicknameFeed retrieveNicknames(String username) throws AppsForYourDomainException, ServiceException, IOException {
        LOGGER.info("Retrieving nicknames for user '" + username + "'.");
        URL feedUrl = new URL(this.domainUrlBase + "nickname/" + SERVICE_VERSION);
        AppsForYourDomainQuery query = new AppsForYourDomainQuery(feedUrl);
        query.setUsername(username);
        return (NicknameFeed)this.nicknameService.query((Query)query, NicknameFeed.class);
    }

    public NicknameFeed retrievePageOfNicknames(String startNickname) throws AppsForYourDomainException, ServiceException, IOException {
        LOGGER.info("Retrieving one page of nicknames" + (startNickname != null ? " starting at " + startNickname : "") + ".");
        URL retrieveUrl = new URL(this.domainUrlBase + "nickname/" + SERVICE_VERSION + "/");
        AppsForYourDomainQuery query = new AppsForYourDomainQuery(retrieveUrl);
        query.setStartNickname(startNickname);
        return (NicknameFeed)this.nicknameService.query((Query)query, NicknameFeed.class);
    }

    public NicknameFeed retrieveAllNicknames() throws AppsForYourDomainException, ServiceException, IOException {
        Link nextLink;
        LOGGER.info("Retrieving all nicknames.");
        URL retrieveUrl = new URL(this.domainUrlBase + "nickname/" + SERVICE_VERSION + "/");
        NicknameFeed allNicknames = new NicknameFeed();
        do {
            NicknameFeed currentPage = (NicknameFeed)this.nicknameService.getFeed(retrieveUrl, NicknameFeed.class);
            allNicknames.getEntries().addAll(currentPage.getEntries());
            nextLink = currentPage.getLink("next", ILink.Type.ATOM);
            if (nextLink == null) continue;
            retrieveUrl = new URL(nextLink.getHref());
        } while (nextLink != null);
        return allNicknames;
    }

    public void deleteNickname(String nickname) throws IOException, AppsForYourDomainException, ServiceException {
        LOGGER.info("Deleting nickname '" + nickname + "'.");
        URL deleteUrl = new URL(this.domainUrlBase + "nickname/" + SERVICE_VERSION + "/" + nickname);
        this.nicknameService.delete(deleteUrl);
    }
}

