/*
 * Decompiled with CFR 0.152.
 */
package org.lsc.service;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.lsc.LscDatasets;
import org.lsc.LscModifications;
import org.lsc.beans.IBean;
import org.lsc.configuration.LscConfiguration;
import org.lsc.configuration.ServiceType;
import org.lsc.configuration.TaskType;
import org.lsc.exception.LscServiceConfigurationException;
import org.lsc.exception.LscServiceException;
import org.lsc.service.IWritableService;
import org.lsc.service.IXAWritableService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultipleDstService
implements IWritableService {
    protected static final Logger LOGGER = LoggerFactory.getLogger(MultipleDstService.class);
    private List<IXAWritableService> xaServices = new ArrayList<IXAWritableService>();

    public MultipleDstService(TaskType task) throws LscServiceConfigurationException {
        try {
            for (ServiceType service : task.getMultiDestinationService().getXaServices().getReference()) {
                if (service instanceof ServiceType) {
                    ServiceType wrService = service;
                    Constructor<?> xaServiceConstructor = LscConfiguration.getServiceImplementation(wrService).getConstructor(TaskType.class);
                    IXAWritableService xaService = (IXAWritableService)xaServiceConstructor.newInstance(task);
                    this.xaServices.add(xaService);
                    continue;
                }
                LOGGER.error("Unknown referenced service: " + service.toString());
            }
        }
        catch (InstantiationException e) {
            throw new LscServiceConfigurationException(e);
        }
        catch (SecurityException e) {
            throw new LscServiceConfigurationException(e);
        }
        catch (NoSuchMethodException e) {
            throw new LscServiceConfigurationException(e);
        }
        catch (IllegalArgumentException e) {
            throw new LscServiceConfigurationException(e);
        }
        catch (IllegalAccessException e) {
            throw new LscServiceConfigurationException(e);
        }
        catch (InvocationTargetException e) {
            throw new LscServiceConfigurationException(e);
        }
    }

    @Override
    public IBean getBean(String pivotName, LscDatasets pivotAttributes, boolean fromSameService) throws LscServiceException {
        return this.xaServices.get(0).getBean(pivotName, pivotAttributes, fromSameService);
    }

    @Override
    public Map<String, LscDatasets> getListPivots() throws LscServiceException {
        return this.xaServices.get(0).getListPivots();
    }

    @Override
    public boolean apply(LscModifications lm) throws LscServiceException {
        HashMap<String, String> transactionIds = new HashMap<String, String>();
        try {
            boolean doNotCommit = false;
            for (IXAWritableService iws : this.xaServices) {
                String transactionId = iws.start();
                transactionIds.put(iws.getId(), transactionId);
            }
            for (IXAWritableService iws : this.xaServices) {
                iws.submit((String)transactionIds.get(iws.getId()), lm);
            }
            for (IXAWritableService iws : this.xaServices) {
                iws.end((String)transactionIds.get(iws.getId()));
            }
            for (IXAWritableService iws : this.xaServices) {
                int retCode = iws.prepare((String)transactionIds.get(iws.getId()));
                if (retCode == 0 || retCode == 3) continue;
                doNotCommit = true;
            }
            if (doNotCommit) {
                return false;
            }
            for (IXAWritableService iws : this.xaServices) {
                iws.commit((String)transactionIds.get(iws.getId()));
            }
        }
        catch (LscServiceException lse) {
            for (IXAWritableService iws : this.xaServices) {
                if (transactionIds.get(iws.getId()) == null) continue;
                iws.rollback((String)transactionIds.get(iws.getId()));
            }
            return false;
        }
        return true;
    }

    @Override
    public List<String> getWriteDatasetIds() {
        ArrayList<String> writableDatasetIds = new ArrayList<String>();
        for (IXAWritableService xaService : this.xaServices) {
            writableDatasetIds.addAll(xaService.getWriteDatasetIds());
        }
        return writableDatasetIds;
    }
}

