/*
 * Decompiled with CFR 0.152.
 */
package org.lsc.utils;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;
import org.lsc.utils.CharacterUnacceptedException;
import org.lsc.utils.DateUtils;

public final class FrenchFilters {
    private static final String REGEXP_CHARACTERS = "[\\p{Alpha}\\s'\"\u00e1\u00c1&agrave;&agrave;\u00e2\u00c2\u00e4\u00c4&eacute;&eacute;&egrave;&egrave;\u00ea\u00ca\u00eb\u00cb\u00cc\u00ec\u00cd\u00ed\u00ee\u00ce\u00ef\u00cf\u00d2\u00f2\u00d3\u00f3\u00f4\u00d4\u00f6\u00d6\u00f9\u00d9\u00da\u00fa\u00fb\u00db\u00fc\u00dc\u00dd\u00fd\u00e7-]+";
    private static final String[] REGEXP_ACCENTS_CEDILLAS = new String[]{"\u00c0", "\u00e0", "\u00e1", "\u00c1", "&agrave;", "&agrave;", "\u00e2", "\u00c2", "\u00e4", "\u00c4", "&eacute;", "&eacute;", "&egrave;", "&egrave;", "\u00ea", "\u00ca", "\u00eb", "\u00cb", "\u00c8", "\u00c9", "\u00e9", "\u00e8", "\u00cc", "\u00ec", "\u00cd", "\u00ed", "\u00ee", "\u00ce", "\u00ef", "\u00cf", "\u00d2", "\u00f2", "\u00d3", "\u00f3", "\u00f4", "\u00d4", "\u00f6", "\u00d6", "\u00f9", "\u00d9", "\u00da", "\u00fa", "\u00fb", "\u00db", "\u00fc", "\u00dc", "\u00dd", "\u00fd", "\u00e7", "\u00c7"};
    private static final String[] REGEXP_STRING_ACCENTS_CEDILLAS = new String[]{"A", "a", "a", "A", "a", "A", "a", "A", "a", "A", "e", "E", "e", "E", "e", "E", "e", "E", "E", "E", "e", "e", "I", "i", "I", "i", "i", "I", "i", "I", "O", "o", "O", "o", "o", "O", "o", "O", "u", "U", "U", "u", "u", "U", "u", "U", "Y", "y", "c", "C"};
    private static final String[] SEPARATORS_FOR_UPPER_BEGINNING_NAME = new String[]{" ", "'", "\"", "-", "_"};
    public static final String[] BAD_SEPARATOR_FOR_EMAIL = new String[]{" ", "'", "\""};
    public static final String[] GOOD_SEPARATOR_FOR_EMAIL = new String[]{"_", "_", "_"};
    public static final String[] BAD_SEPARATOR_FOR_PHONE = new String[]{"-", " ", "\\.", "/", "\\+", "\\(", "\\)", ";", ":", "_", ","};
    public static final String[] GOOD_SEPARATOR_FOR_PHONE = new String[]{"", "", "", "", "", "", "", "", "", "", ""};
    private static final String REGEXP_FOR_FISRTNAME = "[\\p{Alpha}\u00e1\u00c1&agrave;&agrave;\u00e2\u00c2\u00e4\u00c4&eacute;&eacute;&egrave;&egrave;\u00ea\u00ca\u00eb\u00cb\u00cc\u00ec\u00cd\u00ed\u00ee\u00ce\u00ef\u00cf\u00d2\u00f2\u00d3\u00f3\u00f4\u00d4\u00f6\u00d6\u00f9\u00d9\u00da\u00fa\u00fb\u00db\u00fc\u00dc\u00dd\u00fd\u00e7' -]+";
    private static final String REGEXP_FOR_LASTNAME = "[\\p{Alpha}\u00e1\u00c1&agrave;&agrave;\u00e2\u00c2\u00e4\u00c4&eacute;&eacute;&egrave;&egrave;\u00ea\u00ca\u00eb\u00cb\u00cc\u00ec\u00cd\u00ed\u00ee\u00ce\u00ef\u00cf\u00d2\u00f2\u00d3\u00f3\u00f4\u00d4\u00f6\u00d6\u00f9\u00d9\u00da\u00fa\u00fb\u00db\u00fc\u00dc\u00dd\u00fd\u00e7'\"\\s -_]+";
    private static final String[] BAD_SEPARATOR_FOR_ID = new String[]{" ", "'", "\"", "-"};
    private static final String GOOD_PASSWORD = "abcdefghijkmnopqrstuvwxyzABCDEFGHJKLMNPQRSTUVWXYZ23456789/";
    private static final String REGEXP_FOR_NUMERICAL_ID = "-?[0123456789]+";
    private static final String REGEXP_FOR_ALPHA_NUMERICAL_ID = "[\\p{Alpha}0123456789]+";

    private FrenchFilters() {
    }

    public static String removeBadChars(String src) {
        return FrenchFilters.filterRegexp(src, REGEXP_ACCENTS_CEDILLAS, REGEXP_STRING_ACCENTS_CEDILLAS);
    }

    public static String filterRegexp(String src, String[] srcRegexp, String[] destRegexp) {
        String dest = src;
        if (srcRegexp.length == destRegexp.length) {
            for (int i = 0; i < srcRegexp.length; ++i) {
                dest = dest.replaceAll(srcRegexp[i], destRegexp[i]);
            }
        }
        return dest;
    }

    public static String filterPhone(String phone2parse) {
        String phoneResult = FrenchFilters.filterRegexp(phone2parse, BAD_SEPARATOR_FOR_PHONE, GOOD_SEPARATOR_FOR_PHONE);
        switch (phoneResult.length()) {
            case 8: {
                return "331" + phoneResult;
            }
            case 10: {
                return "33" + phoneResult.substring(1, phoneResult.length());
            }
        }
        return phoneResult;
    }

    public static String toUpperCaseAllBeginningNames(String string) {
        if (string.length() == 0) {
            return "";
        }
        char[] tmp = string.toLowerCase().toCharArray();
        tmp[0] = Character.toUpperCase(tmp[0]);
        block0: for (int i = 1; i < tmp.length - 1; ++i) {
            char c = tmp[i];
            for (int j = 0; j < SEPARATORS_FOR_UPPER_BEGINNING_NAME.length; ++j) {
                if (c != SEPARATORS_FOR_UPPER_BEGINNING_NAME[j].charAt(0)) continue;
                tmp[i + 1] = Character.toUpperCase(tmp[i + 1]);
                continue block0;
            }
        }
        return new String(tmp);
    }

    public static String filterSn(String sn) throws CharacterUnacceptedException {
        String tmp = FrenchFilters.toUpperCaseAllBeginningNames(FrenchFilters.filterName(sn));
        if (!tmp.matches(REGEXP_FOR_LASTNAME)) {
            throw new CharacterUnacceptedException();
        }
        return tmp;
    }

    private static String filterBadChars(String startString) {
        String tmp = FrenchFilters.filterName(startString);
        for (int i = 0; i < BAD_SEPARATOR_FOR_ID.length; ++i) {
            tmp = tmp.replaceAll(BAD_SEPARATOR_FOR_ID[i], "");
        }
        tmp = FrenchFilters.removeBadChars(tmp);
        return tmp;
    }

    public static String filterLengthString(String sn, int length) {
        String tmp = FrenchFilters.filterBadChars(sn);
        if (tmp.length() > length) {
            return tmp.substring(0, length);
        }
        return tmp;
    }

    public static String filterUid(String sn) {
        return FrenchFilters.filterLengthString(sn, 14);
    }

    public static String filterShortUid(String sn) {
        return FrenchFilters.filterLengthString(sn, 8);
    }

    public static String filterStringRegExp(String value, String regexp) throws CharacterUnacceptedException {
        String tmp = FrenchFilters.toUpperCaseAllBeginningNames(FrenchFilters.filterName(value));
        if (!tmp.matches(regexp)) {
            throw new CharacterUnacceptedException(tmp);
        }
        return tmp;
    }

    public static String filterLastName(String name) throws CharacterUnacceptedException {
        return FrenchFilters.filterStringRegExp(name, REGEXP_CHARACTERS);
    }

    public static String filterGivenName(String oldValue) throws CharacterUnacceptedException {
        return FrenchFilters.filterStringRegExp(oldValue, REGEXP_FOR_FISRTNAME);
    }

    public static String filterAlpha(String value) throws CharacterUnacceptedException {
        String tmp = value.trim();
        if (!tmp.matches(REGEXP_FOR_ALPHA_NUMERICAL_ID)) {
            throw new CharacterUnacceptedException(tmp);
        }
        return tmp;
    }

    public static String generatePwd() {
        StringBuilder passwd = new StringBuilder("");
        Random r = new Random();
        for (int i = 0; i < 8; ++i) {
            passwd.append(GOOD_PASSWORD.charAt(r.nextInt(64)));
        }
        return passwd.toString();
    }

    public static String filterName(String aString) {
        String tmp = aString.trim().replace('.', '-').toLowerCase();
        while (tmp.lastIndexOf(45) == tmp.length() - 1) {
            if (tmp.length() > 1) {
                tmp = tmp.substring(0, tmp.length() - 1);
                continue;
            }
            tmp = "UNKNOWN";
        }
        return tmp;
    }

    public static String filterNumber(String value) throws CharacterUnacceptedException {
        int n = Integer.parseInt(value);
        String tmp = String.valueOf(n);
        if (!tmp.matches(REGEXP_FOR_NUMERICAL_ID)) {
            throw new CharacterUnacceptedException(tmp);
        }
        return tmp;
    }

    public static String filterDate(String value, String format) throws CharacterUnacceptedException {
        SimpleDateFormat myFormat;
        Date myDate;
        String tmp = value.trim();
        if (tmp.length() > 0 && (myDate = (myFormat = new SimpleDateFormat(format)).parse(value, new ParsePosition(0))) != null) {
            return DateUtils.format(myDate);
        }
        throw new CharacterUnacceptedException(tmp);
    }
}

