/*
 * Decompiled with CFR 0.152.
 */
package org.lsc.utils;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import org.lsc.Task;
import org.lsc.exception.LscServiceException;
import org.lsc.utils.GroovyEvaluator;
import org.lsc.utils.JScriptEvaluator;
import org.lsc.utils.RhinoJScriptEvaluator;
import org.lsc.utils.ScriptableEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptingEvaluator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScriptingEvaluator.class);
    private static Cache<Object, Object> instancesCache;
    private static Map<String, Class<? extends ScriptableEvaluator>> implementetionsCache;
    public static ScriptEngineManager mgr;
    private Map<String, ScriptableEvaluator> instancesTypeCache = new HashMap<String, ScriptableEvaluator>();
    private ScriptableEvaluator defaultImplementation;

    private ScriptingEvaluator() {
        List<ScriptEngineFactory> factories = mgr.getEngineFactories();
        for (ScriptEngineFactory sef : factories) {
            boolean loaded = true;
            for (String name : sef.getNames()) {
                if ("js".equals(name)) {
                    this.instancesTypeCache.put(name, new JScriptEvaluator(sef.getScriptEngine()));
                    break;
                }
                if ("groovy".equals(name)) {
                    this.instancesTypeCache.put("gr", new GroovyEvaluator(sef.getScriptEngine()));
                    break;
                }
                loaded = false;
            }
            if (loaded) continue;
            LOGGER.debug("Unsupported scripting engine: " + sef.getEngineName());
        }
        this.instancesTypeCache.put("rjs", new RhinoJScriptEvaluator(false));
        this.instancesTypeCache.put("rdjs", new RhinoJScriptEvaluator(true));
        this.defaultImplementation = this.instancesTypeCache.get("js");
    }

    public static ScriptingEvaluator getInstance() {
        String threadName = Thread.currentThread().getName();
        ScriptingEvaluator scriptingEvaluator = null;
        scriptingEvaluator = (ScriptingEvaluator)instancesCache.getIfPresent((Object)threadName);
        if (scriptingEvaluator == null) {
            scriptingEvaluator = new ScriptingEvaluator();
            instancesCache.put((Object)threadName, (Object)scriptingEvaluator);
        }
        return scriptingEvaluator;
    }

    public static void contribute(String implementationName, Class<? extends ScriptableEvaluator> implementationClass) {
        implementetionsCache.put(implementationName, implementationClass);
    }

    private ScriptableEvaluator identifyScriptingEngine(String expression) {
        String[] parts = expression.split(":");
        if (parts != null && parts.length > 0 && parts[0].length() < 10 && this.instancesTypeCache.containsKey(parts[0])) {
            return this.instancesTypeCache.get(parts[0]);
        }
        return this.defaultImplementation;
    }

    private String removePrefix(String expression) {
        String[] parts = expression.split(":");
        if (parts != null && parts.length > 0 && parts[0].length() < 10 && this.instancesTypeCache.containsKey(parts[0])) {
            return expression.substring(expression.indexOf(":") + 1);
        }
        return expression;
    }

    public static String evalToString(Task task, String expression, Map<String, Object> params) throws LscServiceException {
        ScriptableEvaluator se = ScriptingEvaluator.getInstance().identifyScriptingEngine(expression);
        return se.evalToString(task, ScriptingEvaluator.getInstance().removePrefix(expression), params);
    }

    public static List<String> evalToStringList(Task task, String expression, Map<String, Object> params) throws LscServiceException {
        ScriptableEvaluator se = ScriptingEvaluator.getInstance().identifyScriptingEngine(expression);
        return se.evalToStringList(task, ScriptingEvaluator.getInstance().removePrefix(expression), params);
    }

    public static Boolean evalToBoolean(Task task, String expression, Map<String, Object> params) throws LscServiceException {
        ScriptableEvaluator se = ScriptingEvaluator.getInstance().identifyScriptingEngine(expression);
        return se.evalToBoolean(task, ScriptingEvaluator.getInstance().removePrefix(expression), params);
    }

    static {
        implementetionsCache = new HashMap<String, Class<? extends ScriptableEvaluator>>();
        instancesCache = CacheBuilder.newBuilder().maximumSize(15L).build();
        mgr = new ScriptEngineManager();
    }
}

