/*
 * Decompiled with CFR 0.152.
 */
package org.lsc.utils;

import java.util.ArrayList;
import javax.naming.NamingException;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchResult;
import org.lsc.jndi.JndiModificationType;
import org.lsc.jndi.JndiModifications;
import org.lsc.jndi.JndiServices;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Sequence {
    public static final int INCREMENT_MAX_RETRY = 5;
    private static final Logger LOGGER = LoggerFactory.getLogger(Sequence.class);
    private String dn;
    private String attributeName;
    private int value;
    private JndiServices jndiServices;

    public Sequence(JndiServices jndiServices) {
        this.jndiServices = jndiServices;
    }

    public boolean load(String dn, String attributeName, int serialNumber) {
        if (attributeName == null || dn == null || dn.indexOf(61) == -1) {
            return false;
        }
        this.setAttributeName(attributeName);
        this.setDn(dn);
        return this.readValue();
    }

    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    private void setDn(String value) {
        this.dn = value;
    }

    public int getCurrentValue() {
        return this.value;
    }

    private synchronized void setValue(int value) {
        this.value = value;
    }

    private boolean readValue() {
        try {
            SearchResult sr = this.jndiServices.readEntry(this.getDn(), false);
            if (sr.getAttributes().get(this.getAttributeName()) != null && sr.getAttributes().get(this.getAttributeName()).size() > 0) {
                this.setValue(Integer.parseInt((String)sr.getAttributes().get(this.getAttributeName()).get()));
                return true;
            }
        }
        catch (NamingException e) {
            LOGGER.debug(e.toString(), (Throwable)e);
        }
        LOGGER.error("Failed to get the current value for the sequence {}/{}", (Object)this.getDn(), (Object)this.getAttributeName());
        return false;
    }

    public synchronized int getNextValue() {
        for (int i = 0; i < 5; ++i) {
            int newValue = this.incrementValue();
            if (newValue != -1) {
                return newValue;
            }
            LOGGER.warn("Failed to update the directory for the value of the sequence {}/{}, retrying: " + (i + 1) + "/" + 5, (Object)this.getDn(), (Object)this.getAttributeName());
        }
        LOGGER.error("Maximum retry (5) reached to increment sequence {}/{}", (Object)this.getDn(), (Object)this.getAttributeName());
        return -1;
    }

    private synchronized int incrementValue() {
        int newValue = 0;
        try {
            if (!this.readValue()) {
                return -1;
            }
            int value = this.getCurrentValue();
            newValue = value + 1;
            BasicAttribute valueAttribute = new BasicAttribute(this.getAttributeName());
            valueAttribute.clear();
            valueAttribute.add("" + value);
            BasicAttribute newValueAttribute = new BasicAttribute(this.getAttributeName());
            newValueAttribute.clear();
            newValueAttribute.add("" + newValue);
            JndiModifications jm = new JndiModifications(JndiModificationType.MODIFY_ENTRY);
            jm.setDistinguishName(this.getDn());
            ArrayList<ModificationItem> mi = new ArrayList<ModificationItem>();
            mi.add(new ModificationItem(3, valueAttribute));
            mi.add(new ModificationItem(1, newValueAttribute));
            jm.setModificationItems(mi);
            if (!this.jndiServices.apply(jm)) {
                return -1;
            }
        }
        catch (NamingException e) {
            return -1;
        }
        this.setValue(newValue);
        return newValue;
    }

    public String getDn() {
        return this.dn;
    }
}

