/*
 * Decompiled with CFR 0.152.
 */
package org.lsc.utils.output;

import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.spi.ILoggingEvent;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.naming.InvalidNameException;
import javax.naming.NamingException;
import javax.naming.ldap.LdapName;
import org.apache.commons.codec.binary.Base64;
import org.lsc.LscDatasetModification;
import org.lsc.LscModificationType;
import org.lsc.LscModifications;

public class LdifLayout
extends PatternLayout {
    protected static final String LOG_OPERATIONS_SEPARATOR = ",";
    private String logOperations;
    private boolean onlyLdif = false;
    protected Set<LscModificationType> operations = new HashSet<LscModificationType>();

    public final String doLayout(ILoggingEvent le) {
        Object[] messages = le.getArgumentArray();
        String msg = "";
        if (messages == null || messages.length == 0 || messages[0] == null || !LscModifications.class.isAssignableFrom(messages[0].getClass())) {
            if (!this.onlyLdif) {
                msg = super.doLayout(le);
            }
        } else {
            LscModifications lm = (LscModifications)messages[0];
            if (this.operations.contains((Object)lm.getOperation())) {
                msg = LdifLayout.format(lm);
            }
        }
        return msg;
    }

    public static String format(LscModifications lm) {
        StringBuilder msgBuffer = new StringBuilder();
        LdifLayout.printHeader(msgBuffer);
        String dn = "";
        if (lm.getMainIdentifier() != null && lm.getMainIdentifier().length() > 0) {
            dn = lm.getMainIdentifier();
        }
        msgBuffer.append("dn");
        if (LdifLayout.isLdifSafeString(dn)) {
            msgBuffer.append(": ").append(dn);
        } else {
            msgBuffer.append(":: ").append(LdifLayout.toBase64(dn));
        }
        msgBuffer.append("\n");
        switch (lm.getOperation()) {
            case CREATE_OBJECT: {
                msgBuffer.append("changetype: add\n");
                msgBuffer.append(LdifLayout.listToLdif(lm.getLscAttributeModifications(), true));
                break;
            }
            case CHANGE_ID: {
                try {
                    LdapName ln = new LdapName(lm.getNewMainIdentifier());
                    msgBuffer.append("changetype: modrdn\nnewrdn: ");
                    msgBuffer.append(ln.get(ln.size() - 1));
                    msgBuffer.append("\ndeleteoldrdn: 1\nnewsuperior: ");
                    if (ln.size() > 1) {
                        msgBuffer.append(ln.getPrefix(ln.size() - 1));
                    }
                    msgBuffer.append("\n");
                }
                catch (InvalidNameException e) {
                    msgBuffer.append("changetype: modrdn\nnewrdn: ");
                    msgBuffer.append(lm.getNewMainIdentifier());
                    msgBuffer.append("\ndeleteoldrdn: 1\nnewsuperior: ");
                    msgBuffer.append(lm.getNewMainIdentifier());
                    msgBuffer.append("\n");
                }
                break;
            }
            case UPDATE_OBJECT: {
                msgBuffer.append("changetype: modify\n");
                msgBuffer.append(LdifLayout.listToLdif(lm.getLscAttributeModifications(), false));
                break;
            }
            case DELETE_OBJECT: {
                msgBuffer.append("changetype: delete\n");
                break;
            }
        }
        msgBuffer.append("\n");
        return msgBuffer.toString();
    }

    private static void printHeader(StringBuilder msgBuffer) {
        msgBuffer.append("# ").append(new Date()).append("\n");
    }

    private static String listToLdif(List<LscDatasetModification> modificationItems, boolean addEntry) {
        StringBuilder sb = new StringBuilder();
        for (LscDatasetModification mi : modificationItems) {
            try {
                if (!addEntry) {
                    switch (mi.getOperation()) {
                        case DELETE_VALUES: {
                            sb.append("delete: ").append(mi.getAttributeName()).append("\n");
                            break;
                        }
                        case REPLACE_VALUES: {
                            sb.append("replace: ").append(mi.getAttributeName()).append("\n");
                            break;
                        }
                        default: {
                            sb.append("add: ").append(mi.getAttributeName()).append("\n");
                        }
                    }
                }
                LdifLayout.printAttributeToStringBuffer(sb, mi.getAttributeName(), mi.getValues());
                if (addEntry) continue;
                sb.append("-\n");
            }
            catch (NamingException e) {
                sb.append(mi.getAttributeName()).append(": ").append("!!! Unable to print value !!!\n");
            }
        }
        return sb.toString();
    }

    public static void printAttributeToStringBuffer(StringBuilder sb, String attrName, List<Object> values) throws NamingException {
        String sValue = null;
        for (Object value : values) {
            sb.append(attrName);
            sValue = LdifLayout.getStringValue(value);
            if (LdifLayout.isLdifSafeString(sValue)) {
                if (value instanceof byte[]) {
                    sb.append(": ").append(sValue);
                } else {
                    sb.append(": ").append(value);
                }
            } else if (value instanceof byte[]) {
                sb.append(":: ").append(LdifLayout.toBase64((byte[])value));
            } else {
                sb.append(":: ").append(LdifLayout.toBase64(sValue));
            }
            sb.append("\n");
        }
    }

    private static String getStringValue(Object value) {
        if (value instanceof byte[]) {
            return new String((byte[])value);
        }
        return value.toString();
    }

    public static String toBase64(String value) {
        return new String(new Base64().encode(value.getBytes(Charset.forName("utf-8"))));
    }

    public static String toBase64(byte[] value) {
        return new String(new Base64().encode(value));
    }

    private static boolean isLdifSafeChar(char c) {
        if (c > '\u007f') {
            return false;
        }
        switch (c) {
            case '\u0000': 
            case '\n': 
            case '\r': {
                return false;
            }
        }
        return true;
    }

    private static boolean isLdifSafeInitChar(char c) {
        if (c > '\u007f') {
            return false;
        }
        switch (c) {
            case '\u0000': 
            case '\n': 
            case '\r': 
            case ' ': 
            case ':': 
            case '<': {
                return false;
            }
        }
        return true;
    }

    private static boolean isLdifSafeString(String s) {
        if (s.length() > 0 && !LdifLayout.isLdifSafeInitChar(s.charAt(0))) {
            return false;
        }
        for (int i = 1; i < s.length(); ++i) {
            if (LdifLayout.isLdifSafeChar(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public void start() {
        if (this.logOperations != null) {
            StringTokenizer st = new StringTokenizer(this.logOperations, LOG_OPERATIONS_SEPARATOR);
            String token = null;
            while (st.hasMoreTokens()) {
                token = st.nextToken().toLowerCase();
                LscModificationType op = LscModificationType.getFromDescription(token);
                if (op == null) continue;
                this.operations.add(op);
            }
        } else if (this.operations.isEmpty()) {
            for (LscModificationType type : LscModificationType.values()) {
                this.operations.add(type);
            }
        }
        super.start();
    }

    public void setOnlyLdif(boolean onlyLdif) {
        this.onlyLdif = onlyLdif;
    }

    public void setLogOperations(LscModificationType[] lscModificationTypes) {
        if (lscModificationTypes != null && lscModificationTypes.length > 0) {
            this.operations.addAll(Arrays.asList(lscModificationTypes));
        }
    }

    public void setLogOperations(String logOperations) {
        this.logOperations = logOperations;
    }
}

