/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.extendedRequest;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.asn1.util.Oid;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.ExtendedRequestDecorator;
import org.apache.directory.api.ldap.codec.api.LdapApiServiceFactory;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.model.message.ExtendedRequest;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreExtendedRequestName
extends GrammarAction<LdapMessageContainer<ExtendedRequestDecorator<?>>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreExtendedRequestName.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public StoreExtendedRequestName() {
        super("Store ExtendedRequest Name");
    }

    @Override
    public void action(LdapMessageContainer<ExtendedRequestDecorator<?>> container) throws DecoderException {
        ExtendedRequest req;
        TLV tlv = container.getCurrentTLV();
        if (tlv.getLength() == 0) {
            String msg = I18n.err(I18n.ERR_04095, new Object[0]);
            LOG.error(msg);
            throw new DecoderException(msg);
        }
        byte[] requestNameBytes = tlv.getValue().getData();
        try {
            String requestName = Strings.utf8ToString(requestNameBytes);
            if (!Oid.isOid(requestName)) {
                String msg = "The Request name is not a valid OID : " + Strings.utf8ToString(requestNameBytes) + " (" + Strings.dumpBytes(requestNameBytes) + ") is invalid";
                LOG.error(msg);
                throw new DecoderException(msg);
            }
            req = LdapApiServiceFactory.getSingleton().newExtendedRequest(requestName, null);
            req.setMessageId(container.getMessageId());
            container.setMessage(LdapApiServiceFactory.getSingleton().decorate(req));
        }
        catch (DecoderException de) {
            String msg = "The Request name is not a valid OID : " + Strings.utf8ToString(requestNameBytes) + " (" + Strings.dumpBytes(requestNameBytes) + ") is invalid";
            LOG.error("{} : {}", (Object)msg, (Object)de.getMessage());
            throw de;
        }
        container.setGrammarEndAllowed(true);
        if (IS_DEBUG) {
            LOG.debug("OID read : {}", (Object)req.getRequestName());
        }
    }
}

