/*
 * Decompiled with CFR 0.152.
 */
package org.xadisk.connector;

import java.util.concurrent.ConcurrentHashMap;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.xadisk.bridge.proxies.interfaces.Session;
import org.xadisk.filesystem.NativeXASession;
import org.xadisk.filesystem.SessionCommonness;
import org.xadisk.filesystem.XAFileSystemCommonness;
import org.xadisk.filesystem.XidImpl;
import org.xadisk.filesystem.exceptions.NoTransactionAssociatedException;
import org.xadisk.filesystem.exceptions.XASystemException;

public class XAResourceImpl
implements XAResource {
    private final NativeXASession xaSession;
    private final XAFileSystemCommonness xaFileSystem;
    private final ConcurrentHashMap<Xid, XidImpl> internalXids = new ConcurrentHashMap(1000);
    private volatile int transactionTimeout;

    public XAResourceImpl(NativeXASession xaSession) {
        this.xaSession = xaSession;
        this.xaFileSystem = (XAFileSystemCommonness)xaSession.getUnderlyingXAFileSystem();
        this.transactionTimeout = this.xaFileSystem.getDefaultTransactionTimeout();
    }

    public void start(Xid xid, int flag) throws XAException {
        Session sessionOfTransaction;
        XidImpl internalXid = this.mapToInternalXid(xid);
        if (flag == 0) {
            try {
                Session session = this.xaSession.refreshSessionForNewXATransaction(internalXid);
                session.setTransactionTimeout(this.transactionTimeout);
            }
            catch (XASystemException xase) {
                throw new XAException(-7);
            }
            this.xaSession.setTypeOfCurrentTransaction((byte)2);
        }
        if (flag == 0x200000) {
            sessionOfTransaction = this.xaFileSystem.getSessionForTransaction(internalXid);
            if (sessionOfTransaction == null) {
                throw new XAException(-5);
            }
            this.xaSession.setSessionOfExistingXATransaction(sessionOfTransaction);
            this.xaSession.setTypeOfCurrentTransaction((byte)2);
        }
        if (flag == 0x8000000) {
            sessionOfTransaction = this.xaFileSystem.getSessionForTransaction(internalXid);
            if (sessionOfTransaction == null) {
                throw new XAException(-5);
            }
            this.xaSession.setSessionOfExistingXATransaction(sessionOfTransaction);
            this.xaSession.setTypeOfCurrentTransaction((byte)2);
        }
    }

    public void end(Xid xid, int flag) throws XAException {
        XidImpl internalXid = this.mapToInternalXid(xid);
        Session sessionOfTransaction = this.xaFileSystem.getSessionForTransaction(internalXid);
        if (sessionOfTransaction == null) {
            throw new XAException(-5);
        }
        if (flag == 0x4000000) {
            this.xaSession.setTypeOfCurrentTransaction((byte)0);
        }
        if (flag == 0x20000000) {
            this.xaSession.setTypeOfCurrentTransaction((byte)0);
        }
        if (flag == 0x2000000) {
            this.xaSession.setTypeOfCurrentTransaction((byte)0);
        }
    }

    public int prepare(Xid xid) throws XAException {
        XidImpl internalXid = this.mapToInternalXid(xid);
        Session sessionOfTransaction = this.xaFileSystem.getSessionForTransaction(internalXid);
        if (sessionOfTransaction == null) {
            throw new XAException(-5);
        }
        try {
            if (((SessionCommonness)sessionOfTransaction).isUsingReadOnlyOptimization()) {
                ((SessionCommonness)sessionOfTransaction).completeReadOnlyTransaction();
                return 3;
            }
            ((SessionCommonness)sessionOfTransaction).prepare();
            return 0;
        }
        catch (NoTransactionAssociatedException note) {
            this.releaseFromInternalXidMap(xid);
            throw new XAException(100);
        }
        catch (XASystemException xase) {
            this.releaseFromInternalXidMap(xid);
            throw new XAException(-7);
        }
    }

    public void rollback(Xid xid) throws XAException {
        XidImpl internalXid = this.mapToInternalXid(xid);
        Session sessionOfTransaction = this.xaFileSystem.getSessionForTransaction(internalXid);
        if (sessionOfTransaction == null) {
            throw new XAException(-5);
        }
        try {
            sessionOfTransaction.rollback();
        }
        catch (NoTransactionAssociatedException note) {
            throw new XAException(100);
        }
        catch (XASystemException xase) {
            throw new XAException(-7);
        }
        finally {
            this.releaseFromInternalXidMap(xid);
        }
        this.xaSession.setTypeOfCurrentTransaction((byte)0);
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        XidImpl internalXid = this.mapToInternalXid(xid);
        Session sessionOfTransaction = this.xaFileSystem.getSessionForTransaction(internalXid);
        if (sessionOfTransaction == null) {
            throw new XAException(-5);
        }
        try {
            ((SessionCommonness)sessionOfTransaction).commit(onePhase);
        }
        catch (NoTransactionAssociatedException note) {
            throw new XAException(100);
        }
        catch (XASystemException xase) {
            throw new XAException(-7);
        }
        finally {
            this.releaseFromInternalXidMap(xid);
        }
        this.xaSession.setTypeOfCurrentTransaction((byte)0);
    }

    public Xid[] recover(int flag) throws XAException {
        return this.xaFileSystem.recover(flag);
    }

    public void forget(Xid xid) throws XAException {
    }

    public boolean isSameRM(XAResource xar) throws XAException {
        if (xar instanceof XAResourceImpl) {
            XAResourceImpl that = (XAResourceImpl)xar;
            return this.xaFileSystem.pointToSameXAFileSystem(that.xaFileSystem);
        }
        return false;
    }

    public int getTransactionTimeout() throws XAException {
        return this.transactionTimeout;
    }

    public boolean setTransactionTimeout(int transactionTimeout) throws XAException {
        this.transactionTimeout = transactionTimeout;
        return true;
    }

    private XidImpl mapToInternalXid(Xid xid) {
        XidImpl internalXid = this.internalXids.get(xid);
        if (internalXid == null) {
            internalXid = new XidImpl(xid);
            this.internalXids.put(xid, internalXid);
        }
        return internalXid;
    }

    private void releaseFromInternalXidMap(Xid xid) {
        this.internalXids.remove(xid);
    }
}

