/*
 * Decompiled with CFR 0.152.
 */
package org.xadisk.connector.inbound;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import org.xadisk.filesystem.FileSystemStateChangeEvent;
import org.xadisk.filesystem.NativeXAFileSystem;
import org.xadisk.filesystem.XidImpl;

public class DeadLetterMessageEndpoint {
    private final File deadLetterDir;
    private FileChannel deadLetterChannel;
    private int currentLetterIndex;
    private final NativeXAFileSystem xaFileSystem;

    public DeadLetterMessageEndpoint(File deadLetterDir, NativeXAFileSystem xaFileSystem) throws FileNotFoundException {
        this.xaFileSystem = xaFileSystem;
        this.deadLetterDir = deadLetterDir;
        this.currentLetterIndex = deadLetterDir.listFiles().length;
        this.deadLetterChannel = new FileOutputStream(new File(deadLetterDir, "letter_" + this.currentLetterIndex)).getChannel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpAndCommitMessage(FileSystemStateChangeEvent event, XAResource xar) throws IOException, XAException {
        DeadLetterMessageEndpoint deadLetterMessageEndpoint = this;
        synchronized (deadLetterMessageEndpoint) {
            this.ensureDeadLetterCapacity();
            byte[] content = event.toString().getBytes("UTF8");
            this.deadLetterChannel.write(ByteBuffer.wrap(content));
        }
        xar.commit(XidImpl.getXidInstanceForLocalTransaction(this.xaFileSystem.getNextLocalTransactionId()), true);
    }

    private void ensureDeadLetterCapacity() throws IOException {
        if (this.deadLetterChannel.size() > 10000L) {
            File nextLetter = null;
            for (int i = this.currentLetterIndex + 1; i < Integer.MAX_VALUE; ++i) {
                nextLetter = new File(this.deadLetterDir, "letter_" + i);
                if (nextLetter.exists()) continue;
                this.deadLetterChannel.close();
                this.deadLetterChannel = new FileOutputStream(nextLetter).getChannel();
                this.currentLetterIndex = i;
                break;
            }
            if (nextLetter == null) {
                throw new IOException("No more dead letters can be created...cannot proceed.");
            }
        }
    }

    public void release() {
        try {
            this.deadLetterChannel.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

