/*
 * Decompiled with CFR 0.152.
 */
package org.xadisk.filesystem;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.xadisk.filesystem.utilities.FileIOUtility;

public class DurableDiskSession {
    private Set<File> directoriesToForce = new HashSet<File>();
    private boolean synchronizeDirectoryChanges;

    public DurableDiskSession(boolean synchronizeDirectoryChanges) {
        this.synchronizeDirectoryChanges = synchronizeDirectoryChanges;
    }

    public static boolean setupDirectorySynchronization(File xaDiskHome) throws IOException {
        NATIVE_LIB_NAMES nativeLibraryName;
        boolean success = false;
        NATIVE_LIB_NAMES[] arr$ = NATIVE_LIB_NAMES.values();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && !(success = DurableDiskSession.installAndLoadLibrary((nativeLibraryName = arr$[i$]).name() + ".native", xaDiskHome)); ++i$) {
        }
        if (success) {
            DurableDiskSession.forceDirectoryHierarchy(xaDiskHome);
        }
        return success;
    }

    private static boolean testDirectorySynchronizationSetup() throws IOException {
        try {
            DurableDiskSession.forceDirectories(new String[0]);
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static boolean installAndLoadLibrary(String nativeLibraryName, File xaDiskHome) throws IOException {
        InputStream libInputStream = DurableDiskSession.class.getClassLoader().getResourceAsStream("native/" + nativeLibraryName);
        File nativeLibraryHome = new File(xaDiskHome, "native");
        FileIOUtility.createDirectoriesIfRequired(nativeLibraryHome);
        File copiedNativeLib = new File(nativeLibraryHome, nativeLibraryName);
        if (!copiedNativeLib.exists()) {
            FileIOUtility.copyFile(libInputStream, copiedNativeLib, false);
        }
        try {
            System.load(copiedNativeLib.getAbsolutePath());
        }
        catch (Throwable t) {
            // empty catch block
        }
        return DurableDiskSession.testDirectorySynchronizationSetup();
    }

    private static void forceDirectoryHierarchy(File directory) throws IOException {
        ArrayList<String> allParents = new ArrayList<String>();
        for (File parentDirectory = directory; parentDirectory != null; parentDirectory = parentDirectory.getParentFile()) {
            allParents.add(parentDirectory.getAbsolutePath());
        }
        Collections.reverse(allParents);
        DurableDiskSession.forceDirectories(allParents.toArray(new String[allParents.size()]));
    }

    private static native boolean forceDirectories(String[] var0);

    public static void testNativeLibrary() {
        try {
            for (NATIVE_LIB_NAMES nativeLibraryName : NATIVE_LIB_NAMES.values()) {
                InputStream libInputStream = DurableDiskSession.class.getClassLoader().getResourceAsStream("native/" + (Object)((Object)nativeLibraryName) + ".native");
                File copiedNativeLib = File.createTempFile("xadisk.", ".lib");
                FileIOUtility.copyFile(libInputStream, copiedNativeLib, false);
                try {
                    System.load(copiedNativeLib.getAbsolutePath());
                    if (!DurableDiskSession.forceDirectories(new String[0])) continue;
                    System.out.println("Congrats!! The native lib named [" + (Object)((Object)nativeLibraryName) + "] works on your system.");
                    return;
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            System.out.println("Sorry. None of the available native libs work on your system.");
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void forceToDisk() throws IOException {
        if (!this.synchronizeDirectoryChanges) {
            return;
        }
        String[] paths = new String[this.directoriesToForce.size()];
        int i = 0;
        for (File dir : this.directoriesToForce) {
            paths[i++] = dir.getAbsolutePath();
        }
        if (!DurableDiskSession.forceDirectories(paths)) {
            throw new IOException("Fatal Error: Directory changes could not be forced-to-disk during transaction commit.");
        }
    }

    private void forceToDisk(String directory) throws IOException {
        if (!this.synchronizeDirectoryChanges) {
            return;
        }
        String[] paths = new String[]{directory};
        if (!DurableDiskSession.forceDirectories(paths)) {
            throw new IOException("Fatal Error: Directory changes could not be forced-to-disk during transaction commit.");
        }
    }

    public void renameTo(File src, File dest) throws IOException {
        this.directoriesToForce.add(src.getParentFile());
        this.directoriesToForce.add(dest.getParentFile());
        this.directoriesToForce.remove(src);
        FileIOUtility.renameTo(src, dest);
    }

    public void deleteFile(File f) throws IOException {
        this.directoriesToForce.add(f.getParentFile());
        this.directoriesToForce.remove(f);
        FileIOUtility.deleteFile(f);
    }

    public void deleteFileDurably(File file) throws IOException {
        FileIOUtility.deleteFile(file);
        this.forceToDisk(file.getParentFile().getAbsolutePath());
    }

    public void createFile(File f) throws IOException {
        this.directoriesToForce.add(f.getParentFile());
        FileIOUtility.createFile(f);
    }

    public void createFileDurably(File file) throws IOException {
        FileIOUtility.createFile(file);
        this.forceToDisk(file.getParentFile().getAbsolutePath());
    }

    public void createDirectory(File dir) throws IOException {
        this.directoriesToForce.add(dir.getParentFile());
        FileIOUtility.createDirectory(dir);
    }

    public void createDirectoryDurably(File dir) throws IOException {
        FileIOUtility.createDirectory(dir);
        this.forceToDisk(dir.getParentFile().getAbsolutePath());
    }

    public void deleteDirectoryRecursively(File dir) throws IOException {
        if (!dir.exists()) {
            return;
        }
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                this.deleteDirectoryRecursively(files[i]);
                continue;
            }
            this.deleteFile(files[i]);
        }
        this.deleteEmptyDirectory(dir);
    }

    public void createDirectoriesIfRequired(File dir) throws IOException {
        if (dir.isDirectory()) {
            return;
        }
        this.createDirectoriesIfRequired(dir.getParentFile());
        this.createDirectory(dir);
    }

    private void deleteEmptyDirectory(File dir) throws IOException {
        this.deleteFile(dir);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum NATIVE_LIB_NAMES {
        unix_32_xadisk,
        unix_64_xadisk,
        windows_32_xadisk,
        windows_64_xadisk,
        mac_32_xadisk,
        mac_64_xadisk,
        placeholder_xadisk;

    }
}

