/*
 * Decompiled with CFR 0.152.
 */
package org.xadisk.filesystem;

import java.io.File;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.xadisk.filesystem.XidImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Lock {
    private final File resource;
    private boolean exclusive = false;
    private boolean upgraded = false;
    private int numHolders = 0;
    private final HashSet<XidImpl> holders = new HashSet(10);
    private final ReentrantLock synchLock = new ReentrantLock(false);
    private final Condition mayBeReadable = this.synchLock.newCondition();
    private final Condition mayBeWritable = this.synchLock.newCondition();

    Lock(boolean exclusive, File resource) {
        this.exclusive = exclusive;
        this.resource = resource;
    }

    int getNumHolders() {
        return this.numHolders;
    }

    boolean isExclusive() {
        return this.exclusive;
    }

    void addHolder(XidImpl xid) {
        ++this.numHolders;
        this.holders.add(xid);
    }

    void removeHolder(XidImpl xid) {
        --this.numHolders;
        this.holders.remove(xid);
    }

    public HashSet<XidImpl> getHolders() {
        assert (this.synchLock.isHeldByCurrentThread());
        return this.holders;
    }

    boolean isAHolder(XidImpl xid) {
        return this.holders.contains(xid);
    }

    void reset() {
        this.exclusive = false;
        this.upgraded = false;
        this.numHolders = 0;
        this.holders.clear();
    }

    void setExclusive(boolean exclusive) {
        this.exclusive = exclusive;
    }

    File getResource() {
        return this.resource;
    }

    void markUpgraded() {
        this.upgraded = true;
    }

    boolean isUpgraded() {
        return this.upgraded;
    }

    public void startSynchBlock() {
        this.synchLock.lock();
    }

    public void endSynchBlock() {
        this.synchLock.unlock();
    }

    void waitTillReadable(long time) throws InterruptedException {
        this.mayBeReadable.await(time, TimeUnit.MILLISECONDS);
    }

    void waitTillWritable(long time) throws InterruptedException {
        this.mayBeWritable.await(time, TimeUnit.MILLISECONDS);
    }

    void notifyWritable() {
        this.mayBeWritable.signal();
    }

    void notifyReadWritable() {
        this.mayBeReadable.signalAll();
        this.mayBeWritable.signal();
    }
}

