/*
 * Decompiled with CFR 0.152.
 */
package org.xadisk.filesystem;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkListener;
import javax.resource.spi.work.WorkManager;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.xadisk.bridge.proxies.facilitators.RemoteMethodInvoker;
import org.xadisk.bridge.proxies.impl.RemoteMessageEndpointFactory;
import org.xadisk.bridge.proxies.impl.RemoteXAFileSystem;
import org.xadisk.bridge.proxies.interfaces.XAFileSystem;
import org.xadisk.bridge.proxies.interfaces.XASession;
import org.xadisk.bridge.server.PointOfContact;
import org.xadisk.bridge.server.conversation.GlobalHostedContext;
import org.xadisk.connector.inbound.DeadLetterMessageEndpoint;
import org.xadisk.connector.inbound.EndPointActivation;
import org.xadisk.connector.inbound.LocalEventProcessingXAResource;
import org.xadisk.filesystem.DurableDiskSession;
import org.xadisk.filesystem.FileSystemConfiguration;
import org.xadisk.filesystem.FileSystemStateChangeEvent;
import org.xadisk.filesystem.Lock;
import org.xadisk.filesystem.NativeSession;
import org.xadisk.filesystem.NativeXASession;
import org.xadisk.filesystem.ResourceDependencyGraph;
import org.xadisk.filesystem.XAFileSystemCommonness;
import org.xadisk.filesystem.XidImpl;
import org.xadisk.filesystem.exceptions.AncestorPinnedException;
import org.xadisk.filesystem.exceptions.DeadLockVictimizedException;
import org.xadisk.filesystem.exceptions.DirectoryPinningFailedException;
import org.xadisk.filesystem.exceptions.LockingFailedException;
import org.xadisk.filesystem.exceptions.LockingTimedOutException;
import org.xadisk.filesystem.exceptions.RecoveryInProgressException;
import org.xadisk.filesystem.exceptions.TransactionRolledbackException;
import org.xadisk.filesystem.exceptions.TransactionTimeoutException;
import org.xadisk.filesystem.exceptions.XASystemBootFailureException;
import org.xadisk.filesystem.exceptions.XASystemException;
import org.xadisk.filesystem.exceptions.XASystemNoMoreAvailableException;
import org.xadisk.filesystem.pools.BufferPool;
import org.xadisk.filesystem.pools.SelectorPool;
import org.xadisk.filesystem.standalone.StandaloneFileSystemConfiguration;
import org.xadisk.filesystem.standalone.StandaloneWorkManager;
import org.xadisk.filesystem.utilities.FileIOUtility;
import org.xadisk.filesystem.utilities.Logger;
import org.xadisk.filesystem.workers.CrashRecoveryWorker;
import org.xadisk.filesystem.workers.DeadLockDetector;
import org.xadisk.filesystem.workers.FileSystemEventDelegator;
import org.xadisk.filesystem.workers.GatheringDiskWriter;
import org.xadisk.filesystem.workers.ObjectPoolReliever;
import org.xadisk.filesystem.workers.TransactionTimeoutDetector;
import org.xadisk.filesystem.workers.observers.CriticalWorkersListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NativeXAFileSystem
implements XAFileSystemCommonness {
    private static ConcurrentHashMap<String, NativeXAFileSystem> allXAFileSystems = new ConcurrentHashMap();
    private final AtomicLong lastTransactionId = new AtomicLong(System.currentTimeMillis() / 1000L);
    private final ConcurrentHashMap<File, Lock> fileLocks = new ConcurrentHashMap(1000);
    private final BufferPool bufferPool;
    private final SelectorPool selectorPool;
    private final String transactionLogFileBaseName;
    private Logger logger;
    private final String XADiskHome;
    private final String transactionLogsDir;
    private final DeadLetterMessageEndpoint deadLetter;
    private final FileSystemConfiguration configuration;
    private final ConcurrentHashMap<XidImpl, NativeSession> transactionAndSession = new ConcurrentHashMap(1000);
    private HashSet<XidImpl> transactionsPreparedPreCrash;
    private boolean returnedAllPreparedTransactions = false;
    private final WorkManager workManager;
    private final ResourceDependencyGraph resourceDependencyGraph;
    private final GatheringDiskWriter gatheringDiskWriter;
    private final CrashRecoveryWorker recoveryWorker;
    private final ObjectPoolReliever bufferPoolReliever;
    private final ObjectPoolReliever selectorPoolReliever;
    private final DeadLockDetector deadLockDetector;
    private final FileSystemEventDelegator fileSystemEventDelegator;
    private final TransactionTimeoutDetector transactionTimeoutDetector;
    private final PointOfContact pointOfContact;
    private final int lockTimeOut;
    private boolean recoveryComplete = false;
    private final LinkedBlockingQueue<FileSystemStateChangeEvent> fileSystemEventQueue;
    private volatile boolean systemHasFailed = false;
    private volatile Throwable systemFailureCause = null;
    private final HashMap<File, XidImpl> directoriesPinnedForRename = new HashMap(1000);
    private final CriticalWorkersListener workListener;
    private final File topLevelBackupDir;
    private File currentBackupDirPath;
    private AtomicLong backupFileNameCounter = new AtomicLong(0L);
    private final int maxFilesInBackupDirectory = 100000;
    private final int defaultTransactionTimeout;
    private final GlobalHostedContext globalCallbackContext = new GlobalHostedContext();
    private final AtomicLong totalNonPooledBufferSize = new AtomicLong(0L);

    private NativeXAFileSystem(FileSystemConfiguration configuration, WorkManager workManager) {
        this.configuration = configuration;
        this.workManager = workManager;
        try {
            boolean success;
            this.XADiskHome = configuration.getXaDiskHome();
            FileIOUtility.createDirectoriesIfRequired(new File(this.XADiskHome));
            this.topLevelBackupDir = new File(this.XADiskHome, "backupDir");
            this.logger = new Logger(new File(this.XADiskHome, "xadisk.log"), 3);
            if (configuration.getSynchronizeDirectoryChanges().booleanValue() && !(success = DurableDiskSession.setupDirectorySynchronization(new File(this.XADiskHome)))) {
                this.logger.logWarning("XADisk has failed to load its native library required for directory-synchronization.\nNow, it will override the configuration property \"synchronizeDirectoryChanges\" and set it to false; but please note that this would turn-off directory-synchronization i.e. directory modifications may not get synchronized to the disk at transaction commit.\nIf you have any questions or think this exception is not expected, please consider discussing in XADisk forums, or raising a bug with details.");
                configuration.setSynchronizeDirectoryChanges(false);
            }
            DurableDiskSession diskSession = this.createDurableDiskSession();
            if (!this.topLevelBackupDir.isDirectory()) {
                diskSession.createDirectory(this.topLevelBackupDir);
            }
            this.transactionLogsDir = this.XADiskHome + File.separator + "txnlogs";
            diskSession.createDirectoriesIfRequired(new File(this.transactionLogsDir));
            this.transactionLogFileBaseName = this.transactionLogsDir + File.separator + "xadisk.log";
            this.bufferPool = new BufferPool(configuration.getDirectBufferPoolSize(), configuration.getNonDirectBufferPoolSize(), configuration.getBufferSize(), configuration.getDirectBufferIdleTime(), configuration.getNonDirectBufferIdleTime(), this);
            this.selectorPool = new SelectorPool(1000);
            this.gatheringDiskWriter = new GatheringDiskWriter(configuration.getCumulativeBufferSizeForDiskWrite(), configuration.getTransactionLogFileMaxSize(), configuration.getMaxNonPooledBufferSize(), this.transactionLogFileBaseName, this);
            this.recoveryWorker = new CrashRecoveryWorker(this);
            this.bufferPoolReliever = new ObjectPoolReliever(this.bufferPool, configuration.getBufferPoolRelieverInterval(), this);
            this.selectorPoolReliever = new ObjectPoolReliever(this.selectorPool, 1000, this);
            this.resourceDependencyGraph = new ResourceDependencyGraph();
            this.deadLockDetector = new DeadLockDetector(configuration.getDeadLockDetectorInterval(), this.resourceDependencyGraph, this);
            this.transactionTimeoutDetector = new TransactionTimeoutDetector(1, this);
            this.fileSystemEventQueue = new LinkedBlockingQueue();
            this.fileSystemEventDelegator = new FileSystemEventDelegator(this, configuration.getMaximumConcurrentEventDeliveries());
            this.lockTimeOut = configuration.getLockTimeOut();
            this.defaultTransactionTimeout = configuration.getTransactionTimeout();
            this.workListener = new CriticalWorkersListener(this);
            File deadLetterDir = new File(this.XADiskHome, "deadletter");
            diskSession.createDirectoriesIfRequired(deadLetterDir);
            this.deadLetter = new DeadLetterMessageEndpoint(deadLetterDir, this);
            diskSession.forceToDisk();
            workManager.startWork((Work)this.deadLockDetector, Long.MAX_VALUE, null, (WorkListener)this.workListener);
            workManager.startWork((Work)this.bufferPoolReliever, Long.MAX_VALUE, null, (WorkListener)this.workListener);
            workManager.startWork((Work)this.selectorPoolReliever, Long.MAX_VALUE, null, (WorkListener)this.workListener);
            workManager.startWork((Work)this.fileSystemEventDelegator, Long.MAX_VALUE, null, (WorkListener)this.workListener);
            workManager.startWork((Work)this.transactionTimeoutDetector, Long.MAX_VALUE, null, (WorkListener)this.workListener);
            if (configuration.getEnableRemoteInvocations().booleanValue()) {
                this.pointOfContact = new PointOfContact(this, configuration.getServerPort());
                workManager.startWork((Work)this.pointOfContact, Long.MAX_VALUE, null, (WorkListener)this.workListener);
            } else {
                this.pointOfContact = null;
            }
            this.recoveryWorker.collectRecoveryData();
            this.gatheringDiskWriter.initialize();
            workManager.startWork((Work)this.gatheringDiskWriter, Long.MAX_VALUE, null, (WorkListener)this.workListener);
            workManager.startWork((Work)this.recoveryWorker, Long.MAX_VALUE, null, (WorkListener)this.workListener);
        }
        catch (Exception e) {
            XASystemBootFailureException xasbfe = new XASystemBootFailureException(e);
            if (this.logger != null) {
                this.logger.logThrowable(xasbfe, (byte)1);
            }
            throw xasbfe;
        }
    }

    public static NativeXAFileSystem bootXAFileSystem(FileSystemConfiguration configuration, WorkManager workManager) {
        NativeXAFileSystem.doBasicValidationForConfiguration(configuration);
        String instanceId = configuration.getInstanceId();
        if (allXAFileSystems.get(instanceId) != null) {
            throw new XASystemBootFailureException("An instance of XADisk with instance-id [" + instanceId + "] is already" + " running in this JVM.");
        }
        NativeXAFileSystem newXAFileSystem = new NativeXAFileSystem(configuration, workManager);
        allXAFileSystems.put(configuration.getInstanceId(), newXAFileSystem);
        newXAFileSystem.logger.logInfo("Successfully booted the XADisk instance.");
        return newXAFileSystem;
    }

    public static NativeXAFileSystem bootXAFileSystemStandAlone(StandaloneFileSystemConfiguration configuration) {
        NativeXAFileSystem.doBasicValidationForConfiguration(configuration);
        String instanceId = configuration.getInstanceId();
        if (allXAFileSystems.get(instanceId) != null) {
            throw new XASystemBootFailureException("An instance of XADisk with instance-id [" + instanceId + "] is already" + " running in this JVM.");
        }
        StandaloneWorkManager workManager = new StandaloneWorkManager(configuration.getWorkManagerCorePoolSize(), configuration.getWorkManagerMaxPoolSize(), configuration.getWorkManagerKeepAliveTime());
        NativeXAFileSystem newXAFileSystem = new NativeXAFileSystem(configuration, workManager);
        allXAFileSystems.put(configuration.getInstanceId(), newXAFileSystem);
        newXAFileSystem.logger.logInfo("Successfully booted the XADisk instance.");
        return newXAFileSystem;
    }

    public static NativeXAFileSystem getXAFileSystem(String instanceId) {
        return allXAFileSystems.get(instanceId);
    }

    @Override
    public boolean pointToSameXAFileSystem(XAFileSystem xaFileSystem) {
        if (xaFileSystem instanceof NativeXAFileSystem && !(xaFileSystem instanceof RemoteXAFileSystem)) {
            NativeXAFileSystem that = (NativeXAFileSystem)xaFileSystem;
            return this.configuration.getInstanceId().equals(that.configuration.getInstanceId());
        }
        return false;
    }

    private static void doBasicValidationForConfiguration(FileSystemConfiguration configuration) {
        if (!NativeXAFileSystem.isValidString(configuration.getXaDiskHome())) {
            throw new XASystemBootFailureException("Invalid value of configuration property [xaDiskHome]");
        }
        if (!NativeXAFileSystem.isValidString(configuration.getInstanceId())) {
            throw new XASystemBootFailureException("Invalid value of configuration property [instanceId]");
        }
    }

    private static boolean isValidString(String s) {
        return s != null && s.trim().length() > 0;
    }

    public void notifyRecoveryComplete() throws IOException {
        this.fileSystemEventQueue.addAll(this.recoveryWorker.getEventsEnqueueCommittedNotDequeued());
        DurableDiskSession diskSession = this.createDurableDiskSession();
        diskSession.deleteDirectoryRecursively(this.topLevelBackupDir);
        diskSession.createDirectory(this.topLevelBackupDir);
        this.backupFileNameCounter.set(0L);
        this.currentBackupDirPath = new File(this.topLevelBackupDir.getAbsolutePath(), "deeper");
        diskSession.createDirectory(this.currentBackupDirPath);
        diskSession.forceToDisk();
        this.recoveryComplete = true;
    }

    @Override
    public NativeSession createSessionForLocalTransaction() {
        this.checkIfCanContinue();
        NativeSession session = new NativeSession(XidImpl.getXidInstanceForLocalTransaction(this.getNextLocalTransactionId()), false, this);
        return session;
    }

    @Override
    public NativeSession createSessionForXATransaction(Xid xid) {
        this.checkIfCanContinue();
        NativeSession session = new NativeSession((XidImpl)xid, false, this);
        return session;
    }

    @Override
    public XASession createSessionForXATransaction() {
        this.checkIfCanContinue();
        return new NativeXASession(this, this.configuration.getInstanceId());
    }

    @Override
    public NativeSession getSessionForTransaction(Xid xid) {
        ArrayList<FileSystemStateChangeEvent> events;
        NativeSession session = this.transactionAndSession.get((XidImpl)xid);
        if (session != null) {
            return session;
        }
        if (this.transactionsPreparedPreCrash.contains((XidImpl)xid) && (session = (events = this.recoveryWorker.getEventsFromPreparedTransaction((XidImpl)xid)) != null ? new NativeSession((XidImpl)xid, events, this) : new NativeSession((XidImpl)xid, true, this)) != null) {
            return session;
        }
        return null;
    }

    void removeTransactionSessionEntry(XidImpl xid) {
        this.transactionAndSession.remove(xid);
    }

    void assignSessionToTransaction(XidImpl xid, NativeSession session) {
        this.transactionAndSession.put(xid, session);
    }

    public NativeSession[] getAllSessions() {
        Collection<NativeSession> sessions = this.transactionAndSession.values();
        return sessions.toArray(new NativeSession[sessions.size()]);
    }

    public NativeSession createRecoverySession(XidImpl xid, ArrayList<FileSystemStateChangeEvent> events) {
        if (events == null) {
            return new NativeSession(xid, true, this);
        }
        return new NativeSession(xid, events, this);
    }

    @Override
    public Xid[] recover(int flag) throws XAException {
        if (flag == 0x1000000) {
            this.returnedAllPreparedTransactions = false;
        }
        if (flag == 0x1800000) {
            this.returnedAllPreparedTransactions = false;
        }
        if (this.returnedAllPreparedTransactions) {
            return new Xid[0];
        }
        this.transactionsPreparedPreCrash = this.recoveryWorker.getPreparedInDoubtTransactions();
        Xid[] xids = this.transactionsPreparedPreCrash.toArray(new Xid[this.transactionsPreparedPreCrash.size()]);
        this.returnedAllPreparedTransactions = true;
        return xids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interruptTransactionIfWaitingForResourceLock(XidImpl xid, byte cause) {
        Object object = xid.interruptFlagLock;
        synchronized (object) {
            xid.setInterruptCause(cause);
            ResourceDependencyGraph.Node node = xid.getNodeInResourceDependencyGraph();
            if (node != null && node.isWaitingForResource()) {
                node.getTransactionThread().interrupt();
            }
        }
    }

    Lock acquireFileLock(XidImpl requestor, File f, long time, boolean exclusive) throws LockingFailedException, InterruptedException, TransactionRolledbackException {
        if (exclusive) {
            return this.acquireExclusiveLock(requestor, f, time);
        }
        return this.acquireSharedLock(requestor, f, time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Lock acquireSharedLock(XidImpl requestor, File f, long time) throws LockingFailedException, InterruptedException, TransactionRolledbackException {
        HashMap<File, XidImpl> hashMap;
        Lock lock = this.fileLocks.get(f);
        if (lock == null) {
            hashMap = this.directoriesPinnedForRename;
            synchronized (hashMap) {
                lock = this.fileLocks.get(f);
                if (lock == null) {
                    this.checkIfAnyAncestorPinnedForRename(f, requestor);
                    lock = new Lock(false, f);
                    lock.addHolder(requestor);
                    this.fileLocks.put(f, lock);
                    return lock;
                }
            }
        }
        lock.startSynchBlock();
        if (!lock.isExclusive()) {
            hashMap = this.directoriesPinnedForRename;
            synchronized (hashMap) {
                this.checkIfAnyAncestorPinnedForRename(f, requestor);
                lock.addHolder(requestor);
                Lock lock2 = lock;
                return lock2;
            }
        }
        long remainingTime = time;
        boolean indefiniteWait = time == 0L;
        this.resourceDependencyGraph.addDependency(requestor, lock);
        while (lock.isExclusive()) {
            try {
                long now1 = System.currentTimeMillis();
                lock.waitTillReadable(remainingTime);
                if (lock.isExclusive()) {
                    long now2 = System.currentTimeMillis();
                    if (indefiniteWait || (remainingTime -= now2 - now1) > 0L) continue;
                    this.removeDependencyFromRDG(requestor);
                    throw new LockingTimedOutException(f.getAbsolutePath());
                }
                break;
            }
            catch (InterruptedException ie) {
                this.removeDependencyFromRDG(requestor);
                if (requestor.getInterruptCause() == 1) {
                    DeadLockVictimizedException dlve = new DeadLockVictimizedException(f.getAbsolutePath());
                    requestor.getOwningSession().rollbackPrematurely(dlve);
                    throw new TransactionRolledbackException(dlve);
                }
                if (requestor.getInterruptCause() == 2) {
                    TransactionTimeoutException ttoe = new TransactionTimeoutException();
                    requestor.getOwningSession().rollbackPrematurely(ttoe);
                    throw new TransactionRolledbackException(ttoe);
                }
                throw ie;
            }
        }
        this.removeDependencyFromRDG(requestor);
        HashMap<File, XidImpl> hashMap2 = this.directoriesPinnedForRename;
        synchronized (hashMap2) {
            this.checkIfAnyAncestorPinnedForRename(f, requestor);
            lock.addHolder(requestor);
            Lock lock3 = lock;
            return lock3;
        }
        finally {
            lock.endSynchBlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeDependencyFromRDG(XidImpl requestor) {
        Object object = requestor.interruptFlagLock;
        synchronized (object) {
            this.resourceDependencyGraph.removeDependency(requestor);
            Thread.interrupted();
        }
    }

    private boolean canUpgradeLock(Lock lock, XidImpl requestor) {
        return lock.getNumHolders() == 1 && lock.isAHolder(requestor);
    }

    public static boolean isAncestorOf(File a, File b) {
        for (File parentB = b.getParentFile(); parentB != null; parentB = parentB.getParentFile()) {
            if (!a.equals(parentB)) continue;
            return true;
        }
        return false;
    }

    private void checkIfAnyAncestorPinnedForRename(File f, XidImpl exceptionalSelf) throws AncestorPinnedException {
        for (File parent = f.getParentFile(); parent != null; parent = parent.getParentFile()) {
            XidImpl pinHolder = this.directoriesPinnedForRename.get(parent);
            if (pinHolder == null || pinHolder.equals(exceptionalSelf)) continue;
            throw new AncestorPinnedException(f.getAbsolutePath(), parent.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pinDirectoryForRename(File dir, XidImpl exceptionalSelf) throws DirectoryPinningFailedException {
        HashMap<File, XidImpl> hashMap = this.directoriesPinnedForRename;
        synchronized (hashMap) {
            for (File file : this.fileLocks.keySet()) {
                if (!NativeXAFileSystem.isAncestorOf(dir, file)) continue;
                Lock lock = this.fileLocks.get(file);
                Iterator<XidImpl> holders = lock.getHolders().iterator();
                while (holders.hasNext()) {
                    if (holders.next().equals(exceptionalSelf)) continue;
                    throw new DirectoryPinningFailedException(dir.getAbsolutePath(), file.getAbsolutePath());
                }
            }
            this.directoriesPinnedForRename.put(dir, exceptionalSelf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseRenamePinOnDirectories(Collection<File> dirs) {
        HashMap<File, XidImpl> hashMap = this.directoriesPinnedForRename;
        synchronized (hashMap) {
            for (File dir : dirs) {
                this.directoriesPinnedForRename.remove(dir);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseRenamePinOnDirectory(File dir) {
        HashMap<File, XidImpl> hashMap = this.directoriesPinnedForRename;
        synchronized (hashMap) {
            this.directoriesPinnedForRename.remove(dir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Lock acquireExclusiveLock(XidImpl requestor, File f, long time) throws LockingFailedException, InterruptedException, TransactionRolledbackException {
        HashMap<File, XidImpl> hashMap;
        Lock lock = this.fileLocks.get(f);
        if (lock == null) {
            hashMap = this.directoriesPinnedForRename;
            synchronized (hashMap) {
                lock = this.fileLocks.get(f);
                if (lock == null) {
                    this.checkIfAnyAncestorPinnedForRename(f, requestor);
                    lock = new Lock(true, f);
                    lock.addHolder(requestor);
                    this.fileLocks.put(f, lock);
                    requestor.getOwningSession().incrementNumOwnedExclusiveLocks();
                    return lock;
                }
            }
        }
        lock.startSynchBlock();
        if (this.canUpgradeLock(lock, requestor)) {
            hashMap = this.directoriesPinnedForRename;
            synchronized (hashMap) {
                this.checkIfAnyAncestorPinnedForRename(f, requestor);
                lock.setExclusive(true);
                lock.markUpgraded();
                requestor.getOwningSession().incrementNumOwnedExclusiveLocks();
                Lock lock2 = lock;
                return lock2;
            }
        }
        long remainingTime = time;
        boolean indefiniteWait = time == 0L;
        this.resourceDependencyGraph.addDependency(requestor, lock);
        while (lock.getNumHolders() != 0 && !this.canUpgradeLock(lock, requestor)) {
            try {
                long now1 = System.currentTimeMillis();
                lock.waitTillWritable(remainingTime);
                if (lock.getNumHolders() != 0 && !this.canUpgradeLock(lock, requestor)) {
                    long now2 = System.currentTimeMillis();
                    if (indefiniteWait || (remainingTime -= now2 - now1) > 0L) continue;
                    this.removeDependencyFromRDG(requestor);
                    throw new LockingTimedOutException(f.getAbsolutePath());
                }
                break;
            }
            catch (InterruptedException ie) {
                this.removeDependencyFromRDG(requestor);
                if (requestor.getInterruptCause() == 1) {
                    DeadLockVictimizedException dlve = new DeadLockVictimizedException(f.getAbsolutePath());
                    requestor.getOwningSession().rollbackPrematurely(dlve);
                    throw new TransactionRolledbackException(dlve);
                }
                if (requestor.getInterruptCause() == 2) {
                    TransactionTimeoutException ttoe = new TransactionTimeoutException();
                    requestor.getOwningSession().rollbackPrematurely(ttoe);
                    throw new TransactionRolledbackException(ttoe);
                }
                throw ie;
            }
        }
        this.removeDependencyFromRDG(requestor);
        HashMap<File, XidImpl> hashMap2 = this.directoriesPinnedForRename;
        synchronized (hashMap2) {
            this.checkIfAnyAncestorPinnedForRename(f, requestor);
            lock.setExclusive(true);
            if (this.canUpgradeLock(lock, requestor)) {
                lock.markUpgraded();
            } else {
                lock.addHolder(requestor);
            }
            requestor.getOwningSession().incrementNumOwnedExclusiveLocks();
            Lock lock3 = lock;
            return lock3;
        }
        finally {
            lock.endSynchBlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseLock(XidImpl releasor, Lock lock) {
        try {
            lock.startSynchBlock();
            lock.removeHolder(releasor);
            if (lock.isExclusive()) {
                lock.reset();
                lock.notifyReadWritable();
            } else {
                lock.notifyWritable();
            }
        }
        finally {
            lock.endSynchBlock();
        }
    }

    public BufferPool getBufferPool() {
        return this.bufferPool;
    }

    public SelectorPool getSelectorPool() {
        return this.selectorPool;
    }

    public GlobalHostedContext getGlobalCallbackContext() {
        return this.globalCallbackContext;
    }

    public GatheringDiskWriter getTheGatheringDiskWriter() {
        return this.gatheringDiskWriter;
    }

    public String getTransactionLogFileBaseName() {
        return this.transactionLogFileBaseName;
    }

    public String getTransactionLogsDir() {
        return this.transactionLogsDir;
    }

    public CrashRecoveryWorker getRecoveryWorker() {
        return this.recoveryWorker;
    }

    public int getConfiguredBufferSize() {
        return this.configuration.getBufferSize();
    }

    public WorkManager getWorkManager() {
        return this.workManager;
    }

    public ArrayList<EndPointActivation> getAllActivations() {
        return this.fileSystemEventDelegator.getAllActivations();
    }

    public void startWork(Work work) throws WorkException {
        this.workManager.startWork(work, Long.MAX_VALUE, null, (WorkListener)this.workListener);
    }

    ResourceDependencyGraph getResourceDependencyGraph() {
        return this.resourceDependencyGraph;
    }

    public long getNextLocalTransactionId() {
        return this.lastTransactionId.getAndIncrement();
    }

    Logger getLogger() {
        return this.logger;
    }

    @Override
    public void shutdown() throws IOException {
        this.logger.logInfo("Shutting down the XADisk instance...");
        Collection<NativeSession> sessionsCollection = this.transactionAndSession.values();
        NativeSession[] allSessions = sessionsCollection.toArray(new NativeSession[sessionsCollection.size()]);
        for (int i = 0; i < allSessions.length; ++i) {
            allSessions[i].notifySystemShutdown();
        }
        this.bufferPoolReliever.release();
        this.selectorPoolReliever.release();
        this.deadLockDetector.release();
        this.recoveryWorker.release();
        this.gatheringDiskWriter.release();
        this.gatheringDiskWriter.deInitialize();
        this.fileSystemEventDelegator.release();
        this.transactionTimeoutDetector.release();
        if (this.configuration.getEnableRemoteInvocations().booleanValue()) {
            this.pointOfContact.release();
        }
        this.deadLetter.release();
        if (this.workManager instanceof StandaloneWorkManager) {
            ((StandaloneWorkManager)this.workManager).shutdown();
        }
        allXAFileSystems.remove(this.configuration.getInstanceId());
        this.logger.logInfo("Successfully shutdown the XADisk instance.");
        this.logger.release();
    }

    int getLockTimeOut() {
        return this.lockTimeOut;
    }

    public File getNextBackupFileName() throws IOException {
        File savedCurrentBackupDir = this.currentBackupDirPath;
        long nextBackupFileName = this.backupFileNameCounter.getAndIncrement();
        if (nextBackupFileName >= 100000L) {
            if (nextBackupFileName == 100000L) {
                this.currentBackupDirPath = new File(this.currentBackupDirPath, "deeper");
                this.createDurableDiskSession().createDirectoryDurably(this.currentBackupDirPath);
                this.backupFileNameCounter.set(0L);
            } else {
                while (this.backupFileNameCounter.get() >= 100000L) {
                }
            }
        }
        return new File(savedCurrentBackupDir, nextBackupFileName + "");
    }

    public LinkedBlockingQueue<FileSystemStateChangeEvent> getFileSystemEventQueue() {
        return this.fileSystemEventQueue;
    }

    public final DurableDiskSession createDurableDiskSession() {
        return new DurableDiskSession(this.configuration.getSynchronizeDirectoryChanges());
    }

    @Override
    public void registerEndPointActivation(EndPointActivation activation) throws IOException {
        boolean notADuplicateActivation = this.fileSystemEventDelegator.registerActivation(activation);
        if (notADuplicateActivation && activation.getMessageEndpointFactory() instanceof RemoteMessageEndpointFactory) {
            this.gatheringDiskWriter.recordEndPointActivation(activation);
            ((RemoteMessageEndpointFactory)activation.getMessageEndpointFactory()).setLocalXAFileSystem(this);
        }
    }

    @Override
    public void deRegisterEndPointActivation(EndPointActivation activation) throws IOException {
        this.fileSystemEventDelegator.deRegisterActivation(activation);
        if (activation.getMessageEndpointFactory() instanceof RemoteMessageEndpointFactory) {
            this.gatheringDiskWriter.recordEndPointDeActivation(activation);
        }
    }

    FileSystemEventDelegator getFileSystemEventDelegator() {
        return this.fileSystemEventDelegator;
    }

    public void notifySystemFailure(Throwable systemFailureCause) {
        this.systemHasFailed = true;
        this.systemFailureCause = systemFailureCause;
        Collection<NativeSession> sessionsCollection = this.transactionAndSession.values();
        NativeSession[] allSessions = sessionsCollection.toArray(new NativeSession[sessionsCollection.size()]);
        for (int i = 0; i < allSessions.length; ++i) {
            allSessions[i].notifySystemFailure(systemFailureCause);
        }
        throw new XASystemNoMoreAvailableException(systemFailureCause);
    }

    @Override
    public void notifySystemFailureAndContinue(Throwable systemFailureCause) {
        try {
            this.notifySystemFailure(systemFailureCause);
        }
        catch (XASystemException xASystemException) {
            // empty catch block
        }
    }

    public void checkIfCanContinue() {
        if (this.systemHasFailed) {
            throw new XASystemNoMoreAvailableException(this.systemFailureCause);
        }
        if (!this.recoveryComplete) {
            throw new RecoveryInProgressException();
        }
    }

    @Override
    public void waitForBootup(long timeout) throws InterruptedException {
        block7: {
            if (timeout < 0L) {
                while (true) {
                    try {
                        this.checkIfCanContinue();
                        break block7;
                    }
                    catch (RecoveryInProgressException ripe) {
                        Thread.sleep(1000L);
                        continue;
                    }
                    break;
                }
            }
            for (long timer = timeout; timer > 0L; timer -= 1000L) {
                try {
                    this.checkIfCanContinue();
                    break;
                }
                catch (RecoveryInProgressException ripe) {
                    Thread.sleep(1000L);
                    continue;
                }
            }
            this.checkIfCanContinue();
        }
    }

    @Override
    public int getDefaultTransactionTimeout() {
        return this.defaultTransactionTimeout;
    }

    public String getXADiskSystemId() {
        return this.configuration.getServerAddress() + "_" + this.configuration.getServerPort();
    }

    public RemoteMethodInvoker createRemoteMethodInvokerToSelf() {
        return new RemoteMethodInvoker(this.configuration.getServerAddress(), this.configuration.getServerPort());
    }

    @Override
    public XAResource getEventProcessingXAResourceForRecovery() {
        return new LocalEventProcessingXAResource(this);
    }

    public DeadLetterMessageEndpoint getDeadLetter() {
        return this.deadLetter;
    }

    public void changeTotalNonPooledBufferSize(int changeAmount) {
        this.totalNonPooledBufferSize.addAndGet(changeAmount);
    }

    public long getTotalNonPooledBufferSize() {
        return this.totalNonPooledBufferSize.get();
    }
}

