/*
 * Decompiled with CFR 0.152.
 */
package org.xadisk.filesystem;

import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import org.xadisk.filesystem.Lock;
import org.xadisk.filesystem.XidImpl;

public class ResourceDependencyGraph {
    private final ConcurrentHashMap<XidImpl, Node> nodes = new ConcurrentHashMap(1000);

    ResourceDependencyGraph() {
    }

    void addDependency(XidImpl dependent, Lock resource) {
        Node source = dependent.getNodeInResourceDependencyGraph();
        source.setResourceWaitingFor(resource);
    }

    void removeDependency(XidImpl dependent) {
        Node source = dependent.getNodeInResourceDependencyGraph();
        source.setResourceWaitingFor(null);
    }

    void removeNodeForTransaction(XidImpl xid) {
        this.nodes.remove(xid);
        xid.setNodeInResourceDependencyGraph(null);
    }

    void createNodeForTransaction(XidImpl xid) {
        Node node = new Node(xid, 0, Thread.currentThread());
        this.nodes.put(xid, node);
        xid.setNodeInResourceDependencyGraph(node);
    }

    public Node[] getNodes() {
        return this.nodes.values().toArray(new Node[this.nodes.size()]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Node {
        private final Object id;
        private final ArrayList<Node> neighbors = new ArrayList(10);
        private int mark;
        private int[] prepostVisit = new int[2];
        private Node parent = null;
        private int nextNeighborToProcess = 0;
        private volatile Thread transactionThread;
        private volatile Lock resourceWaitingFor = null;

        private Node(Object id, int defaultMark, Thread transactionThread) {
            this.id = id;
            this.mark = defaultMark;
            this.transactionThread = transactionThread;
        }

        public void reAssociatedTransactionThread(Thread transactionThread) {
            this.transactionThread = transactionThread;
        }

        public void addNeighbor(Node n) {
            this.neighbors.add(n);
        }

        public ArrayList<Node> getNeighbors() {
            return this.neighbors;
        }

        public void setMark(int mark) {
            this.mark = mark;
        }

        public int getMark() {
            return this.mark;
        }

        public void setPreVisit(int preVisit) {
            this.prepostVisit[0] = preVisit;
        }

        public void setPostVisit(int postVisit) {
            this.prepostVisit[1] = postVisit;
        }

        public int[] getPrepostVisit() {
            return this.prepostVisit;
        }

        public Node getParent() {
            return this.parent;
        }

        public void setParent(Node parent) {
            this.parent = parent;
        }

        public Object getId() {
            return this.id;
        }

        public void resetAlgorithmicData() {
            this.mark = 0;
            this.parent = null;
            this.prepostVisit[0] = 0;
            this.prepostVisit[1] = 0;
            this.nextNeighborToProcess = 0;
            this.neighbors.clear();
        }

        public boolean isWaitingForResource() {
            return this.resourceWaitingFor != null;
        }

        public int getNextNeighborToProcess() {
            return this.nextNeighborToProcess;
        }

        public void forwardNextNeighborToProcess() {
            ++this.nextNeighborToProcess;
        }

        Thread getTransactionThread() {
            return this.transactionThread;
        }

        void setResourceWaitingFor(Lock resourceWaitingFor) {
            this.resourceWaitingFor = resourceWaitingFor;
        }

        public Lock getResourceWaitingFor() {
            return this.resourceWaitingFor;
        }
    }
}

