/*
 * Decompiled with CFR 0.152.
 */
package org.xadisk.filesystem.virtual;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.HashMap;
import org.xadisk.filesystem.Buffer;
import org.xadisk.filesystem.DurableDiskSession;
import org.xadisk.filesystem.NativeXAFileSystem;
import org.xadisk.filesystem.OnDiskInfo;
import org.xadisk.filesystem.TransactionLogEntry;
import org.xadisk.filesystem.XidImpl;
import org.xadisk.filesystem.virtual.TransactionVirtualView;

public class VirtualViewFile {
    private File fileName;
    private long length;
    private boolean beingWritten = false;
    private int beingReadBy = 0;
    private long mappedToThePhysicalFileTill = -1L;
    private File mappedToPhysicalFile;
    private final long originalPhysicalFileSize;
    private long smallestTruncationPointInOriginalFile = -1L;
    private boolean usingHeavyWriteOptimization = false;
    private FileChannel fileViewChannel;
    private final ArrayList<Buffer> virtualViewContentBuffers = new ArrayList(10);
    private final NativeXAFileSystem xaFileSystem;
    private final ArrayList<VirtualViewFile> fileCopies = new ArrayList(1);
    private final XidImpl xid;
    private final TransactionVirtualView transactionView;
    private boolean createdPhysicalFileInBackupDir = false;
    private File physicalFileNameInBackupDir = null;
    private boolean hasBeenDeleted = false;
    private final DurableDiskSession diskSession;

    VirtualViewFile(File fileName, long length, TransactionVirtualView transactionView, NativeXAFileSystem xaFileSystem, DurableDiskSession diskSession) {
        this.fileName = fileName;
        this.length = length;
        this.transactionView = transactionView;
        this.xid = this.transactionView.getOwningTransaction();
        this.xaFileSystem = xaFileSystem;
        this.originalPhysicalFileSize = -1L;
        this.diskSession = diskSession;
    }

    VirtualViewFile(File fileName, long length, TransactionVirtualView transactionView, File mappedToPhysical, long mappedToThePhysicalFileTill, NativeXAFileSystem xaFileSystem, DurableDiskSession diskSession) {
        this.fileName = fileName;
        this.length = length;
        this.transactionView = transactionView;
        this.xid = this.transactionView.getOwningTransaction();
        this.xaFileSystem = xaFileSystem;
        this.originalPhysicalFileSize = mappedToThePhysicalFileTill;
        this.mappedToThePhysicalFileTill = mappedToThePhysicalFileTill;
        this.smallestTruncationPointInOriginalFile = mappedToThePhysicalFileTill;
        this.diskSession = diskSession;
    }

    public long getLength() {
        return this.length;
    }

    void setLength(long length) {
        this.length = length;
    }

    public File getFileName() {
        return this.fileName;
    }

    boolean isBeingWritten() {
        return this.beingWritten;
    }

    void setBeingWritten(boolean beingWritten) {
        this.beingWritten = beingWritten;
    }

    boolean isBeingRead() {
        return this.beingReadBy > 0;
    }

    void addBeingRead() {
        ++this.beingReadBy;
    }

    void reduceBeingRead() {
        --this.beingReadBy;
    }

    long getMappedToThePhysicalFileTill() {
        return this.mappedToThePhysicalFileTill;
    }

    void setMappedToThePhysicalFileTill(long mappedToThePhysicalFileTill) {
        this.mappedToThePhysicalFileTill = mappedToThePhysicalFileTill;
    }

    boolean isMappedToAPhysicalFile() {
        return this.mappedToThePhysicalFileTill != -1L;
    }

    File getMappedToPhysicalFile() {
        return this.mappedToPhysicalFile;
    }

    void setMappedToPhysicalFile(File mappedToPhysicalFile) {
        this.mappedToPhysicalFile = mappedToPhysicalFile;
    }

    public boolean isUsingHeavyWriteOptimization() {
        return this.usingHeavyWriteOptimization;
    }

    private void safeSetupForPhysicalFileExistence() throws IOException {
        if (this.fileName.exists()) {
            if (!this.isMappedToAPhysicalFile()) {
                this.physicalFileNameInBackupDir = this.getBackupFileName();
                this.diskSession.createFile(this.physicalFileNameInBackupDir);
                this.createdPhysicalFileInBackupDir = true;
                this.transactionView.hasCreatedFileInBackDir(this);
                this.submitRedoLogForMove(this.physicalFileNameInBackupDir, this.fileName);
            } else {
                this.safePhysicalAppend();
            }
        } else {
            this.physicalFileNameInBackupDir = this.getBackupFileName();
            this.diskSession.createFile(this.physicalFileNameInBackupDir);
            this.createdPhysicalFileInBackupDir = true;
            this.transactionView.hasCreatedFileInBackDir(this);
            this.submitRedoLogForMove(this.physicalFileNameInBackupDir, this.fileName);
        }
    }

    void setUpForHeavyWriteOptimization() throws IOException {
        if (this.usingHeavyWriteOptimization) {
            return;
        }
        this.transactionView.beingUsedInHeavyWriteMode(this);
        this.safeSetupForPhysicalFileExistence();
        this.fileViewChannel = this.createdPhysicalFileInBackupDir ? new RandomAccessFile(this.physicalFileNameInBackupDir, "rw").getChannel() : new RandomAccessFile(this.fileName, "rw").getChannel();
        this.usingHeavyWriteOptimization = true;
        this.safePhysicalTruncate(this.mappedToThePhysicalFileTill);
        HashMap<Integer, FileChannel> logChannels = new HashMap<Integer, FileChannel>(2);
        long positionOfAppending = this.fileViewChannel.size();
        for (Buffer vvCB : this.virtualViewContentBuffers) {
            Buffer srcClone = vvCB.createReadOnlyClone();
            ByteBuffer temp = srcClone.getBuffer();
            if (temp == null) {
                OnDiskInfo onDiskInfo = srcClone.getOnDiskInfo();
                int logIndex = onDiskInfo.getLogIndex();
                FileChannel logFileChannel = (FileChannel)logChannels.get(logIndex);
                if (logFileChannel == null) {
                    logFileChannel = new FileInputStream(this.xaFileSystem.getTransactionLogFileBaseName() + "_" + srcClone.getOnDiskInfo().getLogIndex()).getChannel();
                    logChannels.put(logIndex, logFileChannel);
                }
                logFileChannel.position(onDiskInfo.getLocation() + (long)srcClone.getHeaderLength());
                this.fileViewChannel.transferFrom(logFileChannel, srcClone.getFileContentPosition(), srcClone.getFileContentLength());
            } else {
                temp.position(srcClone.getHeaderLength());
                int sizeToWrite = temp.remaining();
                for (int num = 0; num < sizeToWrite; num += this.fileViewChannel.write(temp)) {
                }
            }
            this.fileViewChannel.position(positionOfAppending += (long)srcClone.getFileContentLength());
        }
        this.virtualViewContentBuffers.clear();
        this.mappedToThePhysicalFileTill = -1L;
    }

    void updatePhysicalContents(Buffer originalContents, long filePosition) {
        if (this.mappedToThePhysicalFileTill > filePosition) {
            this.mappedToThePhysicalFileTill = filePosition;
            this.virtualViewContentBuffers.add(0, originalContents);
        }
    }

    private void safePhysicalAppend() throws IOException {
        if (!this.fileName.exists()) {
            return;
        }
        ByteBuffer logEntryHeader = ByteBuffer.wrap(TransactionLogEntry.getLogEntry(this.xid, this.fileName.getAbsolutePath(), this.originalPhysicalFileSize, (byte)16));
        this.xaFileSystem.getTheGatheringDiskWriter().forceUndoLogAndData(this.xid, logEntryHeader, null, -1L, -1L);
    }

    private void safePhysicalTruncate(long newLength) throws IOException {
        if (!this.usingHeavyWriteOptimization) {
            return;
        }
        if (this.createdPhysicalFileInBackupDir) {
            if (newLength >= 0L) {
                this.fileViewChannel.truncate(newLength);
            }
            return;
        }
        int lengthOfContentToBackUp = (int)(this.smallestTruncationPointInOriginalFile - newLength);
        if (lengthOfContentToBackUp > 0) {
            this.smallestTruncationPointInOriginalFile = newLength;
            ByteBuffer logEntryHeader = ByteBuffer.wrap(TransactionLogEntry.getLogEntry(this.xid, this.fileName.getAbsolutePath(), newLength, lengthOfContentToBackUp, (byte)17));
            long[] logInfo = this.xaFileSystem.getTheGatheringDiskWriter().forceUndoLogAndData(this.xid, logEntryHeader, this.fileViewChannel, newLength, lengthOfContentToBackUp);
            OnDiskInfo truncatedContentsFromLogs = new OnDiskInfo((int)logInfo[0], logInfo[1]);
            Buffer buffer = new Buffer(this.xaFileSystem);
            buffer.setFileContentPosition(newLength);
            buffer.setFileContentLength(lengthOfContentToBackUp);
            buffer.setHeaderLength(logInfo.length);
            buffer.makeOnDisk(truncatedContentsFromLogs);
            for (VirtualViewFile fileCopy : this.fileCopies) {
                fileCopy.updatePhysicalContents(buffer, newLength);
            }
        }
        this.fileViewChannel.truncate(newLength);
    }

    private void takeSnapshotFromPhysicalSource(FileChannel sourceChannel) throws IOException {
        this.safeSetupForPhysicalFileExistence();
        this.fileViewChannel = this.createdPhysicalFileInBackupDir ? new RandomAccessFile(this.physicalFileNameInBackupDir, "rw").getChannel() : new RandomAccessFile(this.fileName, "rw").getChannel();
        this.mappedToThePhysicalFileTill = -1L;
        this.virtualViewContentBuffers.clear();
        long fileLength = sourceChannel.size();
        long sourceOriginalPosition = sourceChannel.position();
        sourceChannel.position(0L);
        for (long n = 0L; n < fileLength; n += this.fileViewChannel.transferFrom(sourceChannel, n, fileLength - n)) {
        }
        sourceChannel.position(sourceOriginalPosition);
        this.fileViewChannel.position(0L);
        this.length = this.fileViewChannel.size();
    }

    public void takeSnapshotInto(VirtualViewFile target) {
        try {
            target.usingHeavyWriteOptimization = this.usingHeavyWriteOptimization;
            if (this.usingHeavyWriteOptimization) {
                target.takeSnapshotFromPhysicalSource(this.fileViewChannel);
                this.transactionView.beingUsedInHeavyWriteMode(target);
            } else {
                if (!this.fileCopies.contains(target)) {
                    this.fileCopies.add(target);
                }
                target.setMappedToPhysicalFile(this.mappedToPhysicalFile);
                target.setMappedToThePhysicalFileTill(this.mappedToThePhysicalFileTill);
                for (Buffer vvCB : this.virtualViewContentBuffers) {
                    target.appendContentBuffer(vvCB);
                }
            }
            target.setLength(this.getLength());
        }
        catch (IOException ioe) {
            this.xaFileSystem.notifySystemFailure(ioe);
        }
    }

    public void truncate(long newLength) {
        if (newLength < 0L || newLength > this.length) {
            throw new IllegalArgumentException("New length should not be negative or more than file size.");
        }
        this.length = newLength;
        if (this.usingHeavyWriteOptimization) {
            try {
                this.safePhysicalTruncate(newLength);
            }
            catch (IOException ioe) {
                this.xaFileSystem.notifySystemFailure(ioe);
            }
            return;
        }
        if (this.mappedToThePhysicalFileTill > newLength) {
            this.mappedToThePhysicalFileTill = newLength;
        }
        boolean needToTruncatePartially = false;
        int removeCompleteBuffersFromIndex = -1;
        for (int i = 0; i < this.virtualViewContentBuffers.size(); ++i) {
            Buffer buffer = this.virtualViewContentBuffers.get(i);
            if (newLength <= buffer.getFileContentPosition()) {
                removeCompleteBuffersFromIndex = i;
                break;
            }
            long fileLengthUptoThisBuffer = buffer.getFileContentPosition() + (long)buffer.getFileContentLength();
            if (newLength >= fileLengthUptoThisBuffer) continue;
            needToTruncatePartially = true;
            removeCompleteBuffersFromIndex = i + 1;
            break;
        }
        if (needToTruncatePartially) {
            Buffer partiallyTruncatedBuffer = this.virtualViewContentBuffers.get(removeCompleteBuffersFromIndex - 1);
            Buffer virtualCopy = partiallyTruncatedBuffer.createReadOnlyClone();
            int effectiveContentLengthInBuffer = (int)(newLength - virtualCopy.getFileContentPosition());
            virtualCopy.setFileContentLength(effectiveContentLengthInBuffer);
            this.virtualViewContentBuffers.set(removeCompleteBuffersFromIndex - 1, virtualCopy);
        }
        if (this.virtualViewContentBuffers.size() > 0) {
            for (int j = this.virtualViewContentBuffers.size() - 1; j >= removeCompleteBuffersFromIndex; --j) {
                this.virtualViewContentBuffers.remove(j);
            }
        }
    }

    int fillUpContentsFromChannel(ByteBuffer buffer, long filePosition) throws IOException {
        long position = this.fileViewChannel.position();
        this.fileViewChannel.position(filePosition);
        int n = this.fileViewChannel.read(buffer);
        this.fileViewChannel.position(position);
        return n;
    }

    Buffer getInMemoryContentBuffer(long position) {
        for (Buffer buffer : this.virtualViewContentBuffers) {
            long beginIndex = buffer.getFileContentPosition();
            long endIndex = beginIndex + (long)buffer.getFileContentLength() - 1L;
            if (beginIndex > position || endIndex < position) continue;
            return buffer;
        }
        return null;
    }

    void appendContentBuffer(Buffer buffer) throws IOException {
        if (this.usingHeavyWriteOptimization) {
            this.fileViewChannel.position(this.length);
            ByteBuffer content = buffer.getBuffer();
            content.position(0);
            for (int num = 0; num < content.limit(); num += this.fileViewChannel.write(content)) {
            }
            this.length = this.fileViewChannel.position();
        } else {
            this.virtualViewContentBuffers.add(buffer);
            this.length += (long)buffer.getFileContentLength();
        }
    }

    private void submitRedoLogForMove(File sourceFile, File destFile) {
        ByteBuffer logEntryHeader = ByteBuffer.wrap(TransactionLogEntry.getLogEntry(this.xid, sourceFile.getAbsolutePath(), destFile.getAbsolutePath(), (byte)9));
        this.xaFileSystem.getTheGatheringDiskWriter().submitBuffer(new Buffer(logEntryHeader, this.xaFileSystem), this.xid);
    }

    public void forceAndFreePhysicalChannel() {
        try {
            if (this.usingHeavyWriteOptimization && !this.hasBeenDeleted) {
                this.fileViewChannel.force(true);
                this.fileViewChannel.close();
            }
        }
        catch (IOException ioe) {
            this.xaFileSystem.notifySystemFailure(ioe);
        }
    }

    public void freePhysicalChannel() {
        try {
            if (this.usingHeavyWriteOptimization && !this.hasBeenDeleted) {
                this.fileViewChannel.close();
            }
        }
        catch (IOException ioe) {
            this.xaFileSystem.notifySystemFailure(ioe);
        }
    }

    public void cleanupBackup() {
        try {
            if (this.createdPhysicalFileInBackupDir) {
                this.fileViewChannel.close();
                this.diskSession.deleteFile(this.physicalFileNameInBackupDir);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void propagatedDeleteCall() {
        if (this.usingHeavyWriteOptimization) {
            try {
                if (this.createdPhysicalFileInBackupDir) {
                    this.submitRedoLogForMove(this.fileName, this.physicalFileNameInBackupDir);
                } else {
                    this.submitRedoLogForMove(this.fileName, this.getBackupFileName());
                }
                this.fileViewChannel.close();
            }
            catch (IOException ioe) {
                this.xaFileSystem.notifySystemFailure(ioe);
            }
            this.hasBeenDeleted = true;
        }
    }

    void propagatedMoveCall(File targetFileName) {
        if (this.usingHeavyWriteOptimization) {
            this.submitRedoLogForMove(this.fileName, targetFileName);
        }
        this.fileName = targetFileName;
    }

    void propagatedAncestorMoveCall(File targetFileName) {
        this.fileName = targetFileName;
    }

    void markDeleted() {
        this.hasBeenDeleted = true;
    }

    private File getBackupFileName() throws IOException {
        File backFile = this.xaFileSystem.getNextBackupFileName();
        return backFile;
    }

    public boolean equals(Object obj) {
        if (obj instanceof VirtualViewFile) {
            VirtualViewFile objVVF = (VirtualViewFile)obj;
            return objVVF.fileName.equals(this.fileName);
        }
        return false;
    }

    public int hashCode() {
        return this.fileName.hashCode();
    }

    protected void finalize() throws Throwable {
        if (this.usingHeavyWriteOptimization) {
            try {
                this.fileViewChannel.close();
            }
            catch (IOException ioe) {
                this.xaFileSystem.notifySystemFailure(ioe);
            }
        }
    }
}

