/*
 * Decompiled with CFR 0.152.
 */
package org.xadisk.filesystem.workers;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicInteger;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkManager;
import org.xadisk.connector.inbound.EndPointActivation;
import org.xadisk.filesystem.FileSystemStateChangeEvent;
import org.xadisk.filesystem.NativeSession;
import org.xadisk.filesystem.NativeXAFileSystem;
import org.xadisk.filesystem.TransactionLogEntry;
import org.xadisk.filesystem.XidImpl;
import org.xadisk.filesystem.exceptions.NoTransactionAssociatedException;
import org.xadisk.filesystem.utilities.FileIOUtility;
import org.xadisk.filesystem.utilities.TransactionLogsUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrashRecoveryWorker
implements Work {
    private final NativeXAFileSystem xaFileSystem;
    private final HashMap<XidImpl, ArrayList<Long>> transactionLogPositions = new HashMap(1000);
    private final HashMap<Integer, FileChannel> logChannels = new HashMap(5);
    private final HashSet<XidImpl> preparedInDoubtTransactions = new HashSet(1000);
    private final HashSet<XidImpl> onePhaseCommittingTransactions = new HashSet(1000);
    private final HashSet<XidImpl> heavyWriteTransactionsForRollback = new HashSet(1000);
    private volatile boolean released = false;
    private volatile boolean logFilesCleaned = false;
    private final HashMap<XidImpl, HashSet<File>> transactionsAndFilesWithLatestViewOnDisk = new HashMap(1000);
    private final ArrayList<XidImpl> committedTransactions = new ArrayList(1000);
    private final HashMap<XidImpl, ArrayList<FileSystemStateChangeEvent>> eventsEnqueuePreparedOnly = new HashMap(1000);
    private final ArrayList<FileSystemStateChangeEvent> eventsEnqueueCommittedNotDequeued = new ArrayList(1000);
    private final ArrayList<FileSystemStateChangeEvent> eventsDequeueCommitted = new ArrayList(1000);
    private final HashMap<XidImpl, FileSystemStateChangeEvent> eventsDequeuePrepared = new HashMap(1000);
    private final HashMap<XidImpl, Integer> transactionsLatestCheckPoint = new HashMap(1000);
    private final ArrayList<EndPointActivation> remoteActivations = new ArrayList();
    private final AtomicInteger distanceFromRecoveryCompletion = new AtomicInteger(0);

    public CrashRecoveryWorker(NativeXAFileSystem xaFileSystem) {
        this.xaFileSystem = xaFileSystem;
    }

    private void collectLogFileNamesToProcess() throws IOException {
        String logsDir = this.xaFileSystem.getTransactionLogsDir();
        String[] logNames = FileIOUtility.listDirectoryContents(new File(logsDir));
        for (int i = 0; i < logNames.length; ++i) {
            int logIndex = Integer.parseInt(logNames[i].split("_")[1]);
            this.logChannels.put(logIndex, new FileInputStream(logsDir + File.separator + logNames[i]).getChannel());
        }
    }

    public void release() {
        this.released = true;
    }

    private void cleanLogFiles() throws IOException {
        for (int logIndex : this.logChannels.keySet()) {
            FileChannel logFC = this.logChannels.get(logIndex);
            logFC.close();
            this.xaFileSystem.createDurableDiskSession().deleteFileDurably(new File(this.xaFileSystem.getTransactionLogFileBaseName() + "_" + logIndex));
        }
    }

    public void collectRecoveryData() throws IOException {
        this.collectLogFileNamesToProcess();
        for (FileChannel logCh : this.logChannels.values()) {
            if (this.released) {
                return;
            }
            this.findInCompleteTransactions(logCh.position(0L));
        }
        for (Integer logIndex : this.logChannels.keySet()) {
            if (this.released) {
                return;
            }
            this.collectTransactionLogPositions(this.logChannels.get(logIndex).position(0L), logIndex);
        }
    }

    public void run() {
        try {
            this.registerRemoteEndpoints();
            this.recoverOnePhaseTransactions();
            this.recoverHeavyWriteTransactionsForRollback();
            this.prepareEventsToPopulate();
            this.distanceFromRecoveryCompletion.set(this.preparedInDoubtTransactions.size() + this.onePhaseCommittingTransactions.size() + this.eventsDequeuePrepared.size() + this.heavyWriteTransactionsForRollback.size());
            this.checkForRecoveryDone();
        }
        catch (Throwable t) {
            this.xaFileSystem.notifySystemFailure(t);
        }
    }

    private void checkForRecoveryDone() throws IOException {
        boolean recoveryDone;
        boolean bl = recoveryDone = this.distanceFromRecoveryCompletion.get() == 0;
        if (recoveryDone && !this.logFilesCleaned && this.distanceFromRecoveryCompletion.compareAndSet(0, -11)) {
            this.xaFileSystem.notifyRecoveryComplete();
            this.cleanLogFiles();
            this.logFilesCleaned = true;
        }
    }

    private void findInCompleteTransactions(FileChannel logFC) throws IOException {
        TransactionLogEntry logEntry = null;
        while (true) {
            try {
                logEntry = TransactionLogEntry.getNextTransactionLogEntry(logFC, logFC.position(), false);
            }
            catch (EOFException eofe) {
                return;
            }
            if (logEntry == null) continue;
            byte operationType = logEntry.getOperationType();
            XidImpl xid = logEntry.getXid();
            switch (operationType) {
                case 12: {
                    this.onePhaseCommittingTransactions.add(xid);
                    this.preparedInDoubtTransactions.remove(xid);
                    this.heavyWriteTransactionsForRollback.remove(xid);
                    this.eventsDequeuePrepared.remove(xid);
                    break;
                }
                case 13: {
                    this.onePhaseCommittingTransactions.remove(xid);
                    this.preparedInDoubtTransactions.remove(xid);
                    this.heavyWriteTransactionsForRollback.remove(xid);
                    this.committedTransactions.add(xid);
                    this.eventsDequeuePrepared.remove(xid);
                    ArrayList<FileSystemStateChangeEvent> events = this.eventsEnqueuePreparedOnly.remove(xid);
                    if (events == null) break;
                    this.eventsEnqueueCommittedNotDequeued.addAll(events);
                    break;
                }
                case 14: {
                    this.onePhaseCommittingTransactions.remove(xid);
                    this.preparedInDoubtTransactions.remove(xid);
                    this.heavyWriteTransactionsForRollback.remove(xid);
                    this.eventsDequeuePrepared.remove(xid);
                    this.eventsEnqueuePreparedOnly.remove(xid);
                    break;
                }
                case 15: {
                    this.preparedInDoubtTransactions.add(xid);
                    this.heavyWriteTransactionsForRollback.remove(xid);
                    break;
                }
                case 18: {
                    this.heavyWriteTransactionsForRollback.add(xid);
                    break;
                }
                case 10: {
                    this.eventsEnqueuePreparedOnly.put(xid, logEntry.getEventList());
                    break;
                }
                case 19: {
                    this.eventsDequeueCommitted.add(logEntry.getEventList().get(0));
                    break;
                }
                case 20: {
                    this.eventsDequeuePrepared.put(xid, logEntry.getEventList().get(0));
                    break;
                }
                case 22: {
                    this.remoteActivations.add(logEntry.getRemoteActivation(this.xaFileSystem));
                    break;
                }
                case 23: {
                    this.remoteActivations.remove(logEntry.getRemoteActivation(this.xaFileSystem));
                }
            }
        }
    }

    private void collectTransactionLogPositions(FileChannel logFC, int logIndex) throws IOException {
        TransactionLogEntry logEntry = null;
        while (true) {
            long filePositionAtBuffersBeginning = logFC.position();
            try {
                logEntry = TransactionLogEntry.getNextTransactionLogEntry(logFC, filePositionAtBuffersBeginning, false);
            }
            catch (EOFException oefe) {
                return;
            }
            XidImpl xid = logEntry.getXid();
            if (this.onePhaseCommittingTransactions.contains(xid) || this.preparedInDoubtTransactions.contains(xid)) {
                if (logEntry.isRedoLogEntry() || logEntry.isUndoLogEntry()) {
                    this.addLogPositionToTransaction(xid, logIndex, filePositionAtBuffersBeginning);
                }
                if (logEntry.getOperationType() == 21) {
                    this.transactionsLatestCheckPoint.put(xid, logEntry.getCheckPointPosition());
                }
                if (logEntry.getOperationType() == 11) {
                    this.transactionsAndFilesWithLatestViewOnDisk.put(xid, logEntry.getFileList());
                }
            }
            if (!this.heavyWriteTransactionsForRollback.contains(xid) || !logEntry.isUndoLogEntry()) continue;
            this.addLogPositionToTransaction(xid, logIndex, filePositionAtBuffersBeginning);
        }
    }

    private void registerRemoteEndpoints() throws IOException {
        for (EndPointActivation activation : this.remoteActivations) {
            this.xaFileSystem.registerEndPointActivation(activation);
        }
    }

    private void recoverOnePhaseTransactions() throws Exception {
        WorkManager workManager = this.xaFileSystem.getWorkManager();
        for (XidImpl xid : this.onePhaseCommittingTransactions) {
            if (this.released) {
                return;
            }
            ArrayList<FileSystemStateChangeEvent> events = this.getEventsFromPreparedTransaction(xid);
            NativeSession recoverySession = this.xaFileSystem.createRecoverySession(xid, events);
            TransactionCompleter commitWork = new TransactionCompleter(recoverySession, true);
            workManager.startWork((Work)commitWork);
        }
    }

    private void recoverHeavyWriteTransactionsForRollback() throws Exception {
        WorkManager workManager = this.xaFileSystem.getWorkManager();
        for (XidImpl xid : this.heavyWriteTransactionsForRollback) {
            if (this.released) {
                return;
            }
            NativeSession recoverySession = this.xaFileSystem.createRecoverySession(xid, null);
            TransactionCompleter rollbackWork = new TransactionCompleter(recoverySession, false);
            workManager.startWork((Work)rollbackWork);
        }
    }

    public ArrayList<FileSystemStateChangeEvent> getEventsFromPreparedTransaction(XidImpl xid) {
        return this.eventsEnqueuePreparedOnly.get(xid);
    }

    private void prepareEventsToPopulate() {
        ArrayList<FileSystemStateChangeEvent> eventsNotToPopulate = new ArrayList<FileSystemStateChangeEvent>();
        eventsNotToPopulate.addAll(this.eventsDequeueCommitted);
        eventsNotToPopulate.addAll(this.eventsDequeuePrepared.values());
        this.eventsEnqueueCommittedNotDequeued.removeAll(eventsNotToPopulate);
    }

    public ArrayList<FileSystemStateChangeEvent> getEventsEnqueueCommittedNotDequeued() {
        return this.eventsEnqueueCommittedNotDequeued;
    }

    public void cleanupTransactionInfo(XidImpl xid) throws IOException {
        this.distanceFromRecoveryCompletion.decrementAndGet();
        this.checkForRecoveryDone();
    }

    private void addLogPositionToTransaction(XidImpl xid, int logFileIndex, long localPosition) {
        TransactionLogsUtility.addLogPositionToTransaction(xid, logFileIndex, localPosition, this.transactionLogPositions);
    }

    public ArrayList<Long> getTransactionLogsPositions(XidImpl xid) {
        ArrayList<Long> logPositions = this.transactionLogPositions.get(xid);
        if (logPositions == null) {
            return new ArrayList<Long>(0);
        }
        return logPositions;
    }

    public int getTransactionsLatestCheckPoint(XidImpl xid) {
        Integer latestCheckPoint = this.transactionsLatestCheckPoint.get(xid);
        return latestCheckPoint == null ? -1 : latestCheckPoint;
    }

    public HashSet<XidImpl> getPreparedInDoubtTransactions() {
        return this.preparedInDoubtTransactions;
    }

    public HashMap<XidImpl, FileSystemStateChangeEvent> getPreparedInDoubtTransactionsOfDequeue() {
        return this.eventsDequeuePrepared;
    }

    public HashSet<File> getFilesOnDiskForTransaction(XidImpl xid) {
        return this.transactionsAndFilesWithLatestViewOnDisk.get(xid);
    }

    private static class TransactionCompleter
    implements Work {
        private NativeSession session;
        private boolean toCommit;

        private TransactionCompleter(NativeSession session, boolean toCommit) {
            this.session = session;
            this.toCommit = toCommit;
        }

        public void release() {
        }

        public void run() {
            try {
                if (this.toCommit) {
                    this.session.commit(true);
                } else {
                    this.session.rollback();
                }
            }
            catch (NoTransactionAssociatedException noTransactionAssociatedException) {
                // empty catch block
            }
        }
    }
}

