/*
 * Decompiled with CFR 0.152.
 */
package org.xadisk.filesystem.workers;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Stack;
import org.xadisk.filesystem.Lock;
import org.xadisk.filesystem.NativeXAFileSystem;
import org.xadisk.filesystem.ResourceDependencyGraph;
import org.xadisk.filesystem.XidImpl;
import org.xadisk.filesystem.workers.TimedWorker;

public class DeadLockDetector
extends TimedWorker {
    private final NativeXAFileSystem xaFileSystem;
    private final ResourceDependencyGraph rdg;
    private ResourceDependencyGraph.Node[] nodes = new ResourceDependencyGraph.Node[0];
    private final ArrayList<ResourceDependencyGraph.Node> backEdges = new ArrayList(10);

    public DeadLockDetector(int frequency, ResourceDependencyGraph rdg, NativeXAFileSystem xaFileSystem) {
        super(frequency);
        this.rdg = rdg;
        this.xaFileSystem = xaFileSystem;
    }

    /*
     * Exception decompiling
     */
    void doWorkOnce() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 4[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void takeSnapShotOfRDG() {
        this.nodes = this.rdg.getNodes();
        for (int i = 0; i < this.nodes.length; ++i) {
            XidImpl[] holders;
            ResourceDependencyGraph.Node node = this.nodes[i];
            Lock resource = node.getResourceWaitingFor();
            if (resource == null) continue;
            try {
                resource.startSynchBlock();
                HashSet<XidImpl> holdersSet = resource.getHolders();
                holders = holdersSet.toArray(new XidImpl[holdersSet.size()]);
            }
            finally {
                resource.endSynchBlock();
            }
            for (int j = 0; j < holders.length; ++j) {
                ResourceDependencyGraph.Node neighbor = holders[j].getNodeInResourceDependencyGraph();
                if (neighbor == null || neighbor == node) continue;
                node.addNeighbor(neighbor);
            }
        }
    }

    private void runDFS() {
        int i;
        int clock = 0;
        Stack<ResourceDependencyGraph.Node> nodesBeingExplored = new Stack<ResourceDependencyGraph.Node>();
        for (i = 0; i < this.nodes.length; ++i) {
            this.nodes[i].setMark(1);
        }
        for (i = 0; i < this.nodes.length; ++i) {
            ResourceDependencyGraph.Node nodeBeingExplored = this.nodes[i];
            if (nodeBeingExplored.getMark() == 2) continue;
            nodesBeingExplored.push(nodeBeingExplored);
            while (!nodesBeingExplored.empty()) {
                nodeBeingExplored = (ResourceDependencyGraph.Node)nodesBeingExplored.peek();
                if (nodeBeingExplored.getMark() != 2) {
                    nodeBeingExplored.setMark(2);
                    nodeBeingExplored.setPreVisit(clock++);
                }
                ArrayList<ResourceDependencyGraph.Node> neighbors = nodeBeingExplored.getNeighbors();
                boolean exploredCompletely = true;
                for (int j = nodeBeingExplored.getNextNeighborToProcess(); j < neighbors.size(); ++j) {
                    nodeBeingExplored.forwardNextNeighborToProcess();
                    ResourceDependencyGraph.Node nextToExplore = neighbors.get(j);
                    if (nextToExplore.getMark() != 2) {
                        nodesBeingExplored.push(nextToExplore);
                        nextToExplore.setParent(nodeBeingExplored);
                        exploredCompletely = false;
                        break;
                    }
                    this.detectBackEdge(nodeBeingExplored, nextToExplore);
                }
                if (!exploredCompletely) continue;
                nodesBeingExplored.pop();
                nodeBeingExplored.setPostVisit(clock++);
            }
        }
    }

    private void detectBackEdge(ResourceDependencyGraph.Node source, ResourceDependencyGraph.Node target) {
        if (target.getPrepostVisit()[0] < source.getPrepostVisit()[0] && target.getPrepostVisit()[1] == 0) {
            this.backEdges.add(source);
            this.backEdges.add(target);
            return;
        }
    }

    private void breakCycles() {
        for (int i = 0; i < this.backEdges.size() - 1; i += 2) {
            ResourceDependencyGraph.Node target = this.backEdges.get(i + 1);
            ResourceDependencyGraph.Node victim = null;
            int minimumLocks = -1;
            for (ResourceDependencyGraph.Node source = this.backEdges.get(i); source != target && source.isWaitingForResource(); source = source.getParent()) {
                int currentLocksCount = ((XidImpl)source.getId()).getOwningSession().getNumOwnedExclusiveLocks();
                if (minimumLocks == -1) {
                    victim = source;
                    minimumLocks = currentLocksCount;
                    continue;
                }
                if (currentLocksCount >= minimumLocks) continue;
                minimumLocks = currentLocksCount;
                victim = source;
            }
            if (victim == null || !victim.isWaitingForResource()) continue;
            XidImpl victimXid = (XidImpl)victim.getId();
            this.xaFileSystem.interruptTransactionIfWaitingForResourceLock(victimXid, (byte)1);
        }
    }

    private void cleanup() {
        for (int i = 0; i < this.nodes.length; ++i) {
            this.nodes[i].resetAlgorithmicData();
        }
        this.backEdges.clear();
    }
}

