/*
 * Decompiled with CFR 0.152.
 */
package org.xadisk.filesystem.workers;

import org.xadisk.filesystem.NativeSession;
import org.xadisk.filesystem.NativeXAFileSystem;
import org.xadisk.filesystem.exceptions.TransactionTimeoutException;
import org.xadisk.filesystem.workers.TimedWorker;

public class TransactionTimeoutDetector
extends TimedWorker {
    private final NativeXAFileSystem xaFileSystem;

    public TransactionTimeoutDetector(int frequency, NativeXAFileSystem xaFileSystem) {
        super(frequency);
        this.xaFileSystem = xaFileSystem;
    }

    void doWorkOnce() {
        try {
            NativeSession[] sessions = this.xaFileSystem.getAllSessions();
            for (int i = 0; i < sessions.length; ++i) {
                NativeSession session = sessions[i];
                int timeoutValue = session.getTransactionTimeout();
                int birthTime = (int)(session.getTimeOfEntryToTransaction() / 1000L);
                int timeNow = (int)(System.currentTimeMillis() / 1000L);
                if (timeoutValue <= 0 || timeNow - birthTime <= timeoutValue) continue;
                this.xaFileSystem.interruptTransactionIfWaitingForResourceLock(session.getXid(), (byte)2);
                session.rollbackAsynchronously(new TransactionTimeoutException());
            }
        }
        catch (Throwable t) {
            this.xaFileSystem.notifySystemFailure(t);
        }
    }
}

