/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.browser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.naming.NamingException;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.net.ssl.KeyManager;
import org.opends.admin.ads.util.ApplicationTrustManager;
import org.opends.admin.ads.util.ConnectionUtils;
import org.opends.guitools.controlpanel.browser.AuthRecord;
import org.opends.guitools.controlpanel.browser.ConnectionRecord;
import org.opends.guitools.controlpanel.event.ReferralAuthenticationListener;
import org.opends.server.types.DN;
import org.opends.server.types.LDAPURL;
import org.opends.server.types.SearchScope;

public class LDAPConnectionPool {
    HashMap<String, AuthRecord> authTable = new HashMap();
    HashMap<String, ConnectionRecord> connectionTable = new HashMap();
    ArrayList<ReferralAuthenticationListener> listeners;
    private Control[] requestControls = new Control[0];
    private ApplicationTrustManager trustManager;
    private int connectTimeout = ConnectionUtils.getDefaultLDAPTimeout();

    public boolean isConnectionRegistered(InitialLdapContext ctx) {
        boolean isConnectionRegistered = false;
        for (String key : this.connectionTable.keySet()) {
            ConnectionRecord cr = this.connectionTable.get(key);
            if (cr.ctx != null) {
                boolean bl = isConnectionRegistered = ConnectionUtils.getHostName(cr.ctx).equals(ConnectionUtils.getHostName(ctx)) && ConnectionUtils.getPort(cr.ctx) == ConnectionUtils.getPort(ctx) && ConnectionUtils.getBindDN(cr.ctx).equals(ConnectionUtils.getBindDN(ctx)) && ConnectionUtils.getBindPassword(cr.ctx).equals(ConnectionUtils.getBindPassword(ctx)) && ConnectionUtils.isSSL(cr.ctx) == ConnectionUtils.isSSL(ctx) && ConnectionUtils.isStartTLS(cr.ctx) == ConnectionUtils.isStartTLS(ctx);
            }
            if (!isConnectionRegistered) continue;
            break;
        }
        return isConnectionRegistered;
    }

    public void registerConnection(InitialLdapContext ctx) {
        this.registerAuth(ctx);
        LDAPURL url = LDAPConnectionPool.makeLDAPUrl(ConnectionUtils.getHostName(ctx), ConnectionUtils.getPort(ctx), "", ConnectionUtils.isSSL(ctx));
        String key = LDAPConnectionPool.makeKeyFromLDAPUrl(url);
        ConnectionRecord cr = new ConnectionRecord();
        cr.ctx = ctx;
        cr.counter = 1;
        cr.disconnectAfterUse = false;
        this.connectionTable.put(key, cr);
    }

    public void unregisterConnection(InitialLdapContext ctx) throws NamingException {
        LDAPURL url = LDAPConnectionPool.makeLDAPUrl(ConnectionUtils.getHostName(ctx), ConnectionUtils.getPort(ctx), "", ConnectionUtils.isSSL(ctx));
        this.unRegisterAuth(url);
        String key = LDAPConnectionPool.makeKeyFromLDAPUrl(url);
        this.connectionTable.remove(key);
    }

    public void addReferralAuthenticationListener(ReferralAuthenticationListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(listener);
    }

    public void removeReferralAuthenticationListener(ReferralAuthenticationListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InitialLdapContext getConnection(LDAPURL ldapUrl) throws NamingException {
        ConnectionRecord cr;
        String key = LDAPConnectionPool.makeKeyFromLDAPUrl(ldapUrl);
        Object object = this;
        synchronized (object) {
            cr = this.connectionTable.get(key);
            if (cr == null) {
                cr = new ConnectionRecord();
                cr.ctx = null;
                cr.counter = 1;
                cr.disconnectAfterUse = false;
                this.connectionTable.put(key, cr);
            } else {
                ++cr.counter;
            }
        }
        object = cr;
        synchronized (object) {
            try {
                if (cr.ctx == null) {
                    boolean registerAuth = false;
                    AuthRecord authRecord = this.authTable.get(key);
                    if (authRecord == null) {
                        authRecord = this.authTable.values().iterator().next();
                        registerAuth = true;
                    }
                    cr.ctx = this.createLDAPConnection(ldapUrl, authRecord);
                    cr.ctx.setRequestControls(this.requestControls);
                    if (registerAuth) {
                        this.authTable.put(key, authRecord);
                    }
                }
            }
            catch (NamingException x) {
                LDAPConnectionPool lDAPConnectionPool = this;
                synchronized (lDAPConnectionPool) {
                    --cr.counter;
                    if (cr.counter == 0) {
                        this.connectionTable.remove(key);
                    }
                }
                throw x;
            }
        }
        return cr.ctx;
    }

    public synchronized void setRequestControls(Control[] ctls) throws NamingException {
        this.requestControls = ctls;
        for (ConnectionRecord cr : this.connectionTable.values()) {
            if (cr.ctx == null) continue;
            cr.ctx.setRequestControls(this.requestControls);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void releaseConnection(InitialLdapContext ctx) {
        String targetKey = null;
        ConnectionRecord targetRecord = null;
        LDAPConnectionPool lDAPConnectionPool = this;
        synchronized (lDAPConnectionPool) {
            for (String key : this.connectionTable.keySet()) {
                ConnectionRecord cr = this.connectionTable.get(key);
                if (cr.ctx != ctx) continue;
                targetKey = key;
                targetRecord = cr;
                if (targetKey == null) continue;
                break;
            }
        }
        if (targetRecord == null) {
            throw new IllegalArgumentException("Invalid LDAP connection");
        }
        lDAPConnectionPool = targetRecord;
        synchronized (lDAPConnectionPool) {
            --targetRecord.counter;
            if (targetRecord.counter == 0 && targetRecord.disconnectAfterUse) {
                this.disconnectAndRemove(targetRecord);
            }
        }
    }

    public synchronized void flush() {
        for (ConnectionRecord cr : this.connectionTable.values()) {
            if (cr.counter <= 0) {
                this.disconnectAndRemove(cr);
                continue;
            }
            cr.disconnectAfterUse = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerAuth(LDAPURL ldapUrl, String dn, String pw, boolean connect) throws NamingException {
        String key = LDAPConnectionPool.makeKeyFromLDAPUrl(ldapUrl);
        AuthRecord ar = new AuthRecord();
        ar.ldapUrl = ldapUrl;
        ar.dn = dn;
        ar.password = pw;
        if (connect) {
            InitialLdapContext ctx = this.createLDAPConnection(ldapUrl, ar);
            ctx.close();
        }
        LDAPConnectionPool lDAPConnectionPool = this;
        synchronized (lDAPConnectionPool) {
            this.authTable.put(key, ar);
            ConnectionRecord cr = this.connectionTable.get(key);
            if (cr != null) {
                if (cr.counter <= 0) {
                    this.disconnectAndRemove(cr);
                } else {
                    cr.disconnectAfterUse = true;
                }
            }
        }
        this.notifyListeners();
    }

    public void registerAuth(InitialLdapContext ctx) {
        LDAPURL url = LDAPConnectionPool.makeLDAPUrl(ConnectionUtils.getHostName(ctx), ConnectionUtils.getPort(ctx), "", ConnectionUtils.isSSL(ctx));
        try {
            this.registerAuth(url, ConnectionUtils.getBindDN(ctx), ConnectionUtils.getBindPassword(ctx), false);
        }
        catch (NamingException x) {
            throw new RuntimeException("Bug");
        }
    }

    public void unRegisterAuth(LDAPURL ldapUrl) throws NamingException {
        String key = LDAPConnectionPool.makeKeyFromLDAPUrl(ldapUrl);
        this.authTable.remove(key);
        this.notifyListeners();
    }

    public synchronized String getAuthDN(LDAPURL ldapUrl) {
        String key = LDAPConnectionPool.makeKeyFromLDAPUrl(ldapUrl);
        AuthRecord ar = this.authTable.get(key);
        String result = ar == null ? null : ar.dn;
        return result;
    }

    public synchronized String getAuthPassword(LDAPURL ldapUrl) {
        String key = LDAPConnectionPool.makeKeyFromLDAPUrl(ldapUrl);
        AuthRecord ar = this.authTable.get(key);
        String result = ar == null ? null : ar.password;
        return result;
    }

    private void disconnectAndRemove(ConnectionRecord cr) {
        String key = LDAPConnectionPool.makeKeyFromRecord(cr);
        this.connectionTable.remove(key);
        try {
            cr.ctx.close();
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    private void notifyListeners() {
        for (ReferralAuthenticationListener listener : this.listeners) {
            listener.notifyAuthDataChanged();
        }
    }

    private static String makeKeyFromLDAPUrl(LDAPURL url) {
        String protocol = LDAPConnectionPool.isSecureLDAPUrl(url) ? "LDAPS" : "LDAP";
        return protocol + ":" + url.getHost() + ":" + url.getPort();
    }

    private static String makeKeyFromRecord(ConnectionRecord rec) {
        String protocol = ConnectionUtils.isSSL(rec.ctx) ? "LDAPS" : "LDAP";
        return protocol + ":" + ConnectionUtils.getHostName(rec.ctx) + ":" + ConnectionUtils.getPort(rec.ctx);
    }

    private InitialLdapContext createLDAPConnection(LDAPURL ldapUrl, AuthRecord ar) throws NamingException {
        InitialLdapContext ctx = LDAPConnectionPool.isSecureLDAPUrl(ldapUrl = new LDAPURL(ldapUrl.getScheme(), ldapUrl.getHost(), ldapUrl.getPort(), (DN)null, null, null, null, null)) ? ConnectionUtils.createLdapsContext(ldapUrl.toString(), ar.dn, ar.password, this.getConnectTimeout(), null, this.getTrustManager(), this.getKeyManager()) : ConnectionUtils.createLdapContext(ldapUrl.toString(), ar.dn, ar.password, this.getConnectTimeout(), null);
        return ctx;
    }

    public void setTrustManager(ApplicationTrustManager trustManager) {
        this.trustManager = trustManager;
    }

    public ApplicationTrustManager getTrustManager() {
        return this.trustManager;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    private KeyManager getKeyManager() {
        return null;
    }

    public static boolean isSecureLDAPUrl(LDAPURL url) {
        return !"ldap".equalsIgnoreCase(url.getScheme());
    }

    public static LDAPURL makeLDAPUrl(String host, int port, String dn, boolean secure) {
        return new LDAPURL(secure ? "ldaps" : "ldap", host, port, dn, null, SearchScope.BASE_OBJECT, null, null);
    }

    public static LDAPURL makeLDAPUrl(InitialLdapContext ctx, String dn) {
        return new LDAPURL(ConnectionUtils.isSSL(ctx) ? "ldaps" : "ldap", ConnectionUtils.getHostName(ctx), ConnectionUtils.getPort(ctx), dn, null, SearchScope.BASE_OBJECT, null, null);
    }

    public static LDAPURL makeLDAPUrl(LDAPURL url, String dn) {
        return new LDAPURL(url.getScheme(), url.getHost(), url.getPort(), dn, null, SearchScope.BASE_OBJECT, null, null);
    }

    Collection<?> getRegisteredAuthentication() {
        return this.authTable.values();
    }
}

