/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.datamodel;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.opends.guitools.controlpanel.datamodel.AbstractIndexDescriptor;
import org.opends.guitools.controlpanel.datamodel.ControlPanelInfo;
import org.opends.guitools.controlpanel.datamodel.SortableTableModel;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;

public abstract class AbstractIndexTableModel
extends SortableTableModel
implements Comparator<AbstractIndexDescriptor> {
    private static final long serialVersionUID = -5131878622200568636L;
    private Set<AbstractIndexDescriptor> data = new HashSet<AbstractIndexDescriptor>();
    private ArrayList<String[]> dataArray = new ArrayList();
    private ArrayList<AbstractIndexDescriptor> indexArray = new ArrayList();
    private final String[] COLUMN_NAMES = this.getColumnNames();
    protected int sortColumn = 0;
    protected boolean sortAscending = true;
    private ControlPanelInfo info;

    public void setData(Set<AbstractIndexDescriptor> newData, ControlPanelInfo info) {
        this.info = info;
        this.data.clear();
        this.data.addAll(newData);
        this.updateDataArray();
        this.fireTableDataChanged();
    }

    @Override
    public void forceResort() {
        this.updateDataArray();
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return this.COLUMN_NAMES.length;
    }

    @Override
    public int getRowCount() {
        return this.dataArray.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        return this.dataArray.get(row)[col];
    }

    @Override
    public String getColumnName(int col) {
        return this.COLUMN_NAMES[col];
    }

    @Override
    public boolean isSortAscending() {
        return this.sortAscending;
    }

    @Override
    public void setSortAscending(boolean sortAscending) {
        this.sortAscending = sortAscending;
    }

    @Override
    public int getSortColumn() {
        return this.sortColumn;
    }

    @Override
    public void setSortColumn(int sortColumn) {
        this.sortColumn = sortColumn;
    }

    public AbstractIndexDescriptor getIndexAt(int row) {
        return this.indexArray.get(row);
    }

    protected Message getRebuildRequiredString(AbstractIndexDescriptor index) {
        if (this.info.mustReindex(index)) {
            return AdminToolMessages.INFO_INDEX_MUST_BE_REBUILT_CELL_VALUE.get();
        }
        return AdminToolMessages.INFO_INDEX_MUST_NOT_BE_REBUILT_CELL_VALUE.get();
    }

    protected int compareNames(AbstractIndexDescriptor i1, AbstractIndexDescriptor i2) {
        return i1.getName().compareTo(i2.getName());
    }

    protected int compareRebuildRequired(AbstractIndexDescriptor i1, AbstractIndexDescriptor i2) {
        return this.getRebuildRequiredString(i1).compareTo(this.getRebuildRequiredString(i2));
    }

    private void updateDataArray() {
        TreeSet<AbstractIndexDescriptor> sortedSet = new TreeSet<AbstractIndexDescriptor>(this);
        sortedSet.addAll(this.data);
        this.dataArray.clear();
        this.indexArray.clear();
        for (AbstractIndexDescriptor index : sortedSet) {
            String[] s = this.getLine(index);
            this.dataArray.add(s);
            this.indexArray.add(index);
        }
    }

    protected abstract String[] getColumnNames();

    protected abstract String[] getLine(AbstractIndexDescriptor var1);
}

