/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.event;

import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.opends.guitools.controlpanel.ui.ColorAndFontConstants;

public class ScrollPaneBorderListener
extends ComponentAdapter {
    private JScrollPane scroll;
    private Border emptyBorder = new EmptyBorder(0, 0, 0, 0);
    private Border etchedBorder = BorderFactory.createMatteBorder(0, 0, 1, 0, ColorAndFontConstants.defaultBorderColor);

    private ScrollPaneBorderListener() {
    }

    public static ScrollPaneBorderListener createBottomBorderListener(JScrollPane scroll) {
        ScrollPaneBorderListener listener = new ScrollPaneBorderListener();
        listener.scroll = scroll;
        scroll.getHorizontalScrollBar().addComponentListener(listener);
        scroll.getVerticalScrollBar().addComponentListener(listener);
        return listener;
    }

    public static ScrollPaneBorderListener createBottomAndTopBorderListener(JScrollPane scroll) {
        ScrollPaneBorderListener listener = ScrollPaneBorderListener.createBottomBorderListener(scroll);
        listener.etchedBorder = BorderFactory.createMatteBorder(1, 0, 1, 0, ColorAndFontConstants.defaultBorderColor);
        return listener;
    }

    public static ScrollPaneBorderListener createFullBorderListener(JScrollPane scroll) {
        ScrollPaneBorderListener listener = ScrollPaneBorderListener.createBottomBorderListener(scroll);
        listener.etchedBorder = BorderFactory.createMatteBorder(1, 1, 1, 1, ColorAndFontConstants.defaultBorderColor);
        return listener;
    }

    @Override
    public void componentShown(ComponentEvent ev) {
        this.updateBorder();
    }

    @Override
    public void componentHidden(ComponentEvent ev) {
        this.updateBorder();
    }

    public void updateBorder() {
        boolean displayBorder;
        boolean bl = displayBorder = this.scroll.getVerticalScrollBar().isVisible() || this.scroll.getHorizontalScrollBar().isVisible();
        if (displayBorder) {
            this.scroll.setBorder(this.etchedBorder);
        } else {
            this.scroll.setBorder(this.emptyBorder);
        }
    }
}

