/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.InetAddress;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import org.opends.guitools.controlpanel.datamodel.BasicMonitoringAttributes;
import org.opends.guitools.controlpanel.datamodel.CategorizedComboBoxElement;
import org.opends.guitools.controlpanel.datamodel.ConnectionHandlerDescriptor;
import org.opends.guitools.controlpanel.datamodel.ConnectionHandlersMonitoringTableModel;
import org.opends.guitools.controlpanel.datamodel.ControlPanelInfo;
import org.opends.guitools.controlpanel.datamodel.CustomSearchResult;
import org.opends.guitools.controlpanel.datamodel.MonitoringAttributes;
import org.opends.guitools.controlpanel.datamodel.ServerDescriptor;
import org.opends.guitools.controlpanel.event.ConfigurationChangeEvent;
import org.opends.guitools.controlpanel.ui.ColorAndFontConstants;
import org.opends.guitools.controlpanel.ui.GenericDialog;
import org.opends.guitools.controlpanel.ui.MainMenuBar;
import org.opends.guitools.controlpanel.ui.MonitoringAttributesViewPanel;
import org.opends.guitools.controlpanel.ui.StatusGenericPanel;
import org.opends.guitools.controlpanel.ui.renderer.NoLeftInsetCategoryComboBoxRenderer;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.guitools.controlpanel.util.ViewPositions;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;

public class ConnectionHandlerMonitoringPanel
extends StatusGenericPanel {
    private static final long serialVersionUID = -6462932160985559830L;
    private MonitoringAttributesViewPanel<MonitoringAttributes> operationViewPanel;
    private GenericDialog operationViewDlg;
    private JComboBox connectionHandlers;
    private JTable connectionHandlersTable;
    private JScrollPane connectionHandlersScroll;
    private ConnectionHandlersMonitoringTableModel connectionHandlersTableModel;
    private JLabel lNoConnectionHandlers = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_NO_CONNECTION_HANDLER_FOUND.get());
    private boolean firstRealDataSet = false;
    private JCheckBoxMenuItem showAveragesMenu;
    private ConnectionHandlerMonitoringMenuBar menuBar;
    private LinkedHashSet<MonitoringAttributes> chOperations = new LinkedHashSet();
    private LinkedHashSet<MonitoringAttributes> allowedChOperations;
    private Message ALL_CONNECTION_HANDLERS;

    public ConnectionHandlerMonitoringPanel() {
        this.chOperations.add(BasicMonitoringAttributes.ADD_REQUESTS);
        this.chOperations.add(BasicMonitoringAttributes.BIND_REQUESTS);
        this.chOperations.add(BasicMonitoringAttributes.DELETE_REQUESTS);
        this.chOperations.add(BasicMonitoringAttributes.MOD_REQUESTS);
        this.chOperations.add(BasicMonitoringAttributes.MOD_DN_REQUESTS);
        this.chOperations.add(BasicMonitoringAttributes.SEARCH_REQUESTS);
        this.allowedChOperations = new LinkedHashSet();
        this.allowedChOperations.addAll(this.chOperations);
        this.allowedChOperations.add(BasicMonitoringAttributes.ADD_RESPONSES);
        this.allowedChOperations.add(BasicMonitoringAttributes.BIND_RESPONSES);
        this.allowedChOperations.add(BasicMonitoringAttributes.COMPARE_RESPONSES);
        this.allowedChOperations.add(BasicMonitoringAttributes.DELETE_RESPONSES);
        this.allowedChOperations.add(BasicMonitoringAttributes.EXTENDED_REQUESTS);
        this.allowedChOperations.add(BasicMonitoringAttributes.EXTENDED_RESPONSES);
        this.allowedChOperations.add(BasicMonitoringAttributes.MOD_DN_RESPONSES);
        this.allowedChOperations.add(BasicMonitoringAttributes.MOD_RESPONSES);
        this.allowedChOperations.add(BasicMonitoringAttributes.SEARCH_DONE);
        this.allowedChOperations.add(BasicMonitoringAttributes.UNBIND_REQUESTS);
        this.ALL_CONNECTION_HANDLERS = AdminToolMessages.INFO_CTRL_PANEL_ALL_CONNECTION_HANDLERS.get();
        this.createLayout();
    }

    private void createLayout() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        this.addErrorPane(gbc);
        gbc.weighty = 1.0;
        JPanel viewOptions = new JPanel(new GridBagLayout());
        viewOptions.setBackground(ColorAndFontConstants.greyBackground);
        viewOptions.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, ColorAndFontConstants.defaultBorderColor));
        gbc.gridwidth = 1;
        JLabel l = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_CONNECTION_HANDLERS_LABEL.get());
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.weightx = 0.0;
        gbc.insets = new Insets(10, 10, 10, 0);
        viewOptions.add((Component)l, gbc);
        gbc.insets.left = 5;
        gbc.insets.right = 10;
        this.connectionHandlers = new JComboBox<String>(new DefaultComboBoxModel<String>(new String[]{"fakeconnectionhandlername"}));
        this.connectionHandlers.addItemListener(new StatusGenericPanel.IgnoreItemListener(this, this.connectionHandlers));
        this.connectionHandlers.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ev) {
                if (ev.getStateChange() == 1) {
                    ConnectionHandlerMonitoringPanel.this.updateConnectionHandlersPanel(ConnectionHandlerMonitoringPanel.this.getInfo().getServerDescriptor(), ConnectionHandlerMonitoringPanel.this.errorPane.isVisible());
                }
            }
        });
        this.connectionHandlers.setRenderer(new NoLeftInsetCategoryComboBoxRenderer(this.connectionHandlers));
        ++gbc.gridx;
        viewOptions.add((Component)this.connectionHandlers, gbc);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.insets.left = 0;
        gbc.insets.right = 0;
        gbc.fill = 2;
        viewOptions.add(Box.createHorizontalGlue(), gbc);
        gbc.gridy = 1;
        gbc.gridx = 0;
        gbc.gridwidth = 1;
        gbc.insets.left = 0;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(0, 0, 0, 0);
        this.add((Component)viewOptions, gbc);
        this.connectionHandlersTableModel = new ConnectionHandlersMonitoringTableModel();
        String[] names = new String[]{"First Connection Handler", "Second Connection Handler", "Third Connection Handler", "Fourth Connection Handler", "Fifth Connection Handler", "Connection Handler with a long name"};
        HashSet<ConnectionHandlerDescriptor> fakeData = new HashSet<ConnectionHandlerDescriptor>();
        this.connectionHandlersTableModel.setAttributes(this.chOperations, false);
        try {
            HashSet<InetAddress> addresses = new HashSet<InetAddress>();
            addresses.add(InetAddress.getLocalHost());
            Set<CustomSearchResult> emptySet = Collections.emptySet();
            for (String name : names) {
                fakeData.add(new ConnectionHandlerDescriptor(addresses, 1389, ConnectionHandlerDescriptor.Protocol.LDAP, ConnectionHandlerDescriptor.State.ENABLED, name, emptySet));
            }
            this.connectionHandlersTableModel.setData(fakeData, 0L);
        }
        catch (Throwable t) {
            // empty catch block
        }
        this.connectionHandlersTable = Utilities.createSortableTable(this.connectionHandlersTableModel, new DefaultTableCellRenderer());
        this.connectionHandlersScroll = Utilities.createScrollPane(this.connectionHandlersTable);
        gbc.insets = new Insets(10, 10, 10, 10);
        ++gbc.gridy;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        this.add((Component)this.connectionHandlersScroll, gbc);
        gbc.fill = 3;
        gbc.anchor = 10;
        this.add((Component)this.lNoConnectionHandlers, gbc);
        this.updateTableSizes();
    }

    @Override
    public Message getTitle() {
        return AdminToolMessages.INFO_CTRL_PANEL_CONNECTION_HANDLER_MONITORING_TITLE.get();
    }

    @Override
    public JMenuBar getMenuBar() {
        if (this.menuBar == null) {
            this.menuBar = new ConnectionHandlerMonitoringMenuBar(this.getInfo());
        }
        return this.menuBar;
    }

    @Override
    public void configurationChanged(ConfigurationChangeEvent ev) {
        MessageBuilder mb;
        final ServerDescriptor server = ev.getNewDescriptor();
        LinkedHashSet<Object> newElements = new LinkedHashSet<Object>();
        newElements.add(new CategorizedComboBoxElement(this.ALL_CONNECTION_HANDLERS, CategorizedComboBoxElement.Type.REGULAR));
        Set<ConnectionHandlerDescriptor> chs = server.getConnectionHandlers();
        TreeSet<ConnectionHandlerDescriptor> sortedChs = new TreeSet<ConnectionHandlerDescriptor>(new Comparator<ConnectionHandlerDescriptor>(){

            @Override
            public int compare(ConnectionHandlerDescriptor desc1, ConnectionHandlerDescriptor desc2) {
                int compare = 0;
                if (desc1.getAddresses().equals(desc2.getAddresses())) {
                    Integer port1 = new Integer(desc1.getPort());
                    Integer port2 = new Integer(desc2.getPort());
                    compare = port1.compareTo(port2);
                } else {
                    compare = ConnectionHandlerMonitoringPanel.this.getConnectionHandlerLabel(desc1).compareTo(ConnectionHandlerMonitoringPanel.this.getConnectionHandlerLabel(desc2));
                }
                return compare;
            }
        });
        for (ConnectionHandlerDescriptor ch : chs) {
            if (!this.protocolHasMonitoring(ch)) continue;
            sortedChs.add(ch);
        }
        sortedChs.add(server.getAdminConnector());
        newElements.add("----------");
        for (ConnectionHandlerDescriptor ch : sortedChs) {
            String connectionHandlerLabel = this.getConnectionHandlerLabel(ch);
            newElements.add(new CategorizedComboBoxElement(connectionHandlerLabel, CategorizedComboBoxElement.Type.REGULAR));
        }
        this.updateComboBoxModel(newElements, (DefaultComboBoxModel)this.connectionHandlers.getModel());
        boolean displayErrorPane = false;
        Message errorTitle = Message.EMPTY;
        Message errorDetails = Message.EMPTY;
        ServerDescriptor.ServerStatus status = server.getStatus();
        if (status == ServerDescriptor.ServerStatus.STARTED) {
            if (!server.isAuthenticated()) {
                mb = new MessageBuilder();
                mb.append(AdminToolMessages.INFO_CTRL_PANEL_AUTH_REQUIRED_TO_SEE_TRAFFIC_MONITORING_SUMMARY.get());
                mb.append("<br><br>" + this.getAuthenticateHTML());
                errorDetails = mb.toMessage();
                errorTitle = AdminToolMessages.INFO_CTRL_PANEL_AUTHENTICATION_REQUIRED_SUMMARY.get();
                displayErrorPane = true;
            }
        } else if (status == ServerDescriptor.ServerStatus.NOT_CONNECTED_TO_REMOTE) {
            mb = new MessageBuilder();
            mb.append(AdminToolMessages.INFO_CTRL_PANEL_CANNOT_CONNECT_TO_REMOTE_DETAILS.get(server.getHostname()));
            mb.append("<br><br>" + this.getAuthenticateHTML());
            errorDetails = mb.toMessage();
            errorTitle = AdminToolMessages.INFO_CTRL_PANEL_CANNOT_CONNECT_TO_REMOTE_SUMMARY.get();
            displayErrorPane = true;
        } else {
            errorTitle = AdminToolMessages.INFO_CTRL_PANEL_SERVER_NOT_RUNNING_SUMMARY.get();
            mb = new MessageBuilder();
            mb.append(AdminToolMessages.INFO_CTRL_PANEL_SERVER_MUST_RUN_TO_SEE_TRAFFIC_MONITORING_SUMMARY.get());
            mb.append("<br><br>");
            mb.append(this.getStartServerHTML());
            errorDetails = mb.toMessage();
            displayErrorPane = true;
        }
        final boolean fDisplayErrorPane = displayErrorPane;
        final Message fErrorTitle = errorTitle;
        final Message fErrorDetails = errorDetails;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ViewPositions pos = Utilities.getViewPositions(ConnectionHandlerMonitoringPanel.this);
                ConnectionHandlerMonitoringPanel.this.errorPane.setVisible(fDisplayErrorPane);
                if (fDisplayErrorPane) {
                    ConnectionHandlerMonitoringPanel.this.updateErrorPane(ConnectionHandlerMonitoringPanel.this.errorPane, fErrorTitle, ColorAndFontConstants.errorTitleFont, fErrorDetails, ColorAndFontConstants.defaultFont);
                }
                if (!ConnectionHandlerMonitoringPanel.this.firstRealDataSet) {
                    ConnectionHandlerMonitoringPanel.this.updateTableSizes();
                    ConnectionHandlerMonitoringPanel.this.firstRealDataSet = true;
                }
                ConnectionHandlerMonitoringPanel.this.updateConnectionHandlersPanel(server, fDisplayErrorPane);
                Utilities.updateViewPositions(pos);
            }
        });
    }

    @Override
    public Component getPreferredFocusComponent() {
        return this.connectionHandlers;
    }

    @Override
    public void okClicked() {
    }

    @Override
    public GenericDialog.ButtonType getButtonType() {
        return GenericDialog.ButtonType.CLOSE;
    }

    @Override
    public boolean requiresBorder() {
        return false;
    }

    @Override
    public boolean requiresScroll() {
        return false;
    }

    private void setChOperationsToDisplay(LinkedHashSet<MonitoringAttributes> operations, boolean showAverages) {
        this.connectionHandlersTableModel.setAttributes(operations, showAverages);
        this.connectionHandlersTableModel.forceDataStructureChange();
    }

    private String getConnectionHandlerLabel(ConnectionHandlerDescriptor ch) {
        StringBuilder sb = new StringBuilder();
        if (ch.getProtocol() == ConnectionHandlerDescriptor.Protocol.ADMINISTRATION_CONNECTOR) {
            sb.append(AdminToolMessages.INFO_CTRL_PANEL_ADMINISTRATION_CONNECTOR_NAME.get(ch.getPort()));
        } else {
            sb.append(ch.getPort());
            sb.append(" - ");
            switch (ch.getProtocol()) {
                case OTHER: {
                    sb.append(ch.getName());
                    break;
                }
                default: {
                    sb.append(ch.getProtocol().getDisplayMessage().toString());
                }
            }
        }
        return sb.toString();
    }

    private void operationViewClicked() {
        if (this.operationViewDlg == null) {
            this.operationViewPanel = MonitoringAttributesViewPanel.createMonitoringAttributesInstance(this.allowedChOperations);
            this.operationViewDlg = new GenericDialog(Utilities.getFrame(this), this.operationViewPanel);
            Utilities.centerGoldenMean(this.operationViewDlg, Utilities.getParentDialog(this));
            this.operationViewDlg.setModal(true);
        }
        this.operationViewPanel.setSelectedAttributes(this.chOperations);
        this.operationViewDlg.setVisible(true);
        if (!this.operationViewPanel.isCanceled()) {
            boolean showAverages = this.showAveragesMenu.isSelected();
            this.chOperations = this.operationViewPanel.getAttributes();
            this.setChOperationsToDisplay(this.chOperations, showAverages);
            this.updateTableSizes();
        }
    }

    private void showAverageClicked() {
        boolean showAverages = this.showAveragesMenu.isSelected();
        this.setChOperationsToDisplay(this.chOperations, showAverages);
        this.updateTableSizes();
    }

    private void updateTableSizes() {
        Utilities.updateTableSizes(this.connectionHandlersTable, 8);
        Utilities.updateScrollMode(this.connectionHandlersScroll, this.connectionHandlersTable);
    }

    private void updateConnectionHandlersPanel(ServerDescriptor server, boolean errorOccurred) {
        Set<ConnectionHandlerDescriptor> cch = this.getFilteredConnectionHandlers(server);
        this.connectionHandlersTableModel.setData(cch, server.getRunningTime());
        this.connectionHandlersScroll.setVisible(!cch.isEmpty() && !errorOccurred);
        this.lNoConnectionHandlers.setVisible(cch.isEmpty() && !errorOccurred);
    }

    private Set<ConnectionHandlerDescriptor> getFilteredConnectionHandlers(ServerDescriptor server) {
        Object o;
        HashSet<ConnectionHandlerDescriptor> cchs = new HashSet<ConnectionHandlerDescriptor>();
        if (server != null && (o = this.connectionHandlers.getSelectedItem()) instanceof CategorizedComboBoxElement) {
            Object value = ((CategorizedComboBoxElement)o).getValue();
            if (value.equals(this.ALL_CONNECTION_HANDLERS)) {
                for (ConnectionHandlerDescriptor ch : server.getConnectionHandlers()) {
                    if (!this.protocolHasMonitoring(ch)) continue;
                    cchs.add(ch);
                }
                cchs.add(server.getAdminConnector());
            } else {
                ConnectionHandlerDescriptor adminCh;
                String name = value.toString();
                for (ConnectionHandlerDescriptor ch : server.getConnectionHandlers()) {
                    if (!this.getConnectionHandlerLabel(ch).equals(name)) continue;
                    cchs.add(ch);
                    break;
                }
                if (cchs.isEmpty() && this.getConnectionHandlerLabel(adminCh = server.getAdminConnector()).equals(name)) {
                    cchs.add(adminCh);
                }
            }
        }
        return cchs;
    }

    private boolean protocolHasMonitoring(ConnectionHandlerDescriptor ch) {
        return ch.getProtocol() == ConnectionHandlerDescriptor.Protocol.LDAP || ch.getProtocol() == ConnectionHandlerDescriptor.Protocol.LDAPS || ch.getProtocol() == ConnectionHandlerDescriptor.Protocol.LDAP_STARTTLS || ch.getProtocol() == ConnectionHandlerDescriptor.Protocol.OTHER;
    }

    class ConnectionHandlerMonitoringMenuBar
    extends MainMenuBar {
        private static final long serialVersionUID = 505187831116443370L;

        public ConnectionHandlerMonitoringMenuBar(ControlPanelInfo info) {
            super(info);
        }

        @Override
        protected void addMenus() {
            this.add(this.createViewMenuBar());
            this.add(this.createHelpMenuBar());
        }

        @Override
        protected JMenu createViewMenuBar() {
            JMenu menu = Utilities.createMenu(AdminToolMessages.INFO_CTRL_PANEL_CONNECTION_HANDLER_VIEW_MENU.get(), AdminToolMessages.INFO_CTRL_PANEL_CONNECTION_HANDLER_VIEW_MENU_DESCRIPTION.get());
            menu.setMnemonic(86);
            JMenuItem viewOperations = Utilities.createMenuItem(AdminToolMessages.INFO_CTRL_PANEL_OPERATIONS_VIEW.get());
            menu.add(viewOperations);
            viewOperations.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    ConnectionHandlerMonitoringPanel.this.operationViewClicked();
                }
            });
            ConnectionHandlerMonitoringPanel.this.showAveragesMenu = new JCheckBoxMenuItem(AdminToolMessages.INFO_CTRL_PANEL_SHOW_AVERAGES.get().toString());
            ConnectionHandlerMonitoringPanel.this.showAveragesMenu.setSelected(false);
            menu.add(ConnectionHandlerMonitoringPanel.this.showAveragesMenu);
            ConnectionHandlerMonitoringPanel.this.showAveragesMenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    ConnectionHandlerMonitoringPanel.this.showAverageClicked();
                }
            });
            return menu;
        }
    }
}

