/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.ldap.InitialLdapContext;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.opends.guitools.controlpanel.datamodel.BackendDescriptor;
import org.opends.guitools.controlpanel.datamodel.BaseDNDescriptor;
import org.opends.guitools.controlpanel.datamodel.ControlPanelInfo;
import org.opends.guitools.controlpanel.datamodel.ServerDescriptor;
import org.opends.guitools.controlpanel.event.BrowseActionListener;
import org.opends.guitools.controlpanel.event.ConfigurationChangeEvent;
import org.opends.guitools.controlpanel.task.OfflineUpdateException;
import org.opends.guitools.controlpanel.task.OnlineUpdateException;
import org.opends.guitools.controlpanel.task.Task;
import org.opends.guitools.controlpanel.ui.ColorAndFontConstants;
import org.opends.guitools.controlpanel.ui.ProgressDialog;
import org.opends.guitools.controlpanel.ui.StatusGenericPanel;
import org.opends.guitools.controlpanel.ui.renderer.CustomListCellRenderer;
import org.opends.guitools.controlpanel.util.ConfigReader;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.ConfigMessages;
import org.opends.messages.Message;
import org.opends.messages.QuickSetupMessages;
import org.opends.quicksetup.Installation;
import org.opends.quicksetup.installer.InstallerHelper;
import org.opends.quicksetup.util.Utils;
import org.opends.server.admin.client.ManagementContext;
import org.opends.server.admin.client.ldap.JNDIDirContextAdaptor;
import org.opends.server.admin.client.ldap.LDAPManagementContext;
import org.opends.server.admin.std.client.LocalDBBackendCfgClient;
import org.opends.server.admin.std.client.RootCfgClient;
import org.opends.server.admin.std.meta.BackendCfgDefn;
import org.opends.server.admin.std.meta.LocalDBBackendCfgDefn;
import org.opends.server.backends.jeb.BackendImpl;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.DNConfigAttribute;
import org.opends.server.core.DirectoryServer;
import org.opends.server.extensions.ConfigFileHandler;
import org.opends.server.tools.ImportLDIF;
import org.opends.server.tools.LDAPModify;
import org.opends.server.tools.makeldif.MakeLDIF;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.DN;
import org.opends.server.types.Entry;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.types.OpenDsException;
import org.opends.server.util.LDIFReader;
import org.opends.server.util.SetupUtils;
import org.opends.server.util.cli.CommandBuilder;

public class NewBaseDNPanel
extends StatusGenericPanel {
    private static final long serialVersionUID = -2680821576362341119L;
    private JComboBox backends;
    private JTextField newBackend;
    private JTextField baseDN;
    private JRadioButton onlyCreateBaseEntry;
    private JRadioButton leaveDatabaseEmpty;
    private JRadioButton importDataFromLDIF;
    private JRadioButton importAutomaticallyGenerated;
    private JTextField path;
    private JTextField numberOfEntries;
    private JLabel lRemoteFileHelp;
    private JButton browseImportPath;
    private JLabel lBackend;
    private JLabel lDirectoryBaseDN;
    private JLabel lPath;
    private JLabel lNumberOfEntries;
    private JLabel lDirectoryData;
    private DocumentListener documentListener;
    private final Message NEW_BACKEND = AdminToolMessages.INFO_CTRL_PANEL_NEW_BACKEND_LABEL.get();

    public NewBaseDNPanel() {
        this.createLayout();
    }

    @Override
    public Message getTitle() {
        return AdminToolMessages.INFO_CTRL_PANEL_NEW_BASE_DN_TITLE.get();
    }

    @Override
    public Component getPreferredFocusComponent() {
        return this.baseDN;
    }

    @Override
    public void toBeDisplayed(boolean visible) {
        if (visible) {
            this.documentListener.changedUpdate(null);
        }
    }

    private void createLayout() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 3;
        this.addErrorPane(gbc);
        gbc.anchor = 17;
        gbc.weightx = 0.0;
        gbc.gridwidth = 1;
        ++gbc.gridy;
        gbc.fill = 0;
        this.lBackend = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_BACKEND_LABEL.get());
        this.add((Component)this.lBackend, gbc);
        gbc.insets.left = 10;
        gbc.gridx = 1;
        this.backends = Utilities.createComboBox();
        this.backends.setModel(new DefaultComboBoxModel<Object>(new Object[]{"bogus", this.NEW_BACKEND}));
        this.backends.setRenderer(new CustomListCellRenderer(this.backends));
        this.backends.addItemListener(new StatusGenericPanel.IgnoreItemListener(this, this.backends));
        gbc.gridwidth = 1;
        this.add((Component)this.backends, gbc);
        this.newBackend = Utilities.createTextField();
        this.newBackend.setColumns(25);
        gbc.gridx = 2;
        this.add((Component)this.newBackend, gbc);
        ItemListener comboListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ev) {
                Object o = NewBaseDNPanel.this.backends.getSelectedItem();
                NewBaseDNPanel.this.newBackend.setEnabled(NewBaseDNPanel.this.NEW_BACKEND.equals(o));
            }
        };
        this.backends.addItemListener(comboListener);
        comboListener.itemStateChanged(null);
        gbc.insets.top = 10;
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.insets.left = 0;
        gbc.gridwidth = 1;
        this.lDirectoryBaseDN = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_BASE_DN_LABEL.get());
        this.add((Component)this.lDirectoryBaseDN, gbc);
        gbc.gridx = 1;
        gbc.insets.left = 10;
        gbc.gridwidth = 2;
        this.baseDN = Utilities.createTextField();
        this.documentListener = new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent ev) {
                String text = NewBaseDNPanel.this.baseDN.getText().trim();
                NewBaseDNPanel.this.setEnabledOK(text != null && text.length() > 0 && !NewBaseDNPanel.this.errorPane.isVisible());
            }

            @Override
            public void removeUpdate(DocumentEvent ev) {
                this.changedUpdate(ev);
            }

            @Override
            public void insertUpdate(DocumentEvent ev) {
                this.changedUpdate(ev);
            }
        };
        this.baseDN.getDocument().addDocumentListener(this.documentListener);
        gbc.weightx = 1.0;
        gbc.fill = 2;
        this.add((Component)this.baseDN, gbc);
        ++gbc.gridy;
        gbc.anchor = 13;
        gbc.insets.top = 3;
        JLabel inlineHelp = Utilities.createInlineHelpLabel(AdminToolMessages.INFO_CTRL_PANEL_BASE_DN_EXAMPLE.get());
        this.add((Component)inlineHelp, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.insets.left = 0;
        gbc.insets.top = 10;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        this.lDirectoryData = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_DIRECTORY_DATA_LABEL.get());
        this.add((Component)this.lDirectoryData, gbc);
        this.onlyCreateBaseEntry = Utilities.createRadioButton(AdminToolMessages.INFO_CTRL_PANEL_ONLY_CREATE_BASE_ENTRY_LABEL.get());
        this.onlyCreateBaseEntry.setSelected(false);
        gbc.insets.left = 10;
        gbc.gridx = 1;
        gbc.gridwidth = 2;
        this.add((Component)this.onlyCreateBaseEntry, gbc);
        this.leaveDatabaseEmpty = Utilities.createRadioButton(AdminToolMessages.INFO_CTRL_PANEL_LEAVE_DATABASE_EMPTY_LABEL.get());
        this.leaveDatabaseEmpty.setSelected(false);
        ++gbc.gridy;
        gbc.gridwidth = 2;
        gbc.insets.top = 5;
        this.add((Component)this.leaveDatabaseEmpty, gbc);
        this.importDataFromLDIF = Utilities.createRadioButton(AdminToolMessages.INFO_CTRL_PANEL_IMPORT_FROM_LDIF_LABEL.get());
        this.importDataFromLDIF.setSelected(false);
        ++gbc.gridy;
        gbc.gridwidth = 2;
        this.add((Component)this.importDataFromLDIF, gbc);
        ++gbc.gridy;
        gbc.gridwidth = 2;
        gbc.insets.left = 30;
        this.add((Component)this.createPathPanel(), gbc);
        this.importAutomaticallyGenerated = Utilities.createRadioButton(AdminToolMessages.INFO_CTRL_PANEL_IMPORT_AUTOMATICALLY_GENERATED_LABEL.get());
        this.importAutomaticallyGenerated.setOpaque(false);
        this.importAutomaticallyGenerated.setSelected(false);
        ++gbc.gridy;
        gbc.gridwidth = 2;
        gbc.insets.left = 10;
        this.add((Component)this.importAutomaticallyGenerated, gbc);
        ++gbc.gridy;
        gbc.gridwidth = 2;
        gbc.insets.left = 30;
        this.add((Component)this.createNumberOfUsersPanel(), gbc);
        ButtonGroup group = new ButtonGroup();
        group.add(this.onlyCreateBaseEntry);
        group.add(this.leaveDatabaseEmpty);
        group.add(this.importDataFromLDIF);
        group.add(this.importAutomaticallyGenerated);
        ChangeListener listener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent ev) {
                NewBaseDNPanel.this.browseImportPath.setEnabled(NewBaseDNPanel.this.importDataFromLDIF.isSelected());
                NewBaseDNPanel.this.lPath.setEnabled(NewBaseDNPanel.this.importDataFromLDIF.isSelected());
                NewBaseDNPanel.this.lRemoteFileHelp.setEnabled(NewBaseDNPanel.this.importDataFromLDIF.isSelected());
                NewBaseDNPanel.this.numberOfEntries.setEnabled(NewBaseDNPanel.this.importAutomaticallyGenerated.isSelected());
                NewBaseDNPanel.this.lNumberOfEntries.setEnabled(NewBaseDNPanel.this.importAutomaticallyGenerated.isSelected());
            }
        };
        Enumeration<AbstractButton> buttons = group.getElements();
        while (buttons.hasMoreElements()) {
            buttons.nextElement().addChangeListener(listener);
        }
        this.onlyCreateBaseEntry.setSelected(true);
        listener.stateChanged(null);
        this.addBottomGlue(gbc);
    }

    @Override
    public void configurationChanged(ConfigurationChangeEvent ev) {
        ServerDescriptor desc = ev.getNewDescriptor();
        TreeSet<String> sortedBackends = new TreeSet<String>();
        for (BackendDescriptor backend : desc.getBackends()) {
            if (backend.isConfigBackend()) continue;
            sortedBackends.add(backend.getBackendID());
        }
        ArrayList<CharSequence> newElements = new ArrayList<CharSequence>();
        newElements.addAll(sortedBackends);
        if (sortedBackends.size() > 0) {
            newElements.add("----------");
        }
        newElements.add(this.NEW_BACKEND);
        super.updateComboBoxModel(newElements, (DefaultComboBoxModel)this.backends.getModel());
        this.updateErrorPaneAndOKButtonIfAuthRequired(desc, this.isLocal() ? AdminToolMessages.INFO_CTRL_PANEL_AUTHENTICATION_REQUIRED_FOR_CREATE_BASE_DN.get() : AdminToolMessages.INFO_CTRL_PANEL_CANNOT_CONNECT_TO_REMOTE_DETAILS.get(desc.getHostname()));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NewBaseDNPanel.this.lRemoteFileHelp.setVisible(!NewBaseDNPanel.this.isLocal());
                NewBaseDNPanel.this.browseImportPath.setVisible(NewBaseDNPanel.this.isLocal());
            }
        });
    }

    private JPanel createPathPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 1;
        gbc.gridy = 0;
        gbc.gridx = 0;
        this.lPath = Utilities.createDefaultLabel(AdminToolMessages.INFO_CTRL_PANEL_IMPORT_LDIF_PATH_LABEL.get());
        panel.add((Component)this.lPath, gbc);
        gbc.gridx = 1;
        gbc.insets.left = 10;
        this.path = Utilities.createTextField();
        gbc.weightx = 1.0;
        gbc.fill = 2;
        panel.add((Component)this.path, gbc);
        this.browseImportPath = Utilities.createButton(AdminToolMessages.INFO_CTRL_PANEL_BROWSE_BUTTON_LABEL.get());
        this.browseImportPath.addActionListener(new BrowseActionListener(this.path, BrowseActionListener.BrowseType.OPEN_LDIF_FILE, this));
        gbc.gridx = 2;
        gbc.weightx = 0.0;
        panel.add((Component)this.browseImportPath, gbc);
        ++gbc.gridy;
        gbc.gridx = 1;
        this.lRemoteFileHelp = Utilities.createInlineHelpLabel(AdminToolMessages.INFO_CTRL_PANEL_REMOTE_SERVER_PATH.get());
        gbc.insets.top = 3;
        gbc.insets.left = 10;
        panel.add((Component)this.lRemoteFileHelp, gbc);
        return panel;
    }

    private JPanel createNumberOfUsersPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 0.0;
        gbc.fill = 2;
        this.lNumberOfEntries = Utilities.createDefaultLabel(AdminToolMessages.INFO_CTRL_PANEL_NUMBER_OF_USER_ENTRIES_LABEL.get());
        panel.add((Component)this.lNumberOfEntries, gbc);
        gbc.gridx = 1;
        gbc.insets.left = 10;
        this.numberOfEntries = Utilities.createTextField("2000", 6);
        panel.add((Component)this.numberOfEntries, gbc);
        gbc.gridx = 2;
        gbc.insets.left = 0;
        gbc.weightx = 1.0;
        panel.add(Box.createHorizontalGlue(), gbc);
        return panel;
    }

    @Override
    public void cancelClicked() {
        this.setPrimaryValid(this.lBackend);
        this.setPrimaryValid(this.lDirectoryBaseDN);
        this.setPrimaryValid(this.lDirectoryData);
        this.setSecondaryValid(this.lPath);
        this.setSecondaryValid(this.lNumberOfEntries);
        super.cancelClicked();
    }

    @Override
    protected void checkOKButtonEnable() {
        this.documentListener.changedUpdate(null);
    }

    @Override
    public void okClicked() {
        this.setPrimaryValid(this.lBackend);
        this.setPrimaryValid(this.lDirectoryBaseDN);
        this.setPrimaryValid(this.lDirectoryData);
        this.setSecondaryValid(this.lPath);
        this.setSecondaryValid(this.lNumberOfEntries);
        LinkedHashSet<Message> errors = new LinkedHashSet<Message>();
        ServerDescriptor desc = this.getInfo().getServerDescriptor();
        Set<BackendDescriptor> backendObjects = desc.getBackends();
        Object o = this.backends.getSelectedItem();
        String backendName = String.valueOf(o);
        if (o == null) {
            errors.add(AdminToolMessages.ERR_CTRL_PANEL_NO_BACKENDS_SELECTED.get());
            this.setPrimaryInvalid(this.lBackend);
        } else if (o.equals(this.NEW_BACKEND)) {
            backendName = this.newBackend.getText().trim();
            if (backendName.length() == 0) {
                errors.add(AdminToolMessages.ERR_NEW_BACKEND_NAME_REQUIRED.get());
                this.setPrimaryInvalid(this.lBackend);
            } else {
                for (BackendDescriptor backend : backendObjects) {
                    if (!backendName.equalsIgnoreCase(backend.getBackendID())) continue;
                    errors.add(AdminToolMessages.ERR_BACKEND_ALREADY_EXISTS.get(backendName));
                    this.setPrimaryInvalid(this.lBackend);
                    break;
                }
            }
        }
        String dn = this.baseDN.getText();
        if (dn.trim().length() == 0) {
            errors.add(AdminToolMessages.ERR_NEW_BASE_DN_VALUE_REQUIRED.get());
            this.setPrimaryInvalid(this.lDirectoryBaseDN);
        } else {
            try {
                DN theDN = DN.decode(dn);
                boolean baseDNAlreadyDefined = false;
                for (BackendDescriptor backend : backendObjects) {
                    for (BaseDNDescriptor baseDN : backend.getBaseDns()) {
                        if (baseDN.getDn().equals(theDN)) {
                            errors.add(AdminToolMessages.ERR_BASE_DN_ALREADY_EXISTS.get(dn));
                            this.setPrimaryInvalid(this.lDirectoryBaseDN);
                            baseDNAlreadyDefined = true;
                            break;
                        }
                        if (baseDN.getDn().isAncestorOf(theDN)) {
                            if (!backendName.equalsIgnoreCase(backend.getBackendID())) continue;
                            errors.add(AdminToolMessages.ERR_BASE_DN_ANCESTOR_EXISTS.get(baseDN.getDn().toString()));
                            this.setPrimaryInvalid(this.lDirectoryBaseDN);
                            baseDNAlreadyDefined = true;
                            break;
                        }
                        if (!theDN.isAncestorOf(baseDN.getDn()) || !backendName.equalsIgnoreCase(backend.getBackendID())) continue;
                        errors.add(AdminToolMessages.ERR_BASE_DN_DN_IS_ANCESTOR_OF.get(baseDN.getDn().toString()));
                        this.setPrimaryInvalid(this.lDirectoryBaseDN);
                        baseDNAlreadyDefined = true;
                        break;
                    }
                    if (!baseDNAlreadyDefined) continue;
                    break;
                }
            }
            catch (OpenDsException oe) {
                errors.add(AdminToolMessages.INFO_CTRL_PANEL_INVALID_DN_DETAILS.get(dn, oe.getMessageObject().toString()));
                this.setPrimaryInvalid(this.lDirectoryBaseDN);
            }
        }
        if (this.importDataFromLDIF.isSelected()) {
            String ldifPath = this.path.getText();
            if (ldifPath == null || ldifPath.trim().equals("")) {
                errors.add(QuickSetupMessages.INFO_NO_LDIF_PATH.get());
                this.setSecondaryInvalid(this.lPath);
            } else if (this.isLocal() && !Utils.fileExists(ldifPath)) {
                errors.add(QuickSetupMessages.INFO_LDIF_FILE_DOES_NOT_EXIST.get());
                this.setSecondaryInvalid(this.lPath);
            }
        }
        if (this.importAutomaticallyGenerated.isSelected()) {
            String nEntries = this.numberOfEntries.getText();
            int minValue = 1;
            int maxValue = this.isLocal() ? 20000 : 1000;
            Message errMsg = AdminToolMessages.ERR_NUMBER_OF_ENTRIES_INVALID.get(minValue, maxValue);
            this.checkIntValue(errors, nEntries, minValue, maxValue, errMsg);
        }
        if (errors.isEmpty()) {
            ProgressDialog progressDialog = new ProgressDialog(Utilities.createFrame(), Utilities.getParentDialog(this), this.getTitle(), this.getInfo());
            NewBaseDNTask newTask = new NewBaseDNTask(this.getInfo(), progressDialog);
            for (Task task : this.getInfo().getTasks()) {
                task.canLaunch(newTask, errors);
            }
            if (errors.isEmpty()) {
                this.launchOperation(newTask, AdminToolMessages.INFO_CTRL_PANEL_CREATING_BASE_DN_SUMMARY.get(dn), AdminToolMessages.INFO_CTRL_PANEL_CREATING_BASE_DN_COMPLETE.get(), AdminToolMessages.INFO_CTRL_PANEL_CREATING_BASE_DN_SUCCESSFUL.get(dn), AdminToolMessages.ERR_CTRL_PANEL_CREATING_BASE_DN_ERROR_SUMMARY.get(dn), null, AdminToolMessages.ERR_CTRL_PANEL_CREATING_BASE_DN_ERROR_DETAILS, progressDialog);
                progressDialog.setVisible(true);
                this.baseDN.setText("");
                this.baseDN.grabFocus();
                Utilities.getParentDialog(this).setVisible(false);
            }
        }
        if (errors.size() > 0) {
            this.displayErrorDialog(errors);
        }
    }

    private String getBackendName() {
        Object backendName = this.backends.getSelectedItem();
        if (this.NEW_BACKEND.equals(backendName)) {
            return this.newBackend.getText().trim();
        }
        if (backendName != null) {
            return backendName.toString();
        }
        return null;
    }

    private boolean isNewBackend() {
        return this.NEW_BACKEND.equals(this.backends.getSelectedItem());
    }

    protected class NewBaseDNTask
    extends Task {
        Set<String> backendSet;
        private String newBaseDN;
        private int progressAfterConfigurationUpdate;

        public NewBaseDNTask(ControlPanelInfo info, ProgressDialog dlg) {
            super(info, dlg);
            this.progressAfterConfigurationUpdate = -1;
            this.backendSet = new HashSet<String>();
            this.backendSet.add(NewBaseDNPanel.this.getBackendName());
            this.newBaseDN = NewBaseDNPanel.this.baseDN.getText();
            if (NewBaseDNPanel.this.onlyCreateBaseEntry.isSelected()) {
                this.progressAfterConfigurationUpdate = 40;
            } else if (NewBaseDNPanel.this.leaveDatabaseEmpty.isSelected()) {
                this.progressAfterConfigurationUpdate = 90;
            } else if (NewBaseDNPanel.this.importAutomaticallyGenerated.isSelected()) {
                int nEntries = Integer.parseInt(NewBaseDNPanel.this.numberOfEntries.getText().trim());
                this.progressAfterConfigurationUpdate = nEntries < 500 ? 30 : (nEntries < 3000 ? 15 : 5);
            }
        }

        @Override
        public Task.Type getType() {
            return Task.Type.NEW_BASEDN;
        }

        @Override
        public Message getTaskDescription() {
            return AdminToolMessages.INFO_CTRL_PANEL_NEW_BASE_DN_TASK_DESCRIPTION.get(this.newBaseDN, this.backendSet.iterator().next());
        }

        @Override
        public boolean canLaunch(Task taskToBeLaunched, Collection<Message> incompatibilityReasons) {
            boolean canLaunch = true;
            if (this.state == Task.State.RUNNING && this.runningOnSameServer(taskToBeLaunched)) {
                TreeSet<String> backends = new TreeSet<String>(taskToBeLaunched.getBackends());
                backends.retainAll(this.getBackends());
                if (backends.size() > 0) {
                    incompatibilityReasons.add(this.getIncompatibilityMessage(this, taskToBeLaunched));
                    canLaunch = false;
                }
            }
            return canLaunch;
        }

        private String getDataCommandLineToDisplay() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getDataCommandLineName());
            List<String> args = this.getObfuscatedCommandLineArguments(this.getDataCommandLineArguments(NewBaseDNPanel.this.path.getText(), false));
            args.removeAll(this.getConfigCommandLineArguments());
            for (String arg : args) {
                sb.append(" " + CommandBuilder.escapeValue(arg));
            }
            return sb.toString();
        }

        private String getDataCommandLineName() {
            String cmdLineName = !NewBaseDNPanel.this.leaveDatabaseEmpty.isSelected() ? (NewBaseDNPanel.this.isLocal() ? this.getCommandLinePath("import-ldif") : this.getCommandLinePath("ldapmodify")) : null;
            return cmdLineName;
        }

        private ArrayList<String> getDataCommandLineArguments(String ldifFile, boolean useTemplate) {
            ArrayList<String> args = new ArrayList<String>();
            if (!NewBaseDNPanel.this.leaveDatabaseEmpty.isSelected()) {
                if (NewBaseDNPanel.this.isLocal()) {
                    if (!useTemplate) {
                        args.add("--ldifFile");
                        args.add(ldifFile);
                    } else {
                        args.add("--templateFile");
                        args.add(ldifFile);
                        args.add("--randomSeed");
                        args.add("0");
                    }
                    args.add("--backendID");
                    args.add(NewBaseDNPanel.this.getBackendName());
                    args.add("--append");
                } else {
                    args.add("-a");
                    args.add("-f");
                    args.add(ldifFile);
                }
                args.addAll(this.getConnectionCommandLineArguments(true, !NewBaseDNPanel.this.isLocal()));
                if (this.isServerRunning() && NewBaseDNPanel.this.isLocal()) {
                    args.addAll(this.getConfigCommandLineArguments());
                }
                args.add(this.getNoPropertiesFileArgument());
            }
            return args;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateConfiguration() throws OpenDsException {
            boolean configHandlerUpdated = false;
            try {
                if (!this.isServerRunning()) {
                    this.getInfo().stopPooling();
                    if (this.getInfo().mustDeregisterConfig()) {
                        DirectoryServer.deregisterBaseDN(DN.decode("cn=config"));
                    }
                    DirectoryServer.getInstance().initializeConfiguration(ConfigFileHandler.class.getName(), ConfigReader.configFile);
                    this.getInfo().setMustDeregisterConfig(true);
                    configHandlerUpdated = true;
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            List args = NewBaseDNTask.this.getObfuscatedCommandLineArguments(NewBaseDNTask.this.getDSConfigCommandLineArguments());
                            args.removeAll(NewBaseDNTask.this.getConfigCommandLineArguments());
                            NewBaseDNTask.this.printEquivalentCommandLine(NewBaseDNTask.this.getConfigCommandLineFullPath(), args, AdminToolMessages.INFO_CTRL_PANEL_EQUIVALENT_CMD_TO_CREATE_BASE_DN.get());
                        }
                    });
                }
                if (NewBaseDNPanel.this.isNewBackend()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Message msg = AdminToolMessages.INFO_CTRL_PANEL_CREATING_BACKEND_PROGRESS.get(NewBaseDNPanel.this.getBackendName(), NewBaseDNTask.this.newBaseDN);
                            NewBaseDNTask.this.getProgressDialog().appendProgressHtml(Utilities.getProgressWithPoints(msg, ColorAndFontConstants.progressFont));
                        }
                    });
                    if (this.isServerRunning()) {
                        this.createBackend(this.getInfo().getDirContext(), NewBaseDNPanel.this.getBackendName(), this.newBaseDN);
                    } else {
                        this.createBackend(NewBaseDNPanel.this.getBackendName(), this.newBaseDN);
                        this.createAdditionalIndexes(NewBaseDNPanel.this.getBackendName());
                    }
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Message msg = AdminToolMessages.INFO_CTRL_PANEL_CREATING_BASE_DN_PROGRESS.get(NewBaseDNTask.this.newBaseDN, NewBaseDNPanel.this.getBackendName());
                            NewBaseDNTask.this.getProgressDialog().appendProgressHtml(Utilities.getProgressWithPoints(msg, ColorAndFontConstants.progressFont));
                        }
                    });
                    if (this.isServerRunning()) {
                        this.addBaseDN(this.getInfo().getDirContext(), NewBaseDNPanel.this.getBackendName(), this.newBaseDN);
                    } else {
                        this.addBaseDN(NewBaseDNPanel.this.getBackendName(), this.newBaseDN);
                    }
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        NewBaseDNTask.this.getProgressDialog().appendProgressHtml(Utilities.getProgressDone(ColorAndFontConstants.progressFont) + "<br><br>");
                    }
                });
                if (NewBaseDNPanel.this.isNewBackend() && this.isServerRunning()) {
                    this.createAdditionalIndexes(this.getInfo().getDirContext(), NewBaseDNPanel.this.getBackendName());
                }
                if (this.progressAfterConfigurationUpdate > 0) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            NewBaseDNTask.this.getProgressDialog().getProgressBar().setIndeterminate(false);
                            NewBaseDNTask.this.getProgressDialog().getProgressBar().setValue(NewBaseDNTask.this.progressAfterConfigurationUpdate);
                        }
                    });
                }
            }
            finally {
                if (configHandlerUpdated) {
                    DirectoryServer.getInstance().initializeConfiguration(ConfigReader.configClassName, ConfigReader.configFile);
                    this.getInfo().startPooling();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateData() throws OpenDsException, IOException {
            boolean leaveEmpty = NewBaseDNPanel.this.leaveDatabaseEmpty.isSelected();
            boolean createBaseEntry = NewBaseDNPanel.this.onlyCreateBaseEntry.isSelected();
            boolean importLDIF = NewBaseDNPanel.this.importDataFromLDIF.isSelected();
            boolean generateData = !leaveEmpty && !createBaseEntry && !importLDIF;
            final String nEntries = NewBaseDNPanel.this.numberOfEntries.getText();
            String ldif = NewBaseDNPanel.this.path.getText();
            if (leaveEmpty) {
                this.state = Task.State.FINISHED_SUCCESSFULLY;
            } else {
                String ldifFile;
                final ProgressDialog progressDialog = this.getProgressDialog();
                if (importLDIF) {
                    ldifFile = ldif;
                    final String cmdLine = this.getDataCommandLineToDisplay();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            progressDialog.appendProgressHtml(Utilities.applyFont("Equivalent command line:<br><b>" + cmdLine + "</b><br><br>", ColorAndFontConstants.progressFont));
                        }
                    });
                } else if (createBaseEntry) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            progressDialog.appendProgressHtml(Utilities.getProgressWithPoints(QuickSetupMessages.INFO_PROGRESS_CREATING_BASE_ENTRY.get(NewBaseDNTask.this.newBaseDN), ColorAndFontConstants.progressFont));
                        }
                    });
                    InstallerHelper helper = new InstallerHelper();
                    File f = helper.createBaseEntryTempFile(this.newBaseDN);
                    ldifFile = f.getAbsolutePath();
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (NewBaseDNPanel.this.isLocal()) {
                                progressDialog.appendProgressHtml(Utilities.applyFont(QuickSetupMessages.INFO_PROGRESS_IMPORT_AUTOMATICALLY_GENERATED.get(nEntries).toString(), ColorAndFontConstants.progressFont) + "<br>");
                            } else {
                                NewBaseDNTask.this.getProgressDialog().appendProgressHtml(Utilities.getProgressWithPoints(AdminToolMessages.INFO_PROGRESS_IMPORT_AUTOMATICALLY_GENERATED_REMOTE.get(nEntries), ColorAndFontConstants.progressFont));
                            }
                        }
                    });
                    File f = SetupUtils.createTemplateFile(this.newBaseDN, Integer.parseInt(nEntries));
                    if (!NewBaseDNPanel.this.isLocal()) {
                        File tempFile = File.createTempFile("opendj-control-panel", ".ldif");
                        tempFile.deleteOnExit();
                        ldifFile = tempFile.getAbsolutePath();
                        ArrayList<String> makeLDIFArgs = new ArrayList<String>();
                        makeLDIFArgs.add("--templateFile");
                        makeLDIFArgs.add(f.getAbsolutePath());
                        makeLDIFArgs.add("--ldifFile");
                        makeLDIFArgs.add(ldifFile);
                        makeLDIFArgs.add("--randomSeed");
                        makeLDIFArgs.add("0");
                        makeLDIFArgs.add("--resourcePath");
                        File makeLDIFPath = new File(Installation.getLocal().getConfigurationDirectory(), "MakeLDIF");
                        makeLDIFArgs.add(makeLDIFPath.getAbsolutePath());
                        makeLDIFArgs.addAll(this.getConfigCommandLineArguments());
                        MakeLDIF makeLDIF = new MakeLDIF();
                        String[] array = new String[makeLDIFArgs.size()];
                        makeLDIFArgs.toArray(array);
                        this.returnCode = makeLDIF.makeLDIFMain(array, false, false, this.outPrintStream, this.errorPrintStream);
                        f.delete();
                        if (this.returnCode != 0) {
                            throw new OnlineUpdateException(AdminToolMessages.ERR_CTRL_PANEL_ERROR_CREATING_NEW_DATA_LDIF.get(this.returnCode), null);
                        }
                    } else {
                        ldifFile = f.getAbsolutePath();
                    }
                }
                ArrayList<String> arguments = this.getDataCommandLineArguments(ldifFile, generateData);
                String[] args = new String[arguments.size()];
                arguments.toArray(args);
                if (createBaseEntry || !NewBaseDNPanel.this.isLocal()) {
                    this.outPrintStream.setNotifyListeners(false);
                    this.errorPrintStream.setNotifyListeners(false);
                }
                try {
                    this.returnCode = this.isServerRunning() ? (NewBaseDNPanel.this.isLocal() || importLDIF ? Integer.valueOf(ImportLDIF.mainImportLDIF(args, false, this.outPrintStream, this.errorPrintStream)) : Integer.valueOf(LDAPModify.mainModify(args, false, this.outPrintStream, this.errorPrintStream))) : Integer.valueOf(this.executeCommandLine(this.getDataCommandLineName(), args));
                }
                finally {
                    this.outPrintStream.setNotifyListeners(true);
                    this.errorPrintStream.setNotifyListeners(true);
                }
                if (this.returnCode != 0) {
                    this.state = Task.State.FINISHED_WITH_ERROR;
                } else {
                    if (createBaseEntry || !NewBaseDNPanel.this.isLocal() && generateData) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                progressDialog.appendProgressHtml(Utilities.getProgressDone(ColorAndFontConstants.progressFont));
                            }
                        });
                    }
                    this.state = Task.State.FINISHED_SUCCESSFULLY;
                }
            }
        }

        private void createBackend(InitialLdapContext ctx, String backendName, String baseDN) throws OpenDsException {
            ManagementContext mCtx = LDAPManagementContext.createFromContext(JNDIDirContextAdaptor.adapt(ctx));
            RootCfgClient root = mCtx.getRootConfiguration();
            LocalDBBackendCfgDefn provider = LocalDBBackendCfgDefn.getInstance();
            LocalDBBackendCfgClient backend = root.createBackend(provider, backendName, null);
            backend.setEnabled(true);
            HashSet<DN> baseDNs = new HashSet<DN>();
            baseDNs.add(DN.decode(baseDN));
            backend.setBaseDN(baseDNs);
            backend.setBackendId(backendName);
            backend.setWritabilityMode(BackendCfgDefn.WritabilityMode.ENABLED);
            backend.commit();
        }

        private String getBackendLdif(String backendName) {
            String dn = Utilities.getRDNString("ds-cfg-backend-id", backendName) + ",cn=Backends,cn=config";
            String ldif = Utilities.makeLdif("dn: " + dn, "objectClass: top", "objectClass: ds-cfg-backend", "objectClass: ds-cfg-local-db-backend", "ds-cfg-base-dn: " + this.newBaseDN, "ds-cfg-enabled: true", "ds-cfg-writability-mode: enabled", "ds-cfg-java-class: " + BackendImpl.class.getName(), "ds-cfg-backend-id: " + backendName, "ds-cfg-db-directory: db", "", "dn: cn=Index," + dn, "objectClass: top", "objectClass: ds-cfg-branch", "cn: Index", "", "dn: ds-cfg-attribute=aci,cn=Index," + dn, "objectClass: ds-cfg-local-db-index", "objectClass: top", "ds-cfg-attribute: aci", "ds-cfg-index-type: presence", "", "dn: ds-cfg-attribute=ds-sync-hist,cn=Index," + dn, "objectClass: ds-cfg-local-db-index", "objectClass: top", "ds-cfg-attribute: ds-sync-hist", "ds-cfg-index-type: ordering", "", "dn: ds-cfg-attribute=entryUUID,cn=Index," + dn, "objectClass: ds-cfg-local-db-index", "objectClass: top", "ds-cfg-attribute: entryUUID", "ds-cfg-index-type: equality", "", "dn: ds-cfg-attribute=objectClass,cn=Index," + dn, "objectClass: ds-cfg-local-db-index", "objectClass: top", "ds-cfg-attribute: objectClass", "ds-cfg-index-type: equality");
            return ldif;
        }

        private String getAdditionalIndexLdif(String backendName) {
            String dn = "ds-cfg-backend-id=" + backendName + ",cn=Backends,cn=config";
            String ldif = Utilities.makeLdif("dn: ds-cfg-attribute=cn,cn=Index," + dn, "objectClass: ds-cfg-local-db-index", "objectClass: top", "ds-cfg-attribute: cn", "ds-cfg-index-type: equality", "ds-cfg-index-type: substring", "", "dn: ds-cfg-attribute=givenName,cn=Index," + dn, "objectClass: ds-cfg-local-db-index", "objectClass: top", "ds-cfg-attribute: givenName", "ds-cfg-index-type: equality", "ds-cfg-index-type: substring", "", "dn: ds-cfg-attribute=mail,cn=Index," + dn, "objectClass: ds-cfg-local-db-index", "objectClass: top", "ds-cfg-attribute: mail", "ds-cfg-index-type: equality", "ds-cfg-index-type: substring", "", "dn: ds-cfg-attribute=member,cn=Index," + dn, "objectClass: ds-cfg-local-db-index", "objectClass: top", "ds-cfg-attribute: member", "ds-cfg-index-type: equality", "", "dn: ds-cfg-attribute=sn,cn=Index," + dn, "objectClass: ds-cfg-local-db-index", "objectClass: top", "ds-cfg-attribute: sn", "ds-cfg-index-type: equality", "ds-cfg-index-type: substring", "", "dn: ds-cfg-attribute=telephoneNumber,cn=Index," + dn, "objectClass: ds-cfg-local-db-index", "objectClass: top", "ds-cfg-attribute: telephoneNumber", "ds-cfg-index-type: equality", "ds-cfg-index-type: substring", "", "dn: ds-cfg-attribute=uid,cn=Index," + dn, "objectClass: ds-cfg-local-db-index", "objectClass: top", "ds-cfg-attribute: uid", "ds-cfg-index-type: equality", "", "dn: ds-cfg-attribute=uniqueMember,cn=Index," + dn, "objectClass: ds-cfg-local-db-index", "objectClass: top", "ds-cfg-attribute: uniqueMember", "ds-cfg-index-type: equality");
            return ldif;
        }

        private void createBackend(String backendName, String baseDN) throws OpenDsException {
            LDIFImportConfig ldifImportConfig = null;
            try {
                Entry backendConfigEntry;
                String ldif = this.getBackendLdif(backendName);
                ldifImportConfig = new LDIFImportConfig(new StringReader(ldif));
                LDIFReader reader = new LDIFReader(ldifImportConfig);
                while ((backendConfigEntry = reader.readEntry()) != null) {
                    DirectoryServer.getConfigHandler().addEntry(backendConfigEntry, null);
                }
                DirectoryServer.getConfigHandler().writeUpdatedConfig();
            }
            catch (IOException ioe) {
                throw new OfflineUpdateException(AdminToolMessages.ERR_CTRL_PANEL_ERROR_UPDATING_CONFIGURATION.get(ioe.toString()), (Throwable)ioe);
            }
            finally {
                if (ldifImportConfig != null) {
                    ldifImportConfig.close();
                }
            }
        }

        private void createAdditionalIndexes(String backendName) throws OpenDsException {
            LDIFImportConfig ldifImportConfig = null;
            try {
                Entry indexEntry;
                String ldif = this.getAdditionalIndexLdif(backendName);
                ldifImportConfig = new LDIFImportConfig(new StringReader(ldif));
                LDIFReader reader = new LDIFReader(ldifImportConfig);
                while ((indexEntry = reader.readEntry()) != null) {
                    DirectoryServer.getConfigHandler().addEntry(indexEntry, null);
                }
                DirectoryServer.getConfigHandler().writeUpdatedConfig();
            }
            catch (IOException ioe) {
                throw new OfflineUpdateException(AdminToolMessages.ERR_CTRL_PANEL_ERROR_UPDATING_CONFIGURATION.get(ioe.toString()), (Throwable)ioe);
            }
            finally {
                if (ldifImportConfig != null) {
                    ldifImportConfig.close();
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private void createAdditionalIndexes(InitialLdapContext ctx, String backendName) throws OpenDsException {
            ArrayList argsArray = new ArrayList();
            ArrayList<String> dns = new ArrayList<String>();
            ArrayList<BasicAttributes> attributes = new ArrayList<BasicAttributes>();
            String ldif = this.getAdditionalIndexLdif(backendName);
            LDIFImportConfig ldifImportConfig = null;
            try {
                void var12_17;
                Entry indexEntry;
                ldifImportConfig = new LDIFImportConfig(new StringReader(ldif));
                LDIFReader reader = new LDIFReader(ldifImportConfig);
                while ((indexEntry = reader.readEntry()) != null) {
                    ArrayList<String> args = new ArrayList<String>();
                    args.add("create-local-db-index");
                    args.add("--backend-name");
                    args.add(backendName);
                    args.add("--type");
                    args.add("generic");
                    argsArray.add(args);
                    BasicAttributes attrs = new BasicAttributes();
                    BasicAttribute basicAttribute = new BasicAttribute("objectClass");
                    Iterator<AttributeValue> it = indexEntry.getObjectClassAttribute().iterator();
                    while (it.hasNext()) {
                        basicAttribute.add(it.next().getValue().toString());
                    }
                    attrs.put(basicAttribute);
                    List<Attribute> odsAttrs = indexEntry.getAttributes();
                    for (Attribute odsAttr : odsAttrs) {
                        String attrName = odsAttr.getName();
                        BasicAttribute attr = new BasicAttribute(attrName);
                        it = odsAttr.iterator();
                        while (it.hasNext()) {
                            attr.add(it.next().getValue().toString());
                        }
                        attrs.put(attr);
                        if (attrName.equalsIgnoreCase("ds-cfg-attribute")) {
                            args.add("--index-name");
                            AttributeValue value = odsAttr.iterator().next();
                            args.add(value.getValue().toString());
                            continue;
                        }
                        if (!attrName.equalsIgnoreCase("ds-cfg-index-type")) continue;
                        it = odsAttr.iterator();
                        while (it.hasNext()) {
                            args.add("--set");
                            args.add("index-type:" + it.next().getValue().toString());
                        }
                    }
                    args.addAll(this.getConnectionCommandLineArguments());
                    args.add(this.getNoPropertiesFileArgument());
                    args.add("--no-prompt");
                    dns.add(indexEntry.getDN().toString());
                    attributes.add(attrs);
                }
                StringBuilder sb = new StringBuilder();
                for (ArrayList arrayList : argsArray) {
                    sb.append(NewBaseDNTask.getEquivalentCommandLine(this.getCommandLinePath("dsconfig"), this.getObfuscatedCommandLineArguments(arrayList)));
                    sb.append("<br><br>");
                }
                final String cmdLines = sb.toString();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        NewBaseDNTask.this.getProgressDialog().appendProgressHtml(Utilities.applyFont(AdminToolMessages.INFO_CTRL_PANEL_EQUIVALENT_CMD_TO_CREATE_ADDITIONAL_INDEXES.get() + "<br><br><b>" + cmdLines + "</b>", ColorAndFontConstants.progressFont));
                        NewBaseDNTask.this.getProgressDialog().appendProgressHtml(Utilities.getProgressWithPoints(AdminToolMessages.INFO_CTRL_PANEL_CREATING_ADDITIONAL_INDEXES_PROGRESS.get(), ColorAndFontConstants.progressFont));
                    }
                });
                boolean bl = false;
                while (var12_17 < dns.size()) {
                    ctx.createSubcontext((String)dns.get((int)var12_17), (Attributes)attributes.get((int)var12_17));
                    ++var12_17;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        NewBaseDNTask.this.getProgressDialog().appendProgressHtml(Utilities.getProgressDone(ColorAndFontConstants.progressFont) + "<br><br>");
                    }
                });
            }
            catch (Throwable t) {
                throw new OnlineUpdateException(AdminToolMessages.ERR_CTRL_PANEL_ERROR_UPDATING_CONFIGURATION.get(t.toString()), t);
            }
            finally {
                if (ldifImportConfig != null) {
                    ldifImportConfig.close();
                }
            }
        }

        private void addBaseDN(String backendName, String baseDN) throws OpenDsException {
            LinkedList<DN> baseDNs = new LinkedList<DN>();
            for (BackendDescriptor backend : this.getInfo().getServerDescriptor().getBackends()) {
                if (!backend.getBackendID().equalsIgnoreCase(backendName)) continue;
                for (BaseDNDescriptor b : backend.getBaseDns()) {
                    baseDNs.add(b.getDn());
                }
            }
            baseDNs.add(DN.decode(baseDN));
            String dn = Utilities.getRDNString("ds-cfg-backend-id", backendName) + ",cn=Backends,cn=config";
            ConfigEntry configEntry = DirectoryServer.getConfigHandler().getConfigEntry(DN.decode(dn));
            DNConfigAttribute baseDNAttr = new DNConfigAttribute("ds-cfg-base-dn", ConfigMessages.INFO_CONFIG_BACKEND_ATTR_DESCRIPTION_BASE_DNS.get(), true, true, false, baseDNs);
            configEntry.putConfigAttribute(baseDNAttr);
            DirectoryServer.getConfigHandler().writeUpdatedConfig();
        }

        private void addBaseDN(InitialLdapContext ctx, String backendName, String baseDN) throws OpenDsException {
            ManagementContext mCtx = LDAPManagementContext.createFromContext(JNDIDirContextAdaptor.adapt(ctx));
            RootCfgClient root = mCtx.getRootConfiguration();
            LocalDBBackendCfgClient backend = (LocalDBBackendCfgClient)root.getBackend(backendName);
            SortedSet<DN> baseDNs = backend.getBaseDN();
            DN dn = DN.decode(baseDN);
            baseDNs.add(dn);
            backend.setBaseDN(baseDNs);
            backend.commit();
        }

        @Override
        protected String getCommandLinePath() {
            return null;
        }

        protected ArrayList<String> getCommandLineArguments() {
            return new ArrayList<String>();
        }

        private String getConfigCommandLineFullPath() {
            if (this.isServerRunning()) {
                return this.getCommandLinePath("dsconfig");
            }
            return null;
        }

        private ArrayList<String> getDSConfigCommandLineArguments() {
            ArrayList<String> args = new ArrayList<String>();
            if (this.isServerRunning()) {
                if (NewBaseDNPanel.this.isNewBackend()) {
                    args.add("create-backend");
                    args.add("--backend-name");
                    args.add(NewBaseDNPanel.this.getBackendName());
                    args.add("--set");
                    args.add("base-dn:" + this.newBaseDN);
                    args.add("--set");
                    args.add("enabled:true");
                    args.add("--type");
                    args.add("local-db");
                } else {
                    args.add("set-backend-prop");
                    args.add("--backend-name");
                    args.add(NewBaseDNPanel.this.getBackendName());
                    args.add("--add");
                    args.add("base-dn:" + this.newBaseDN);
                }
                args.addAll(this.getConnectionCommandLineArguments());
                args.add(this.getNoPropertiesFileArgument());
                args.add("--no-prompt");
            }
            return args;
        }

        @Override
        public void runTask() {
            this.state = Task.State.RUNNING;
            this.lastException = null;
            try {
                this.updateConfiguration();
                this.updateData();
            }
            catch (Throwable t) {
                this.lastException = t;
                this.state = Task.State.FINISHED_WITH_ERROR;
            }
        }

        @Override
        public Set<String> getBackends() {
            return this.backendSet;
        }
    }
}

