/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import javax.swing.JEditorPane;
import org.opends.guitools.controlpanel.event.ConfigurationChangeEvent;
import org.opends.guitools.controlpanel.ui.ColorAndFontConstants;
import org.opends.guitools.controlpanel.ui.StatusGenericPanel;
import org.opends.guitools.controlpanel.ui.components.AddRemovePanel;
import org.opends.guitools.controlpanel.ui.renderer.SchemaElementComboBoxCellRenderer;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.Schema;

public class SelectObjectClassesPanel
extends StatusGenericPanel {
    private static final long serialVersionUID = 1230982500028334L;
    private AddRemovePanel<ObjectClass> addRemove = new AddRemovePanel<ObjectClass>(ObjectClass.class);
    private Set<ObjectClass> toExclude = new HashSet<ObjectClass>();
    private Schema schema;
    private boolean isCanceled = true;

    public SelectObjectClassesPanel() {
        this.createLayout();
    }

    private void createLayout() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.weightx = 0.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        JEditorPane instructions = Utilities.makePlainTextPane(AdminToolMessages.INFO_CTRL_PANEL_SUPERIOR_OBJECTCLASSES_INSTRUCTIONS.get().toString(), ColorAndFontConstants.defaultFont);
        gbc.weightx = 1.0;
        gbc.fill = 2;
        this.add((Component)instructions, gbc);
        ++gbc.gridy;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.addRemove.getAvailableLabel().setText(AdminToolMessages.INFO_CTRL_PANEL_ADDREMOVE_AVAILABLE_OBJECTCLASSES.get().toString());
        this.addRemove.getSelectedLabel().setText(AdminToolMessages.INFO_CTRL_PANEL_ADDREMOVE_SELECTED_OBJECTCLASSES.get().toString());
        Comparator<ObjectClass> comparator = new Comparator<ObjectClass>(){

            @Override
            public int compare(ObjectClass oc1, ObjectClass oc2) {
                return oc1.getNameOrOID().toLowerCase().compareTo(oc2.getNameOrOID().toLowerCase());
            }
        };
        this.addRemove.getAvailableListModel().setComparator(comparator);
        this.addRemove.getSelectedListModel().setComparator(comparator);
        SchemaElementComboBoxCellRenderer renderer = new SchemaElementComboBoxCellRenderer(this.addRemove.getAvailableList());
        this.addRemove.getAvailableList().setCellRenderer(renderer);
        renderer = new SchemaElementComboBoxCellRenderer(this.addRemove.getSelectedList());
        this.addRemove.getSelectedList().setCellRenderer(renderer);
        gbc.insets.top = 10;
        this.add(this.addRemove, gbc);
    }

    @Override
    public Component getPreferredFocusComponent() {
        return this.addRemove;
    }

    @Override
    public Message getTitle() {
        return AdminToolMessages.INFO_CTRL_PANEL_SUPERIOR_OBJECTCLASSES_TITLE.get();
    }

    @Override
    public void okClicked() {
        this.isCanceled = true;
        SortedSet<ObjectClass> selectedObjectClasses = this.addRemove.getSelectedListModel().getData();
        if (selectedObjectClasses.isEmpty()) {
            this.displayErrorMessage(AdminToolMessages.INFO_CTRL_PANEL_ERROR_DIALOG_TITLE.get(), AdminToolMessages.INFO_CTRL_PANEL_ERROR_NO_SUPERIOR_SELECTED.get());
        } else {
            this.isCanceled = false;
            this.closeClicked();
        }
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    @Override
    public void toBeDisplayed(boolean visible) {
        if (visible) {
            this.isCanceled = true;
        }
    }

    @Override
    public void configurationChanged(ConfigurationChangeEvent ev) {
    }

    public Set<ObjectClass> getSelectedObjectClasses() {
        return this.addRemove.getSelectedListModel().getData();
    }

    public void setSelectedObjectClasses(Set<ObjectClass> selectedObjectClasses) {
        HashSet<ObjectClass> toAdd = new HashSet<ObjectClass>();
        SortedSet<ObjectClass> previouslySelected = this.addRemove.getSelectedListModel().getData();
        for (ObjectClass oc : previouslySelected) {
            if (selectedObjectClasses.contains(oc)) continue;
            this.addRemove.getSelectedListModel().remove(oc);
            toAdd.add(oc);
        }
        this.addRemove.getAvailableListModel().addAll(toAdd);
        for (ObjectClass oc : selectedObjectClasses) {
            if (!previouslySelected.contains(oc)) {
                this.addRemove.getSelectedListModel().add(oc);
            }
            this.addRemove.getAvailableListModel().remove(oc);
        }
        this.fireAddRemoveNotifications();
    }

    public void setObjectClassesToExclude(Set<ObjectClass> toExclude) {
        this.toExclude.clear();
        this.toExclude.addAll(toExclude);
        this.updateWithSchema(this.schema);
        this.fireAddRemoveNotifications();
    }

    public void setSchema(Schema schema) {
        this.updateWithSchema(schema);
        this.fireAddRemoveNotifications();
    }

    private void updateWithSchema(Schema schema) {
        ArrayList<ObjectClass> allOcs = new ArrayList<ObjectClass>();
        for (String key : schema.getObjectClasses().keySet()) {
            ObjectClass oc = schema.getObjectClass(key);
            if (this.toExclude.contains(oc)) continue;
            allOcs.add(oc);
        }
        for (ObjectClass oc : this.addRemove.getSelectedListModel().getData()) {
            if (!allOcs.contains(oc)) {
                this.addRemove.getSelectedListModel().remove(oc);
                continue;
            }
            allOcs.remove(oc);
        }
        this.addRemove.getAvailableListModel().clear();
        this.addRemove.getAvailableListModel().addAll(allOcs);
        this.schema = schema;
    }

    public Set<ObjectClass> getObjectClassToExclude() {
        return Collections.unmodifiableSet(this.toExclude);
    }

    private void fireAddRemoveNotifications() {
        this.addRemove.getSelectedListModel().fireContentsChanged(this, 0, this.addRemove.getSelectedListModel().getSize() - 1);
        this.addRemove.getAvailableListModel().fireContentsChanged(this, 0, this.addRemove.getAvailableListModel().getSize() - 1);
    }
}

